/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import vswe.superfactory.blocks.ConnectionBlock;
import vswe.superfactory.blocks.ConnectionBlockType;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.ComponentMenuCamouflageInside;
import vswe.superfactory.components.ComponentMenuCamouflageItems;
import vswe.superfactory.components.ComponentMenuCamouflageShape;
import vswe.superfactory.components.ComponentMenuCamouflageSides;
import vswe.superfactory.components.ComponentMenuContainer;
import vswe.superfactory.components.ComponentMenuContainerScrap;
import vswe.superfactory.components.ComponentMenuContainerTypes;
import vswe.superfactory.components.ComponentMenuCrafting;
import vswe.superfactory.components.ComponentMenuCraftingPriority;
import vswe.superfactory.components.ComponentMenuListOrder;
import vswe.superfactory.components.ComponentMenuPulse;
import vswe.superfactory.components.ComponentMenuRedstoneOutput;
import vswe.superfactory.components.ComponentMenuRedstoneSidesEmitter;
import vswe.superfactory.components.ComponentMenuSignText;
import vswe.superfactory.components.ComponentMenuSplit;
import vswe.superfactory.components.ComponentMenuStuff;
import vswe.superfactory.components.ComponentMenuTargetInventory;
import vswe.superfactory.components.ComponentMenuTargetTank;
import vswe.superfactory.components.ComponentMenuVariable;
import vswe.superfactory.components.ComponentMenuVariableLoop;
import vswe.superfactory.components.ConditionSettingChecker;
import vswe.superfactory.components.Connection;
import vswe.superfactory.components.CraftingBufferElement;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.FluidBufferElement;
import vswe.superfactory.components.Variable;
import vswe.superfactory.components.VariableColor;
import vswe.superfactory.components.internal.ConnectionOption;
import vswe.superfactory.components.internal.FluidSetting;
import vswe.superfactory.components.internal.IConditionStuffMenu;
import vswe.superfactory.components.internal.IItemBufferElement;
import vswe.superfactory.components.internal.IItemBufferSubElement;
import vswe.superfactory.components.internal.ItemBufferElement;
import vswe.superfactory.components.internal.ItemSetting;
import vswe.superfactory.components.internal.OutputFluidCounter;
import vswe.superfactory.components.internal.OutputItemCounter;
import vswe.superfactory.components.internal.Setting;
import vswe.superfactory.components.internal.SideSlotTarget;
import vswe.superfactory.components.internal.SlotInventoryHolder;
import vswe.superfactory.components.internal.SlotStackInventoryHolder;
import vswe.superfactory.components.internal.StackTankHolder;
import vswe.superfactory.tiles.TileEntityManager;

public class CommandExecutor {
    public static final int MAX_FLUID_TRANSFER = 10000000;
    final List<CraftingBufferElement> craftingBufferHigh;
    final List<CraftingBufferElement> craftingBufferLow;
    final List<FluidBufferElement> fluidBuffer;
    protected final List<ItemBufferElement> itemBuffer;
    private final TileEntityManager manager;
    private final List<Integer> usedCommands;

    public CommandExecutor(TileEntityManager manager) {
        this.manager = manager;
        this.itemBuffer = new ArrayList<ItemBufferElement>();
        this.craftingBufferHigh = new ArrayList<CraftingBufferElement>();
        this.craftingBufferLow = new ArrayList<CraftingBufferElement>();
        this.fluidBuffer = new ArrayList<FluidBufferElement>();
        this.usedCommands = new ArrayList<Integer>();
    }

    private CommandExecutor(TileEntityManager manager, List<ItemBufferElement> itemBufferSplit, List<CraftingBufferElement> craftingBufferHighSplit, List<CraftingBufferElement> craftingBufferLowSplit, List<FluidBufferElement> fluidBufferSplit, List<Integer> usedCommandCopy) {
        this.manager = manager;
        this.itemBuffer = itemBufferSplit;
        this.craftingBufferHigh = craftingBufferHighSplit;
        this.craftingBufferLow = craftingBufferLowSplit;
        this.usedCommands = usedCommandCopy;
        this.fluidBuffer = fluidBufferSplit;
    }

    public static List<SlotInventoryHolder> getContainers(TileEntityManager manager, ComponentMenu componentMenu, ConnectionBlockType type) {
        int i;
        ComponentMenuContainer menuContainer = (ComponentMenuContainer)componentMenu;
        if (menuContainer.getSelectedInventories().size() == 0) {
            return new ArrayList<SlotInventoryHolder>();
        }
        ArrayList<SlotInventoryHolder> ret = new ArrayList<SlotInventoryHolder>();
        List<ConnectionBlock> inventories = manager.getConnectedInventories();
        Variable[] variables = manager.getVariables();
        for (i = 0; i < variables.length; ++i) {
            Variable variable = variables[i];
            if (!variable.isValid()) continue;
            for (int val : menuContainer.getSelectedInventories()) {
                if (val != i) continue;
                List<Integer> selection = variable.getContainers();
                for (int selected : selection) {
                    CommandExecutor.addContainer(inventories, ret, selected, menuContainer, type, ((ComponentMenuContainerTypes)variable.getDeclaration().getMenus().get(1)).getValidTypes());
                }
            }
        }
        for (i = 0; i < menuContainer.getSelectedInventories().size(); ++i) {
            int selected = menuContainer.getSelectedInventories().get(i) - VariableColor.values().length;
            CommandExecutor.addContainer(inventories, ret, selected, menuContainer, type, EnumSet.allOf(ConnectionBlockType.class));
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    private static void addContainer(List<ConnectionBlock> inventories, List<SlotInventoryHolder> ret, int selected, ComponentMenuContainer menuContainer, ConnectionBlockType requestType, EnumSet<ConnectionBlockType> variableType) {
        ConnectionBlock connection;
        if (selected >= 0 && selected < inventories.size() && (connection = inventories.get(selected)).isOfType(requestType) && connection.isOfAnyType(variableType) && !connection.getTileEntity().func_145837_r() && !CommandExecutor.containsTe(ret, connection.getTileEntity())) {
            ret.add(new SlotInventoryHolder(selected, connection.getTileEntity(), menuContainer.getOption()));
        }
    }

    private static boolean containsTe(List<SlotInventoryHolder> lst, TileEntity te) {
        for (SlotInventoryHolder slotInventoryHolder : lst) {
            if (!slotInventoryHolder.getTile().func_174877_v().equals((Object)te.func_174877_v()) || !slotInventoryHolder.getTile().getClass().equals(te.getClass())) continue;
            return true;
        }
        return false;
    }

    public static void prepareValidSlots(ComponentMenu componentMenu, List<SlotInventoryHolder> inventories) {
        ComponentMenuTargetInventory menuTarget = (ComponentMenuTargetInventory)componentMenu;
        for (SlotInventoryHolder holder : inventories) {
            Map<EnumFacing, SideSlotTarget> validSlots = holder.getValidSlots();
            for (EnumFacing side : EnumFacing.field_82609_l) {
                int sideI = side.ordinal();
                IItemHandler handler = holder.getInventory(side);
                if (handler == null || !menuTarget.isActive(sideI)) continue;
                int[] reportedSlots = new int[handler.getSlots()];
                for (int j = 0; j < reportedSlots.length; ++j) {
                    reportedSlots[j] = j;
                }
                int start = 0;
                int end = reportedSlots.length;
                if (menuTarget.useAdvancedSetting(sideI)) {
                    start = menuTarget.getStart(sideI);
                    end = menuTarget.getEnd(sideI);
                }
                if (start > end) continue;
                for (int slot : reportedSlots) {
                    if (slot < start || slot > end) continue;
                    validSlots.computeIfAbsent(side, SideSlotTarget::new).addSlot(slot);
                }
            }
        }
    }

    public static boolean canExtractStack(IItemHandler handler, int slot) {
        return CommandExecutor.canExtractStack(handler, slot, handler.getStackInSlot(slot));
    }

    public static boolean canExtractStack(IItemHandler handler, int slot, ItemStack stack) {
        if (!stack.func_190926_b()) {
            return !handler.extractItem(slot, stack.func_77976_d(), true).func_190926_b();
        }
        return false;
    }

    public static boolean canInsertStack(IItemHandler handler, int slot) {
        return CommandExecutor.canInsertStack(handler, slot, handler.getStackInSlot(slot));
    }

    public static boolean canInsertStack(IItemHandler handler, int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            return true;
        }
        return handler.insertItem(slot, stack, true) != stack;
    }

    public void executeTriggerCommand(FlowComponent command, EnumSet<ConnectionOption> validTriggerOutputs) {
        for (Variable variable : this.manager.getVariables()) {
            if (!variable.isValid() || variable.hasBeenExecuted() && ((ComponentMenuVariable)variable.getDeclaration().getMenus().get(0)).getVariableMode() != ComponentMenuVariable.VariableMode.LOCAL) continue;
            this.executeCommand(variable.getDeclaration(), 0);
            variable.setExecuted(true);
        }
        this.executeChildCommands(command, validTriggerOutputs);
    }

    private void executeChildCommands(FlowComponent command, EnumSet<ConnectionOption> validTriggerOutputs) {
        for (int i = 0; i < command.getConnectionSet().getConnections().length; ++i) {
            Connection connection = command.getConnection(i);
            ConnectionOption option = command.getConnectionSet().getConnections()[i];
            if (connection == null || option.isInput() || !validTriggerOutputs.contains((Object)option)) continue;
            this.executeCommand(this.manager.getFlowItems().get(connection.getComponentId()), connection.getConnectionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(FlowComponent command, int connectionId) {
        if (this.usedCommands.contains(command.getId())) {
            return;
        }
        try {
            this.usedCommands.add(command.getId());
            switch (command.getType()) {
                case INPUT: {
                    List<SlotInventoryHolder> inputInventory = this.getInventories(command.getMenus().get(0));
                    if (inputInventory == null) break;
                    CommandExecutor.prepareValidSlots(command.getMenus().get(1), inputInventory);
                    this.getItems(command.getMenus().get(2), inputInventory);
                    break;
                }
                case OUTPUT: {
                    List<SlotInventoryHolder> outputInventory = this.getInventories(command.getMenus().get(0));
                    if (outputInventory == null) break;
                    CommandExecutor.prepareValidSlots(command.getMenus().get(1), outputInventory);
                    this.insertItems(command.getMenus().get(2), outputInventory);
                    break;
                }
                case CONDITION: {
                    List<SlotInventoryHolder> conditionInventory = this.getInventories(command.getMenus().get(0));
                    if (conditionInventory != null) {
                        CommandExecutor.prepareValidSlots(command.getMenus().get(1), conditionInventory);
                        if (this.searchForStuff(command.getMenus().get(2), conditionInventory, false)) {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_TRUE));
                        } else {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_FALSE));
                        }
                    }
                    return;
                }
                case FLUID_INPUT: {
                    List<SlotInventoryHolder> inputTank = this.getTanks(command.getMenus().get(0));
                    if (inputTank == null) break;
                    this.getValidTanks(command.getMenus().get(1), inputTank);
                    this.getFluids(command.getMenus().get(2), inputTank);
                    break;
                }
                case FLUID_OUTPUT: {
                    List<SlotInventoryHolder> outputTank = this.getTanks(command.getMenus().get(0));
                    if (outputTank == null) break;
                    this.getValidTanks(command.getMenus().get(1), outputTank);
                    this.insertFluids(command.getMenus().get(2), outputTank);
                    break;
                }
                case FLUID_CONDITION: {
                    List<SlotInventoryHolder> conditionTank = this.getTanks(command.getMenus().get(0));
                    if (conditionTank != null) {
                        this.getValidTanks(command.getMenus().get(1), conditionTank);
                        if (this.searchForStuff(command.getMenus().get(2), conditionTank, true)) {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_TRUE));
                        } else {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_FALSE));
                        }
                    }
                    return;
                }
                case FLOW_CONTROL: {
                    if (!ComponentMenuSplit.isSplitConnection(command) || !this.splitFlow(command.getMenus().get(0))) break;
                    return;
                }
                case REDSTONE_EMITTER: {
                    List<SlotInventoryHolder> emitters = this.getEmitters(command.getMenus().get(0));
                    if (emitters == null) break;
                    for (SlotInventoryHolder emitter : emitters) {
                        emitter.getEmitter().updateState((ComponentMenuRedstoneSidesEmitter)command.getMenus().get(1), (ComponentMenuRedstoneOutput)command.getMenus().get(2), (ComponentMenuPulse)command.getMenus().get(3));
                    }
                    break;
                }
                case REDSTONE_CONDITION: {
                    List<SlotInventoryHolder> nodes = this.getNodes(command.getMenus().get(0));
                    if (nodes != null) {
                        if (this.evaluateRedstoneCondition(nodes, command)) {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_TRUE));
                        } else {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_FALSE));
                        }
                    }
                    return;
                }
                case VARIABLE: {
                    List<SlotInventoryHolder> tiles = this.getTiles(command.getMenus().get(2));
                    if (tiles == null) break;
                    this.updateVariable(tiles, (ComponentMenuVariable)command.getMenus().get(0), (ComponentMenuListOrder)command.getMenus().get(3));
                    break;
                }
                case FOR_EACH: {
                    this.updateForLoop(command, (ComponentMenuVariableLoop)command.getMenus().get(0), (ComponentMenuContainerTypes)command.getMenus().get(1), (ComponentMenuListOrder)command.getMenus().get(2));
                    this.executeChildCommands(command, EnumSet.of(ConnectionOption.STANDARD_OUTPUT));
                    return;
                }
                case AUTO_CRAFTING: {
                    CraftingBufferElement element = new CraftingBufferElement(this, (ComponentMenuCrafting)command.getMenus().get(0), (ComponentMenuContainerScrap)command.getMenus().get(2));
                    if (((ComponentMenuCraftingPriority)command.getMenus().get(1)).shouldPrioritizeCrafting()) {
                        this.craftingBufferHigh.add(element);
                        break;
                    }
                    this.craftingBufferLow.add(element);
                    break;
                }
                case GROUP: {
                    if (connectionId < command.getChildrenInputNodes().size()) {
                        this.executeChildCommands(command.getChildrenInputNodes().get(connectionId), EnumSet.allOf(ConnectionOption.class));
                    }
                    return;
                }
                case NODE: {
                    FlowComponent parent = command.getParent();
                    if (parent != null) {
                        for (int i = 0; i < parent.getChildrenOutputNodes().size(); ++i) {
                            if (!command.equals(parent.getChildrenOutputNodes().get(i))) continue;
                            Connection connection = parent.getConnection(parent.getConnectionSet().getInputCount() + i);
                            if (connection == null) break;
                            this.executeCommand(this.manager.getFlowItems().get(connection.getComponentId()), connection.getConnectionId());
                            break;
                        }
                    }
                    return;
                }
                case CAMOUFLAGE: {
                    List<SlotInventoryHolder> camouflage = this.getCamouflage(command.getMenus().get(0));
                    if (camouflage == null) break;
                    ComponentMenuCamouflageShape shape = (ComponentMenuCamouflageShape)command.getMenus().get(1);
                    ComponentMenuCamouflageInside inside = (ComponentMenuCamouflageInside)command.getMenus().get(2);
                    ComponentMenuCamouflageSides sides = (ComponentMenuCamouflageSides)command.getMenus().get(3);
                    ComponentMenuCamouflageItems items = (ComponentMenuCamouflageItems)command.getMenus().get(4);
                    if (!items.isFirstRadioButtonSelected() && !items.getSettings().get(0).isValid()) break;
                    ItemStack itemStack = items.isFirstRadioButtonSelected() ? ItemStack.field_190927_a : ((ItemSetting)items.getSettings().get(0)).getItem();
                    for (SlotInventoryHolder slotInventoryHolder : camouflage) {
                        slotInventoryHolder.getCamouflage().setBounds(shape);
                        for (int i = 0; i < EnumFacing.values().length; ++i) {
                            if (!sides.isSideRequired(i)) continue;
                            slotInventoryHolder.getCamouflage().setItem(itemStack, i, inside.getCurrentType());
                        }
                    }
                    break;
                }
                case SIGN: {
                    List<SlotInventoryHolder> sign = this.getSign(command.getMenus().get(0));
                    if (sign == null) break;
                    for (SlotInventoryHolder slotInventoryHolder : sign) {
                        slotInventoryHolder.getSign().updateSign((ComponentMenuSignText)command.getMenus().get(1));
                    }
                    break;
                }
            }
            this.executeChildCommands(command, EnumSet.allOf(ConnectionOption.class));
        }
        finally {
            this.usedCommands.remove((Object)command.getId());
        }
    }

    private List<SlotInventoryHolder> getEmitters(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, ConnectionBlockType.EMITTER);
    }

    private List<SlotInventoryHolder> getInventories(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, ConnectionBlockType.INVENTORY);
    }

    private List<SlotInventoryHolder> getTanks(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, ConnectionBlockType.TANK);
    }

    private List<SlotInventoryHolder> getNodes(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, ConnectionBlockType.NODE);
    }

    private List<SlotInventoryHolder> getCamouflage(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, ConnectionBlockType.CAMOUFLAGE);
    }

    private List<SlotInventoryHolder> getSign(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, ConnectionBlockType.SIGN);
    }

    private List<SlotInventoryHolder> getTiles(ComponentMenu componentMenu) {
        return CommandExecutor.getContainers(this.manager, componentMenu, null);
    }

    private void getValidTanks(ComponentMenu componentMenu, List<SlotInventoryHolder> tanks) {
        ComponentMenuTargetTank menuTarget = (ComponentMenuTargetTank)componentMenu;
        for (int i = 0; i < tanks.size(); ++i) {
            Map<EnumFacing, SideSlotTarget> validTanks = tanks.get(i).getValidSlots();
            for (EnumFacing side : EnumFacing.field_82609_l) {
                IFluidHandler tank = tanks.get(i).getTank(side);
                int sideI = side.ordinal();
                if (!menuTarget.isActive(sideI)) continue;
                if (menuTarget.useAdvancedSetting(sideI)) {
                    boolean empty = true;
                    for (IFluidTankProperties fluidTankInfo : tank.getTankProperties()) {
                        if (fluidTankInfo.getContents() == null || fluidTankInfo.getContents().amount <= 0) continue;
                        empty = false;
                        break;
                    }
                    if (empty != menuTarget.requireEmpty(sideI)) continue;
                }
                validTanks.computeIfAbsent(side, SideSlotTarget::new).addSlot(0);
            }
        }
    }

    private boolean isSlotValid(IItemHandler handler, ItemStack stack, int slot, boolean isSource) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (isSource) {
            return CommandExecutor.canExtractStack(handler, slot, stack);
        }
        return CommandExecutor.canInsertStack(handler, slot, stack);
    }

    private void getItems(ComponentMenu componentMenu, List<SlotInventoryHolder> inventories) {
        for (SlotInventoryHolder inventoryHolder : inventories) {
            ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
            IdentityHashMap seenStacks = new IdentityHashMap();
            for (SideSlotTarget sideSlotTarget : inventoryHolder.getValidSlots().values()) {
                IItemHandler inventory = inventoryHolder.getInventory(sideSlotTarget.getSide());
                for (int slot : sideSlotTarget.getSlots()) {
                    ItemStack itemStack = inventory.getStackInSlot(slot);
                    if (seenStacks.containsKey(itemStack) || !this.isSlotValid(inventory, itemStack, slot, true)) continue;
                    seenStacks.put(itemStack, null);
                    ItemSetting setting = this.getStackSetting(componentMenu, itemStack);
                    this.addItemToBuffer(menuItem, inventoryHolder, setting, itemStack, sideSlotTarget.getSide(), slot);
                }
            }
        }
    }

    private void addItemToBuffer(ComponentMenuStuff menuItem, SlotInventoryHolder inventory, Setting setting, ItemStack itemStack, EnumFacing side, int slot) {
        if (menuItem.useWhiteList() == (setting != null) || setting != null && setting.isLimitedByAmount()) {
            FlowComponent owner = menuItem.getParent();
            SlotStackInventoryHolder target = new SlotStackInventoryHolder(itemStack, inventory.getInventory(side), slot);
            boolean added = false;
            for (ItemBufferElement itemBufferElement : this.itemBuffer) {
                if (!itemBufferElement.addTarget(owner, setting, inventory, target)) continue;
                added = true;
                break;
            }
            if (!added) {
                ItemBufferElement itemBufferElement = new ItemBufferElement(owner, setting, inventory, menuItem.useWhiteList(), target);
                this.itemBuffer.add(itemBufferElement);
            }
        }
    }

    private void getFluids(ComponentMenu componentMenu, List<SlotInventoryHolder> tanks) {
        for (SlotInventoryHolder inventoryHolder : tanks) {
            ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
            ArrayList<IFluidTankProperties> tankInfos = new ArrayList<IFluidTankProperties>();
            for (EnumFacing side : inventoryHolder.getValidSlots().keySet()) {
                try {
                    IFluidHandler tank = inventoryHolder.getTank(side);
                    IFluidTankProperties[] currentTankInfos = tank.getTankProperties();
                    if (currentTankInfos == null) continue;
                    for (IFluidTankProperties fluidTankInfo : currentTankInfos) {
                        FluidStack fluidStack;
                        if (fluidTankInfo == null) continue;
                        boolean alreadyUsed = false;
                        for (IFluidTankProperties tankInfo : tankInfos) {
                            if (!FluidStack.areFluidStackTagsEqual((FluidStack)tankInfo.getContents(), (FluidStack)fluidTankInfo.getContents()) || tankInfo.getCapacity() != fluidTankInfo.getCapacity()) continue;
                            alreadyUsed = true;
                        }
                        if (alreadyUsed || (fluidStack = fluidTankInfo.getContents()) == null) continue;
                        fluidStack = fluidStack.copy();
                        Setting setting = this.getFluidSetting(componentMenu, fluidStack);
                        this.addFluidToBuffer(menuItem, inventoryHolder, tank, setting, fluidStack, side);
                    }
                    for (IFluidTankProperties fluidTankInfo : tank.getTankProperties()) {
                        if (fluidTankInfo == null) continue;
                        tankInfos.add(fluidTankInfo);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }

    private void addFluidToBuffer(ComponentMenuStuff menuItem, SlotInventoryHolder inventoryHolder, IFluidHandler tank, Setting setting, FluidStack fluidStack, EnumFacing side) {
        if (menuItem.useWhiteList() == (setting != null) || setting != null && setting.isLimitedByAmount()) {
            FlowComponent owner = menuItem.getParent();
            StackTankHolder target = new StackTankHolder(fluidStack, tank, side);
            boolean added = false;
            for (FluidBufferElement fluidBufferElement : this.fluidBuffer) {
                if (!fluidBufferElement.addTarget(owner, setting, inventoryHolder, target)) continue;
                added = true;
                break;
            }
            if (!added) {
                FluidBufferElement itemBufferElement = new FluidBufferElement(owner, setting, inventoryHolder, menuItem.useWhiteList(), target);
                this.fluidBuffer.add(itemBufferElement);
            }
        }
    }

    private ItemSetting getStackSetting(ComponentMenu componentMenu, ItemStack itemStack) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        for (Setting setting : menuItem.getSettings()) {
            if (!(setting instanceof ItemSetting) || !((ItemSetting)setting).isEqualForCommandExecutor(itemStack)) continue;
            return (ItemSetting)setting;
        }
        return null;
    }

    private Setting getFluidSetting(ComponentMenu componentMenu, FluidStack fluidStack) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        if (fluidStack != null) {
            String fluidName = fluidStack.getFluid().getName();
            for (Setting setting : menuItem.getSettings()) {
                if (!setting.isValid() || !((FluidSetting)setting).getFluidName().equals(fluidName)) continue;
                return setting;
            }
        }
        return null;
    }

    private void insertItems(ComponentMenu componentMenu, List<SlotInventoryHolder> inventories) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        ArrayList<OutputItemCounter> outputCounters = new ArrayList<OutputItemCounter>();
        for (SlotInventoryHolder inventoryHolder : inventories) {
            if (!inventoryHolder.isShared()) {
                outputCounters.clear();
            }
            for (CraftingBufferElement craftingBufferElement : this.craftingBufferHigh) {
                this.insertItemsFromInputBufferElement(menuItem, inventories, outputCounters, inventoryHolder, craftingBufferElement);
            }
            for (ItemBufferElement itemBufferElement : this.itemBuffer) {
                this.insertItemsFromInputBufferElement(menuItem, inventories, outputCounters, inventoryHolder, itemBufferElement);
            }
            for (CraftingBufferElement craftingBufferElement : this.craftingBufferLow) {
                this.insertItemsFromInputBufferElement(menuItem, inventories, outputCounters, inventoryHolder, craftingBufferElement);
            }
        }
    }

    private void insertItemsFromInputBufferElement(ComponentMenuStuff menuItem, List<SlotInventoryHolder> inventories, List<OutputItemCounter> outputCounters, SlotInventoryHolder inventoryHolder, IItemBufferElement itemBufferElement) {
        int remaining;
        IItemBufferSubElement subElement;
        itemBufferElement.prepareSubElements();
        while ((subElement = itemBufferElement.getSubElement()) != null && (remaining = subElement.getSizeRemaining()) > 0) {
            ItemStack stackInBuffer = subElement.getItemStack();
            ItemSetting setting = this.getStackSetting(menuItem, stackInBuffer);
            if (menuItem.useWhiteList() == (setting == null) && (setting == null || !setting.isLimitedByAmount())) continue;
            OutputItemCounter outputItemCounter = outputCounters.stream().filter(s -> s.areSettingsSame(setting)).findFirst().orElseGet(() -> {
                OutputItemCounter c = new OutputItemCounter(this.itemBuffer, inventories, inventoryHolder, setting, menuItem.useWhiteList());
                outputCounters.add(c);
                return c;
            });
            block1: for (SideSlotTarget sideSlotTarget : inventoryHolder.getValidSlots().values()) {
                IItemHandler inventory = inventoryHolder.getInventory(sideSlotTarget.getSide());
                if (inventory == null) continue;
                for (int slot : sideSlotTarget.getSlots()) {
                    ItemStack stackInSlot;
                    if (!this.isSlotValid(inventory, stackInBuffer, slot, false) || !(stackInSlot = inventory.getStackInSlot(slot)).func_190926_b() && (!stackInSlot.func_77985_e() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackInBuffer))) continue;
                    int moveCount = Math.min(remaining, Math.min(inventory.getSlotLimit(slot), stackInSlot.func_77976_d()) - (stackInSlot.func_190926_b() ? 0 : stackInSlot.func_190916_E()));
                    moveCount = outputItemCounter.retrieveItemCount(moveCount);
                    moveCount = itemBufferElement.retrieveItemCount(moveCount);
                    if ((moveCount = Math.min(moveCount, inventory.getSlotLimit(slot) - stackInSlot.func_190916_E())) <= 0) continue;
                    ItemStack stackToInsert = stackInBuffer.func_77946_l();
                    stackToInsert.func_190920_e(moveCount);
                    int leftoverCount = inventory.insertItem(slot, stackToInsert, false).func_190916_E();
                    remaining -= (moveCount -= leftoverCount);
                    itemBufferElement.decreaseStackSize(moveCount);
                    outputItemCounter.modifyStackSize(moveCount);
                    subElement.reduceAmount(moveCount);
                    if (subElement.getSizeRemaining() <= 0) {
                        subElement.remove();
                        itemBufferElement.removeSubElement();
                        subElement.onUpdate();
                        continue block1;
                    }
                    subElement.onUpdate();
                }
            }
        }
        itemBufferElement.releaseSubElements();
    }

    private void insertFluids(ComponentMenu componentMenu, List<SlotInventoryHolder> tanks) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        ArrayList<OutputFluidCounter> outputCounters = new ArrayList<OutputFluidCounter>();
        for (SlotInventoryHolder tankHolder : tanks) {
            if (!tankHolder.isShared()) {
                outputCounters.clear();
            }
            for (FluidBufferElement fluidBufferElement : this.fluidBuffer) {
                Iterator<StackTankHolder> fluidIterator = fluidBufferElement.getHolders().iterator();
                block2: while (fluidIterator.hasNext()) {
                    StackTankHolder holder = fluidIterator.next();
                    FluidStack fluidStack = holder.getFluidStack();
                    Setting setting = this.getFluidSetting(componentMenu, fluidStack);
                    if (menuItem.useWhiteList() == (setting == null) && (setting == null || !setting.isLimitedByAmount())) continue;
                    OutputFluidCounter outputFluidCounter = null;
                    for (OutputFluidCounter e : outputCounters) {
                        if (!e.areSettingsSame(setting)) continue;
                        outputFluidCounter = e;
                        break;
                    }
                    if (outputFluidCounter == null) {
                        outputFluidCounter = new OutputFluidCounter(this.fluidBuffer, tanks, tankHolder, setting, menuItem.useWhiteList());
                        outputCounters.add(outputFluidCounter);
                    }
                    for (SideSlotTarget sideSlotTarget : tankHolder.getValidSlots().values()) {
                        IFluidHandler tank = tankHolder.getTank(sideSlotTarget.getSide());
                        FluidStack temp = fluidStack.copy();
                        temp.amount = holder.getSizeLeft();
                        int amount = tank.fill(temp, false);
                        amount = fluidBufferElement.retrieveItemCount(amount);
                        if ((amount = outputFluidCounter.retrieveItemCount(amount)) <= 0) continue;
                        FluidStack resource = fluidStack.copy();
                        resource.amount = amount;
                        resource = holder.getTank().drain(resource, true);
                        if (resource == null || resource.amount <= 0) continue;
                        tank.fill(resource, true);
                        fluidBufferElement.decreaseStackSize(resource.amount);
                        outputFluidCounter.modifyStackSize(resource.amount);
                        holder.reduceAmount(resource.amount);
                        if (holder.getSizeLeft() != 0) continue;
                        fluidIterator.remove();
                        continue block2;
                    }
                }
            }
        }
    }

    private boolean searchForStuff(ComponentMenu componentMenu, List<SlotInventoryHolder> inventories, boolean useFluids) {
        if (inventories == null || inventories.size() == 0) {
            return false;
        }
        if (inventories.get(0).isShared()) {
            HashMap<Integer, ConditionSettingChecker> conditionSettingCheckerMap = new HashMap<Integer, ConditionSettingChecker>();
            for (int i = 0; i < inventories.size(); ++i) {
                this.calculateConditionData(componentMenu, inventories.get(i), conditionSettingCheckerMap, useFluids);
            }
            return this.checkConditionResult(componentMenu, conditionSettingCheckerMap);
        }
        boolean useAnd = inventories.get(0).getSharedOption() == 1;
        for (int i = 0; i < inventories.size(); ++i) {
            HashMap<Integer, ConditionSettingChecker> conditionSettingCheckerMap = new HashMap<Integer, ConditionSettingChecker>();
            this.calculateConditionData(componentMenu, inventories.get(i), conditionSettingCheckerMap, useFluids);
            if (this.checkConditionResult(componentMenu, conditionSettingCheckerMap)) {
                if (useAnd) continue;
                return true;
            }
            if (!useAnd) continue;
            return false;
        }
        return useAnd;
    }

    private void calculateConditionData(ComponentMenu componentMenu, SlotInventoryHolder inventoryHolder, Map<Integer, ConditionSettingChecker> conditionSettingCheckerMap, boolean useFluids) {
        if (useFluids) {
            this.calculateConditionDataFluid(componentMenu, inventoryHolder, conditionSettingCheckerMap);
        } else {
            this.calculateConditionDataItem(componentMenu, inventoryHolder, conditionSettingCheckerMap);
        }
    }

    private void calculateConditionDataItem(ComponentMenu componentMenu, SlotInventoryHolder inventoryHolder, Map<Integer, ConditionSettingChecker> conditionSettingCheckerMap) {
        IdentityHashMap seenStacks = new IdentityHashMap();
        for (SideSlotTarget sideSlotTarget : inventoryHolder.getValidSlots().values()) {
            for (int slot : sideSlotTarget.getSlots()) {
                IItemHandler inventory = inventoryHolder.getInventory(sideSlotTarget.getSide());
                ItemStack itemStack = inventory.getStackInSlot(slot);
                if (seenStacks.containsKey(itemStack) || !this.isSlotValid(inventory, itemStack, slot, true)) continue;
                seenStacks.put(itemStack, null);
                ItemSetting setting = this.getStackSetting(componentMenu, itemStack);
                if (setting == null) continue;
                ConditionSettingChecker conditionSettingChecker = conditionSettingCheckerMap.get(setting.getId());
                if (conditionSettingChecker == null) {
                    conditionSettingChecker = new ConditionSettingChecker(setting);
                    conditionSettingCheckerMap.put(setting.getId(), conditionSettingChecker);
                }
                conditionSettingChecker.addCount(itemStack.func_190916_E());
            }
        }
    }

    private void calculateConditionDataFluid(ComponentMenu componentMenu, SlotInventoryHolder inventoryHolder, Map<Integer, ConditionSettingChecker> conditionSettingCheckerMap) {
        for (SideSlotTarget sideSlotTarget : inventoryHolder.getValidSlots().values()) {
            IFluidHandler tank = inventoryHolder.getTank(sideSlotTarget.getSide());
            ArrayList<IFluidTankProperties> tankInfos = new ArrayList<IFluidTankProperties>();
            IFluidTankProperties[] currentTankInfos = tank.getTankProperties();
            if (currentTankInfos == null) continue;
            for (IFluidTankProperties fluidTankInfo : currentTankInfos) {
                FluidStack fluidStack;
                Setting setting;
                if (fluidTankInfo == null) continue;
                boolean alreadyUsed = false;
                for (IFluidTankProperties tankInfo : tankInfos) {
                    if (!FluidStack.areFluidStackTagsEqual((FluidStack)tankInfo.getContents(), (FluidStack)fluidTankInfo.getContents()) || tankInfo.getCapacity() != fluidTankInfo.getCapacity()) continue;
                    alreadyUsed = true;
                }
                if (alreadyUsed || (setting = this.getFluidSetting(componentMenu, fluidStack = fluidTankInfo.getContents())) == null) continue;
                ConditionSettingChecker conditionSettingChecker = conditionSettingCheckerMap.get(setting.getId());
                if (conditionSettingChecker == null) {
                    conditionSettingChecker = new ConditionSettingChecker(setting);
                    conditionSettingCheckerMap.put(setting.getId(), conditionSettingChecker);
                }
                conditionSettingChecker.addCount(fluidStack.amount);
            }
            for (IFluidTankProperties fluidTankInfo : tank.getTankProperties()) {
                if (fluidTankInfo == null) continue;
                tankInfos.add(fluidTankInfo);
            }
        }
    }

    private boolean checkConditionResult(ComponentMenu componentMenu, Map<Integer, ConditionSettingChecker> conditionSettingCheckerMap) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        IConditionStuffMenu menuCondition = (IConditionStuffMenu)((Object)componentMenu);
        for (Setting setting : menuItem.getSettings()) {
            if (!setting.isValid()) continue;
            ConditionSettingChecker conditionSettingChecker = conditionSettingCheckerMap.get(setting.getId());
            if (conditionSettingChecker != null && conditionSettingChecker.isTrue()) {
                if (menuCondition.requiresAll()) continue;
                return true;
            }
            if (!menuCondition.requiresAll()) continue;
            return false;
        }
        return menuCondition.requiresAll();
    }

    private boolean splitFlow(ComponentMenu componentMenu) {
        ComponentMenuSplit split = (ComponentMenuSplit)componentMenu;
        if (split.useSplit()) {
            int amount = componentMenu.getParent().getConnectionSet().getOutputCount();
            if (!split.useEmpty()) {
                ConnectionOption[] connections = componentMenu.getParent().getConnectionSet().getConnections();
                for (int i = 0; i < connections.length; ++i) {
                    ConnectionOption connectionOption = connections[i];
                    if (connectionOption.isInput() || componentMenu.getParent().getConnection(i) != null) continue;
                    --amount;
                }
            }
            int usedId = 0;
            ConnectionOption[] connections = componentMenu.getParent().getConnectionSet().getConnections();
            for (int i = 0; i < connections.length; ++i) {
                ConnectionOption connectionOption = connections[i];
                Connection connection = componentMenu.getParent().getConnection(i);
                if (connectionOption.isInput() || connection == null) continue;
                ArrayList<ItemBufferElement> itemBufferSplit = new ArrayList<ItemBufferElement>();
                ArrayList<FluidBufferElement> fluidBufferSplit = new ArrayList<FluidBufferElement>();
                for (ItemBufferElement itemBufferElement : this.itemBuffer) {
                    itemBufferSplit.add(itemBufferElement.getSplitElement(amount, usedId, split.useFair()));
                }
                for (FluidBufferElement fluidBufferElement : this.fluidBuffer) {
                    fluidBufferSplit.add(fluidBufferElement.getSplitElement(amount, usedId, split.useFair()));
                }
                ArrayList<Integer> usedCommandCopy = new ArrayList<Integer>();
                for (int usedCommand : this.usedCommands) {
                    usedCommandCopy.add(usedCommand);
                }
                CommandExecutor commandExecutor = new CommandExecutor(this.manager, itemBufferSplit, new ArrayList<CraftingBufferElement>(this.craftingBufferHigh), new ArrayList<CraftingBufferElement>(this.craftingBufferLow), fluidBufferSplit, usedCommandCopy);
                commandExecutor.executeCommand(this.manager.getFlowItems().get(connection.getComponentId()), connection.getConnectionId());
                ++usedId;
            }
            return true;
        }
        return false;
    }

    private boolean evaluateRedstoneCondition(List<SlotInventoryHolder> nodes, FlowComponent component) {
        return TileEntityManager.redstoneCondition.isTriggerPowered(nodes, component, true);
    }

    private void updateVariable(List<SlotInventoryHolder> tiles, ComponentMenuVariable menuVariable, ComponentMenuListOrder menuOrder) {
        ComponentMenuVariable.VariableMode mode = menuVariable.getVariableMode();
        Variable variable = this.manager.getVariables()[menuVariable.getSelectedVariable()];
        if (variable.isValid()) {
            boolean remove;
            boolean bl = remove = mode == ComponentMenuVariable.VariableMode.REMOVE;
            if (!remove && mode != ComponentMenuVariable.VariableMode.ADD) {
                variable.clearContainers();
            }
            List<Integer> idList = new ArrayList<Integer>();
            for (SlotInventoryHolder tile : tiles) {
                idList.add(tile.getId());
            }
            if (!menuVariable.isDeclaration()) {
                idList = this.applyOrder(idList, menuOrder);
            }
            List<ConnectionBlock> inventories = this.manager.getConnectedInventories();
            EnumSet<ConnectionBlockType> validTypes = ((ComponentMenuContainerTypes)variable.getDeclaration().getMenus().get(1)).getValidTypes();
            for (int id : idList) {
                if (remove) {
                    variable.remove(id);
                    continue;
                }
                if (id < 0 || id >= inventories.size() || !inventories.get(id).isOfAnyType(validTypes)) continue;
                variable.add(id);
            }
        }
    }

    private void updateForLoop(FlowComponent command, ComponentMenuVariableLoop variableMenu, ComponentMenuContainerTypes typesMenu, ComponentMenuListOrder orderMenu) {
        Variable list = variableMenu.getListVariable();
        Variable element = variableMenu.getElementVariable();
        if (!list.isValid() || !element.isValid()) {
            return;
        }
        List<Integer> selection = this.applyOrder(list.getContainers(), orderMenu);
        EnumSet<ConnectionBlockType> validTypes = typesMenu.getValidTypes();
        validTypes.addAll(((ComponentMenuContainerTypes)element.getDeclaration().getMenus().get(1)).getValidTypes());
        List<ConnectionBlock> inventories = this.manager.getConnectedInventories();
        for (Integer selected : selection) {
            ConnectionBlock inventory;
            if (selected < 0 || selected >= inventories.size() || !(inventory = inventories.get(selected)).isOfAnyType(validTypes)) continue;
            element.clearContainers();
            element.add(selected);
            this.executeChildCommands(command, EnumSet.of(ConnectionOption.FOR_EACH));
        }
    }

    private List<Integer> applyOrder(List<Integer> original, ComponentMenuListOrder orderMenu) {
        ArrayList<Integer> ret = new ArrayList<Integer>(original);
        if (orderMenu.getOrder() == ComponentMenuListOrder.LoopOrder.RANDOM) {
            Collections.shuffle(ret);
        } else if (orderMenu.getOrder() == ComponentMenuListOrder.LoopOrder.NORMAL) {
            if (!orderMenu.isReversed()) {
                Collections.reverse(ret);
            }
        } else {
            Collections.sort(ret, orderMenu.getComparator());
        }
        if (!orderMenu.useAll()) {
            int len = orderMenu.getAmount();
            while (ret.size() > len) {
                ret.remove(ret.size() - 1);
            }
        }
        return ret;
    }
}

