/*
 * Decompiled with CFR 0.152.
 */
package scavenge.utils.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropDefault
extends BaseResourceProperty
implements IResourceCondition {
    boolean defaultValue;

    public PropDefault(JsonObject obj) {
        super(obj, "default_Condition");
        this.defaultValue = JsonUtil.getOrDefault(obj, "value", true);
        if (this.defaultValue) {
            this.setJEIInfo("Returns always true");
        } else {
            this.setJEIInfo("Returns always false");
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.defaultValue;
    }

    public static class DefaultFactory
    extends BaseResourceFactory {
        public DefaultFactory() {
            super("default_Condition", IResourceFactory.PropertyType.Condition);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropDefault(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("value", Boolean.valueOf(true));
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to always return true or false");
            map.addElement(new BooleanElement("value", true, "If it should return true or false"));
            return map;
        }
    }
}

