/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropSetPlayerTag
extends BaseResourceProperty
implements IResourceEffect {
    String tagID;
    boolean remove;

    public PropSetPlayerTag(JsonObject obj) {
        super(obj, "set_player_tag");
        this.tagID = obj.get("tagID").getAsString();
        this.remove = JsonUtil.getOrDefault(obj, "remove", false);
        if (this.remove) {
            this.setJEIInfo("Removes PlayerTag [" + this.tagID + "]");
        } else {
            this.setJEIInfo("Add PlayerTag [" + this.tagID + "]");
        }
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (this.remove) {
            player.getEntityData().func_82580_o(this.tagID);
        } else {
            player.getEntityData().func_74757_a(this.tagID, true);
        }
        return true;
    }

    public static class SetPlayerTagFactory
    extends BaseResourceFactory {
        public SetPlayerTagFactory() {
            super("set_player_tag", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropSetPlayerTag(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("tagID", "exampleTag");
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("tagID", "").setDescription("The Tag you want to add or remove from the Player"));
            map.addElement(new BooleanElement("remove", false, "If the tag should be added or removed"));
            map.setDescription("Allows to set a Tag to a player");
            return map;
        }
    }
}

