/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropDropItems
extends BaseResourceProperty
implements IResourceEffect {
    boolean doDrop;

    public PropDropItems(JsonObject obj) {
        super(obj, "drop_items");
        this.doDrop = JsonUtil.getOrDefault(obj, "doDrop", true);
        if (this.doDrop) {
            this.setJEIInfo("Drops the Items in the Ground");
        } else {
            this.setJEIInfo("Adds the Item to the Players Inventory");
        }
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        container.setDropItems(this.doDrop);
        return false;
    }

    public static class DropItemsFactory
    extends BaseResourceFactory {
        public DropItemsFactory() {
            super("drop_items", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropDropItems(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("doDrop", Boolean.valueOf(true));
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new BooleanElement("doDrop", true, "If the Loot should drop or not"));
            map.setDescription("Allows to decide if the Loot Items drop or get added to the Players Inventory");
            return map;
        }
    }
}

