/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropRequireLeftClick
extends BaseResourceProperty
implements IResourceCondition {
    boolean left;

    public PropRequireLeftClick(JsonObject obj) {
        super(obj, "require_left");
        this.addSelfIncompat();
        this.left = JsonUtil.getOrDefault(obj, "leftClick", true);
        this.setJEIInfo(this.left ? "Player has to leftclick the block" : "Player has to rightclick the block");
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.left == leftClick;
    }

    public static class LeftClickFactory
    extends BaseResourceFactory {
        public LeftClickFactory() {
            super("require_left", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropRequireLeftClick(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new BooleanElement("leftClick", true, "Allows to decide if the Left or Rightclick is required"));
            map.setDescription("Allows to check if it the currentclick is a left or rightclick");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("leftClick", Boolean.valueOf(true));
        }
    }
}

