/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.effects;

import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.loot.impl.BasePassiveLootProperty;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;

public class PropAddFluid
extends BasePassiveLootProperty {
    FluidStack toAdd;

    public PropAddFluid(JsonObject obj) {
        super("add_fluid");
        this.toAdd = JsonUtil.createFluidStack(obj);
        if (this.toAdd == null) {
            throw new RuntimeException("Null fluid from Object [" + obj + "] is not allowed");
        }
    }

    @Override
    public ItemStack applyPassiveEffect(ItemStack stack) {
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            int amount = LootUtil.getStackSize(stack);
            LootUtil.setStackSize(stack, 1);
            IFluidHandler handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            handler.fill(this.toAdd.copy(), true);
            LootUtil.setStackSize(stack, amount);
        }
        return stack;
    }

    @Override
    public ItemStack applyInfoEffect(ItemStack stack) {
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            int amount = LootUtil.getStackSize(stack);
            LootUtil.setStackSize(stack, 1);
            IFluidHandler handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            handler.fill(this.toAdd.copy(), true);
            LootUtil.setStackSize(stack, amount);
        }
        return stack;
    }

    public static class AddFluidFactory
    extends BaseLootFactory {
        public AddFluidFactory() {
            super("add_fluid", false);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropAddFluid(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.setDescription("Allows to Add Fluids to the Items if they can store them");
            map.addElement(new TextElement("name", "").setDescription("The Fluid Registry name of the Fluid you want to add"));
            map.addElement(new IntElement("amount", 1000, "How much the Fluid Should be"));
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "minecraft:water");
            obj.addProperty("amount", (Number)1000);
        }
    }
}

