/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.math.operation;

import com.google.gson.JsonObject;
import scavenge.api.autodoc.LongElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.math.IMathOperation;
import scavenge.api.math.impl.BaseMathOperation;
import scavenge.api.math.impl.BaseOperationFactory;
import scavenge.api.utils.CompatState;

public class EqualsNotOperation
extends BaseMathOperation {
    long toCheck;

    public EqualsNotOperation(JsonObject obj) {
        this(obj.get("value").getAsLong());
        if (obj.has("modifiers")) {
            this.addMathModifiers(obj.get("modifiers"));
        }
    }

    public EqualsNotOperation(long check) {
        super("equalsNot");
        this.toCheck = check;
    }

    @Override
    public boolean matches(long value) {
        return this.toCheck != this.getValue(value);
    }

    public static class EqualsNotFactory
    extends BaseOperationFactory {
        public EqualsNotFactory() {
            super("equalsNot");
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IMathOperation createObject(JsonObject obj) {
            return new EqualsNotOperation(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement el = super.getDocumentation();
            el.addElement(new LongElement("value", 0L).setDescription("The Value the Operation should compare with"));
            el.setDescription("Checks if the InputValue doesn't match with selected Value");
            return el;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("value", (Number)100);
        }
    }
}

