/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.math.modifiers;

import com.google.gson.JsonObject;
import scavenge.api.autodoc.LongElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.math.IMathModifier;
import scavenge.api.math.impl.BaseMathModifier;
import scavenge.api.math.impl.BaseModifierFactory;

public class DevideModifier
extends BaseMathModifier {
    long value;

    public DevideModifier(JsonObject obj) {
        this(obj.get("value").getAsLong());
    }

    public DevideModifier(long value) {
        super("divide");
        this.value = value;
    }

    @Override
    public long modify(long input) {
        return input / this.value;
    }

    public static class DevideFactory
    extends BaseModifierFactory {
        public DevideFactory() {
            super("divide");
        }

        @Override
        public IMathModifier createObject(JsonObject obj) {
            return new DevideModifier(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.addElement(new LongElement("value", 0L).setDescription("The Value that should be divide with"));
            map.setDescription("Divides the Input Value by a Selected Value");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("value", (Number)2);
        }
    }
}

