/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.math.modifiers;

import com.google.gson.JsonObject;
import scavenge.api.autodoc.LongElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.math.IMathModifier;
import scavenge.api.math.impl.BaseMathModifier;
import scavenge.api.math.impl.BaseModifierFactory;

public class AddModifier
extends BaseMathModifier {
    long value;

    public AddModifier(JsonObject obj) {
        this(obj.get("value").getAsLong());
    }

    public AddModifier(long value) {
        super("add");
        this.value = value;
    }

    @Override
    public long modify(long input) {
        return input + this.value;
    }

    public static class AddFactory
    extends BaseModifierFactory {
        public AddFactory() {
            super("add");
        }

        @Override
        public IMathModifier createObject(JsonObject obj) {
            return new AddModifier(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.addElement(new LongElement("value", 0L).setDescription("The Value that should be added"));
            map.setDescription("Adds a Selected Value to the Input Value");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("value", (Number)100);
        }
    }
}

