/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.util;

import com.codetaylor.mc.athenaeum.recipe.IRecipeSingleFluidOutput;
import com.codetaylor.mc.athenaeum.recipe.IRecipeSingleOutput;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;

public final class RecipeHelper {
    public static <R extends IForgeRegistryEntry<R> & IRecipeSingleOutput> boolean removeRecipesByOutput(IForgeRegistryModifiable<R> registry, Ingredient output) {
        Iterator iterator = registry.iterator();
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>(1);
        while (iterator.hasNext()) {
            IForgeRegistryEntry recipe = (IForgeRegistryEntry)iterator.next();
            if (!output.apply(((IRecipeSingleOutput)recipe).getOutput())) continue;
            toRemove.add(recipe.getRegistryName());
        }
        for (ResourceLocation resourceLocation : toRemove) {
            registry.remove(resourceLocation);
        }
        return !toRemove.isEmpty();
    }

    public static <R extends IForgeRegistryEntry<R> & IRecipeSingleFluidOutput> boolean removeRecipesByOutput(IForgeRegistryModifiable<R> registry, FluidStack output) {
        Iterator iterator = registry.iterator();
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>(1);
        while (iterator.hasNext()) {
            IForgeRegistryEntry recipe = (IForgeRegistryEntry)iterator.next();
            if (!output.isFluidEqual(((IRecipeSingleFluidOutput)recipe).getOutput())) continue;
            toRemove.add(recipe.getRegistryName());
        }
        for (ResourceLocation resourceLocation : toRemove) {
            registry.remove(resourceLocation);
        }
        return !toRemove.isEmpty();
    }

    public static boolean hasFurnaceFoodRecipe(ItemStack furnaceInput) {
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        ItemStack smeltingResult = furnaceRecipes.func_151395_a(furnaceInput);
        return !smeltingResult.func_190926_b() && smeltingResult.func_77973_b() instanceof ItemFood;
    }

    private RecipeHelper() {
    }
}

