/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.util;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockHelper {
    public static void notifyBlockUpdate(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        world.func_184138_a(pos, blockState, blockState, 3);
    }

    public static boolean isBlockSurroundedByAirHorizontal(World world, BlockPos pos) {
        return world.func_175623_d(pos.func_177972_a(EnumFacing.NORTH)) && world.func_175623_d(pos.func_177972_a(EnumFacing.SOUTH)) && world.func_175623_d(pos.func_177972_a(EnumFacing.EAST)) && world.func_175623_d(pos.func_177972_a(EnumFacing.WEST));
    }

    public static void forBlocksInRange(World world, BlockPos pos, int range, IBlockAction action) {
        int rangeSq = range * range;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        block0: for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    double distanceSq = pos.func_177954_c((double)x, (double)y, (double)z);
                    if (!(distanceSq <= (double)rangeSq)) continue;
                    mutableBlockPos.func_181079_c(x, y, z);
                    IBlockState blockState = world.func_180495_p((BlockPos)mutableBlockPos);
                    if (!action.execute(world, (BlockPos)mutableBlockPos, blockState)) break block0;
                }
            }
        }
    }

    public static void forBlocksInCube(World world, BlockPos pos, int rangeX, int rangeY, int rangeZ, IBlockAction action) {
        block0: for (int x = pos.func_177958_n() - rangeX; x <= pos.func_177958_n() + rangeX; ++x) {
            for (int y = pos.func_177956_o() - rangeY; y <= pos.func_177956_o() + rangeY; ++y) {
                for (int z = pos.func_177952_p() - rangeZ; z <= pos.func_177952_p() + rangeZ; ++z) {
                    BlockPos candidatePos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(candidatePos);
                    if (!action.execute(world, candidatePos, blockState)) break block0;
                }
            }
        }
    }

    public static List<BlockPos> findBlocksInRange(World world, BlockPos pos, int range, IBlockFilter filter, List<BlockPos> result) {
        int rangeSq = range * range;
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    IBlockState blockState;
                    BlockPos candidatePos;
                    double distanceSq = pos.func_177954_c((double)x, (double)y, (double)z);
                    if (!(distanceSq <= (double)rangeSq) || !filter.allow(world, candidatePos = new BlockPos(x, y, z), blockState = world.func_180495_p(candidatePos))) continue;
                    result.add(candidatePos);
                }
            }
        }
        return result;
    }

    private BlockHelper() {
    }

    public static interface IBlockFilter {
        public boolean allow(World var1, BlockPos var2, IBlockState var3);
    }

    public static interface IBlockAction {
        public boolean execute(World var1, BlockPos var2, IBlockState var3);
    }
}

