/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.registry;

import com.codetaylor.mc.athenaeum.registry.strategy.IClientModelRegistrationStrategy;
import com.codetaylor.mc.athenaeum.registry.strategy.IForgeRegistryEventRegistrationStrategy;
import com.codetaylor.mc.athenaeum.registry.strategy.ITileEntityRegistrationStrategy;
import com.codetaylor.mc.athenaeum.spi.IBlockColored;
import com.codetaylor.mc.athenaeum.spi.IBlockVariant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemColored;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Registry {
    private final String modId;
    private final CreativeTabs creativeTabs;
    private final List<IForgeRegistryEventRegistrationStrategy<Block>> blockRegistrationStrategyList;
    private final List<IForgeRegistryEventRegistrationStrategy<Item>> itemRegistrationStrategyList;
    private final List<ITileEntityRegistrationStrategy> tileEntityRegistrationStrategyList;
    private final List<IClientModelRegistrationStrategy> clientModelRegistrationStrategyList;
    private final List<IForgeRegistryEventRegistrationStrategy<Biome>> biomeRegistrationStrategyList;
    private final List<IForgeRegistryEventRegistrationStrategy<Potion>> potionRegistrationStrategyList;
    private final List<IForgeRegistryEventRegistrationStrategy<PotionType>> potionTypeRegistrationStrategyList;
    private final List<IForgeRegistryEventRegistrationStrategy<EntityEntry>> entityEntryRegistrationStrategyList;
    private int entityEntryIndex;

    public Registry(String modId) {
        this(modId, null);
    }

    public Registry(String modId, @Nullable CreativeTabs creativeTabs) {
        this.modId = modId;
        this.creativeTabs = creativeTabs;
        this.blockRegistrationStrategyList = new ArrayList<IForgeRegistryEventRegistrationStrategy<Block>>();
        this.itemRegistrationStrategyList = new ArrayList<IForgeRegistryEventRegistrationStrategy<Item>>();
        this.tileEntityRegistrationStrategyList = new ArrayList<ITileEntityRegistrationStrategy>();
        this.clientModelRegistrationStrategyList = new ArrayList<IClientModelRegistrationStrategy>();
        this.biomeRegistrationStrategyList = new ArrayList<IForgeRegistryEventRegistrationStrategy<Biome>>();
        this.potionRegistrationStrategyList = new ArrayList<IForgeRegistryEventRegistrationStrategy<Potion>>();
        this.potionTypeRegistrationStrategyList = new ArrayList<IForgeRegistryEventRegistrationStrategy<PotionType>>();
        this.entityEntryRegistrationStrategyList = new ArrayList<IForgeRegistryEventRegistrationStrategy<EntityEntry>>();
        this.entityEntryIndex = 0;
    }

    public String getModId() {
        return this.modId;
    }

    public List<IForgeRegistryEventRegistrationStrategy<Block>> getBlockRegistrationStrategyList() {
        return Collections.unmodifiableList(this.blockRegistrationStrategyList);
    }

    public void registerBlockRegistrationStrategy(IForgeRegistryEventRegistrationStrategy<Block> strategy) {
        this.blockRegistrationStrategyList.add(strategy);
    }

    public <B extends Block> B registerBlock(B block, String name) {
        ResourceLocation resourceLocation = new ResourceLocation(this.modId, name);
        block.setRegistryName(resourceLocation);
        block.func_149663_c(this.modId + "." + name);
        if (this.creativeTabs != null) {
            block.func_149647_a(this.creativeTabs);
        }
        this.registerBlockRegistrationStrategy(forgeRegistry -> forgeRegistry.register((IForgeRegistryEntry)block));
        return block;
    }

    public <B extends Block> B registerBlockWithItem(B block, String name) {
        Object itemBlock = block instanceof IBlockColored ? new ItemColored(block, ((IBlockColored)block).hasBlockColoredSubtypes()) : (block instanceof IBlockVariant ? new ItemMultiTexture(block, block, ((IBlockVariant)block)::getModelName) : new ItemBlock(block));
        return this.registerBlock(block, itemBlock, name);
    }

    public <B extends Block, I extends ItemBlock> B registerBlock(B block, I itemBlock, String name) {
        this.registerBlock(block, name);
        ResourceLocation resourceLocation = new ResourceLocation(this.modId, name);
        this.registerItem((Item)itemBlock, resourceLocation);
        return block;
    }

    public List<IForgeRegistryEventRegistrationStrategy<Item>> getItemRegistrationStrategyList() {
        return Collections.unmodifiableList(this.itemRegistrationStrategyList);
    }

    public void registerItemRegistrationStrategy(IForgeRegistryEventRegistrationStrategy<Item> strategy) {
        this.itemRegistrationStrategyList.add(strategy);
    }

    public Item registerItem(Item item, String name) {
        return this.registerItem(item, new ResourceLocation(this.getModId(), name));
    }

    public Item registerItem(Item item, ResourceLocation registryName) {
        String resourceDomain = registryName.func_110624_b().replaceAll("_", ".");
        String resourcePath = registryName.func_110623_a().toLowerCase().replace("_", ".");
        item.setRegistryName(registryName);
        item.func_77655_b(resourceDomain + "." + resourcePath);
        if (this.creativeTabs != null) {
            item.func_77637_a(this.creativeTabs);
        }
        this.registerItemRegistrationStrategy(forgeRegistry -> forgeRegistry.register((IForgeRegistryEntry)item));
        return item;
    }

    public List<ITileEntityRegistrationStrategy> getTileEntityRegistrationStrategyList() {
        return Collections.unmodifiableList(this.tileEntityRegistrationStrategyList);
    }

    public void registerTileEntityRegistrationStrategy(ITileEntityRegistrationStrategy strategy) {
        this.tileEntityRegistrationStrategyList.add(strategy);
    }

    @SafeVarargs
    public final void registerTileEntities(Class<? extends TileEntity> ... tileEntityClasses) {
        for (Class<? extends TileEntity> tileEntityClass : tileEntityClasses) {
            this.registerTileEntity(tileEntityClass);
        }
    }

    public void registerTileEntity(Class<? extends TileEntity> tileEntityClass) {
        this.registerTileEntityRegistrationStrategy(() -> GameRegistry.registerTileEntity((Class)tileEntityClass, (String)(this.getModId() + ".tile." + tileEntityClass.getSimpleName())));
    }

    public List<IClientModelRegistrationStrategy> getClientModelRegistrationStrategyList() {
        return Collections.unmodifiableList(this.clientModelRegistrationStrategyList);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerClientModelRegistrationStrategy(IClientModelRegistrationStrategy strategy) {
        this.clientModelRegistrationStrategyList.add(strategy);
    }

    public List<IForgeRegistryEventRegistrationStrategy<Biome>> getBiomeRegistrationStrategyList() {
        return Collections.unmodifiableList(this.biomeRegistrationStrategyList);
    }

    public void registerBiomeRegistrationStrategy(IForgeRegistryEventRegistrationStrategy<Biome> strategy) {
        this.biomeRegistrationStrategyList.add(strategy);
    }

    public void registerBiome(Biome biome, String name) {
        this.registerBiome(biome, name, new BiomeDictionary.Type[0]);
    }

    public void registerBiome(Biome biome, String name, BiomeDictionary.Type[] types) {
        this.registerBiomeRegistrationStrategy(forgeRegistry -> {
            biome.setRegistryName(this.getModId(), name);
            forgeRegistry.register((IForgeRegistryEntry)biome);
            if (types.length > 0) {
                BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
            }
        });
    }

    public List<IForgeRegistryEventRegistrationStrategy<PotionType>> getPotionTypeRegistrationStrategyList() {
        return Collections.unmodifiableList(this.potionTypeRegistrationStrategyList);
    }

    public void registerPotionTypeRegistrationStrategy(IForgeRegistryEventRegistrationStrategy<PotionType> strategy) {
        this.potionTypeRegistrationStrategyList.add(strategy);
    }

    public void registerPotionType(PotionType potionType, String name) {
        this.registerPotionType(potionType, new ResourceLocation(this.getModId(), name));
    }

    public void registerPotionType(PotionType potionType, ResourceLocation registryName) {
        this.registerPotionTypeRegistrationStrategy(forgeRegistry -> {
            String resourceDomain = registryName.func_110624_b().replaceAll("_", ".");
            String resourcePath = registryName.func_110623_a().toLowerCase().replace("_", ".");
            potionType.setRegistryName(registryName);
            forgeRegistry.register((IForgeRegistryEntry)potionType);
        });
    }

    public List<IForgeRegistryEventRegistrationStrategy<Potion>> getPotionRegistrationStrategyList() {
        return Collections.unmodifiableList(this.potionRegistrationStrategyList);
    }

    public void registerPotionRegistrationStrategy(IForgeRegistryEventRegistrationStrategy<Potion> strategy) {
        this.potionRegistrationStrategyList.add(strategy);
    }

    public void registerPotion(Potion potion, String name) {
        this.registerPotion(potion, new ResourceLocation(this.getModId(), name));
    }

    public void registerPotion(Potion potion, ResourceLocation registryName) {
        this.registerPotionRegistrationStrategy(forgeRegistry -> {
            String resourceDomain = registryName.func_110624_b().replaceAll("_", ".");
            String resourcePath = registryName.func_110623_a().toLowerCase().replace("_", ".");
            potion.setRegistryName(registryName);
            potion.func_76390_b(resourceDomain + ".effect." + resourcePath);
            forgeRegistry.register((IForgeRegistryEntry)potion);
        });
    }

    public List<IForgeRegistryEventRegistrationStrategy<EntityEntry>> getEntityEntryRegistrationStrategyList() {
        return Collections.unmodifiableList(this.entityEntryRegistrationStrategyList);
    }

    public void registerEntityEntryRegistrationStrategy(IForgeRegistryEventRegistrationStrategy<EntityEntry> strategy) {
        this.entityEntryRegistrationStrategyList.add(strategy);
    }

    public void registerEntityEntry(EntityEntry entry) {
        this.registerEntityEntryRegistrationStrategy(forgeRegistry -> forgeRegistry.register((IForgeRegistryEntry)entry));
    }

    public <E extends Entity> void createEntityEntry(String name, EntityEntryBuilder<E> builder) {
        ResourceLocation resourceLocation = new ResourceLocation(this.getModId(), name);
        builder.id(resourceLocation, this.entityEntryIndex);
        builder.name(name);
        ++this.entityEntryIndex;
        this.registerEntityEntry(builder.build());
    }
}

