/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.gui.element;

import com.codetaylor.mc.athenaeum.gui.GuiContainerBase;
import com.codetaylor.mc.athenaeum.gui.Texture;
import com.codetaylor.mc.athenaeum.gui.element.IGuiElement;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public abstract class GuiElementBase
implements IGuiElement {
    protected GuiContainerBase guiBase;
    protected int elementX;
    protected int elementY;
    protected int elementWidth;
    protected int elementHeight;
    protected boolean visible;

    public GuiElementBase(GuiContainerBase guiBase, int elementX, int elementY, int elementWidth, int elementHeight) {
        this.guiBase = guiBase;
        this.elementX = elementX;
        this.elementHeight = elementHeight;
        this.elementY = elementY;
        this.elementWidth = elementWidth;
        this.visible = true;
    }

    public abstract void drawBackgroundLayer(float var1, int var2, int var3);

    public abstract void drawForegroundLayer(int var1, int var2);

    public void handleMouseInput() {
    }

    public void update(float partialTicks) {
    }

    @Override
    public boolean elementIsVisible(int mouseX, int mouseY) {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean elementIsMouseInside(int mouseX, int mouseY) {
        return this.guiBase.func_146978_c(this.elementX, this.elementY, this.elementWidth, this.elementHeight, mouseX, mouseY);
    }

    protected void textureBind(ResourceLocation resourceLocation) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
    }

    protected void textureBind(Texture texture) {
        this.textureBind(texture.getResourceLocation());
    }

    protected int elementWidthModifiedGet() {
        return this.elementWidth;
    }

    protected int elementHeightModifiedGet() {
        return this.elementHeight;
    }

    protected int elementXModifiedGet() {
        return this.elementX + this.guiBase.guiContainerOffsetXGet();
    }

    protected int elementYModifiedGet() {
        return this.elementY + this.guiBase.guiContainerOffsetYGet();
    }
}

