/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.vat;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.fluid.SmartTankFluidHandler;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.CapacitorHelper;
import crazypants.enderio.base.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.vat.VatRecipeManager;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.VatConfig;
import crazypants.enderio.machines.machine.vat.PacketTanks;
import crazypants.enderio.machines.machine.vat.PacketVatProgress;
import crazypants.enderio.machines.network.PacketHandler;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileVat
extends AbstractPoweredTaskEntity
implements ITankAccess.IExtendedTankAccess,
IPaintable.IPaintableTileEntity {
    @Store
    @Nonnull
    final SmartTank inputTank = new SmartTank(((Integer)VatConfig.vatInputTankSize.get()).intValue());
    @Store
    @Nonnull
    final SmartTank outputTank = new SmartTank(((Integer)VatConfig.vatOutputTankSize.get()).intValue());
    private static int IO_MB_TICK = 100;
    boolean tanksDirty = false;
    Fluid currentTaskInputFluid;
    Fluid currentTaskOutputFluid;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileVat(@Nonnull SlotDefinition slotDefinition, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(slotDefinition, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
        this.inputTank.setTileEntity((TileEntity)this);
        this.inputTank.setCanDrain(false);
        this.outputTank.setTileEntity((TileEntity)this);
        this.outputTank.setCanFill(false);
    }

    public TileVat() {
        this(new SlotDefinition(2, 0, 1), CapacitorKey.VAT_POWER_INTAKE, CapacitorKey.VAT_POWER_BUFFER, CapacitorKey.VAT_POWER_USE);
    }

    @Nonnull
    public String getMachineName() {
        return "vat";
    }

    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
        MachineRecipeInput recipeInput = new MachineRecipeInput(i, itemstack);
        return this.isMachineRecipeInputValid(recipeInput);
    }

    protected boolean isMachineRecipeInputValid(@Nonnull MachineRecipeInput recipeInput) {
        NNList<MachineRecipeInput> inputs = this.getRecipeInputs();
        for (int j = 0; j < inputs.size(); ++j) {
            if (((MachineRecipeInput)inputs.get((int)j)).slotNumber != recipeInput.slotNumber) continue;
            inputs.set(j, (Object)recipeInput);
            return VatRecipeManager.getInstance().isValidInput(this.getMachineLevel(), inputs);
        }
        inputs.add((Object)recipeInput);
        return VatRecipeManager.getInstance().isValidInput(this.getMachineLevel(), inputs);
    }

    protected boolean doPush(@Nullable EnumFacing dir) {
        if (super.doPush(dir)) {
            return true;
        }
        if (dir != null && this.outputTank.getFluidAmount() > 0 && FluidWrapper.transfer((FluidTank)this.outputTank, (IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
            return true;
        }
        return false;
    }

    protected boolean doPull(@Nullable EnumFacing dir) {
        if (super.doPull(dir)) {
            return true;
        }
        if (dir != null && this.inputTank.getFluidAmount() < this.inputTank.getCapacity() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.inputTank, (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
            return true;
        }
        return false;
    }

    protected boolean processTasks(boolean redstoneChecksPassed) {
        boolean res = super.processTasks(redstoneChecksPassed);
        if (this.tanksDirty && this.shouldDoWorkThisTick(10)) {
            PacketHandler.sendToAllAround((IMessage)new PacketTanks(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        return res;
    }

    @Nonnull
    public IMessage getProgressPacket() {
        return new PacketVatProgress(this);
    }

    protected void mergeFluidResult(@Nonnull IMachineRecipe.ResultStack result) {
        this.outputTank.fillInternal(result.fluid, true);
        this.setTanksDirty();
    }

    protected void drainInputFluid(@Nonnull MachineRecipeInput fluid) {
        this.inputTank.removeFluidAmount(fluid.fluid.amount);
    }

    protected boolean canInsertResultFluid(@Nonnull IMachineRecipe.ResultStack fluid) {
        FluidStack fluid2 = fluid.fluid;
        if (fluid2 != null) {
            return this.outputTank.fillInternal(fluid2, false) >= fluid2.amount;
        }
        return false;
    }

    @Nonnull
    protected NNList<MachineRecipeInput> getRecipeInputs() {
        NNList res = new NNList();
        for (int slot = this.slotDefinition.minInputSlot; slot <= this.slotDefinition.maxInputSlot; ++slot) {
            ItemStack item = this.getStackInSlot(slot);
            if (!Prep.isValid((ItemStack)item)) continue;
            res.add((Object)new MachineRecipeInput(slot, item));
        }
        if (!this.inputTank.isEmpty()) {
            res.add((Object)new MachineRecipeInput(0, this.inputTank.getFluid()));
        }
        return res;
    }

    public ResourceLocation getSound() {
        return new ResourceLocation("enderio", "machine.vat");
    }

    public float getPitch() {
        return 0.3f;
    }

    public float getVolume() {
        return super.getVolume() * 0.3f;
    }

    void setClientTask(IPoweredTask currentTask) {
        this.currentTask = currentTask;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        MachineRecipeInput recipeInput = new MachineRecipeInput(0, forFluidType);
        return this.isMachineRecipeInputValid(recipeInput) ? this.inputTank : null;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.outputTank};
    }

    public void setTanksDirty() {
        if (!this.tanksDirty) {
            this.tanksDirty = true;
            this.func_70296_d();
        }
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        ArrayList<ITankAccess.ITankData> result = new ArrayList<ITankAccess.ITankData>();
        result.add(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileVat.this.inputTank.getFluid();
            }

            public int getCapacity() {
                return TileVat.this.inputTank.getCapacity();
            }
        });
        result.add(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.OUTPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileVat.this.outputTank.getFluid();
            }

            public int getCapacity() {
                return TileVat.this.outputTank.getCapacity();
            }
        });
        return result;
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler((IIoConfigurable)this, new IFluidHandler[]{this.inputTank, this.outputTank});
        }
        return this.smartTankFluidHandler;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return (T)super.getCapability(capability, facingIn);
    }

    public static class Enhanced
    extends TileVat {
        public Enhanced() {
            super(new SlotDefinition(2, 0, 1), CapacitorKey.ENHANCED_VAT_POWER_INTAKE, CapacitorKey.ENHANCED_VAT_POWER_BUFFER, CapacitorKey.ENHANCED_VAT_POWER_USE);
        }

        @Nonnull
        public ICapacitorData getCapacitorData() {
            return CapacitorHelper.increaseCapacitorLevel((ICapacitorData)super.getCapacitorData(), (float)1.0f);
        }

        public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
            return (faceHit != EnumFacing.UP || mode == IoMode.NONE) && super.supportsMode(faceHit, mode);
        }

        protected boolean shouldDoubleTick(@Nonnull IPoweredTask task, int usedEnergy) {
            double chance = this.getCapacitorData().getUnscaledValue((ICapacitorKey)CapacitorKey.ENHANCED_VAT_DOUBLE_OP_CHANCE) * ((float)usedEnergy / task.getRequiredEnergy());
            if (this.random.nextDouble() < chance) {
                return true;
            }
            return super.shouldDoubleTick(task, usedEnergy);
        }
    }
}

