/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.transceiver.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.IDrawingElement;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.gui.IPowerBarData;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.transceiver.gui.ContainerTransceiver;
import crazypants.enderio.machines.machine.transceiver.gui.GuiTransceiver;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GeneralTab
implements ITabPanel {
    private static final int SEND_BAR_OFFSET = 12;
    @Nonnull
    final ContainerTransceiver container;
    @Nonnull
    final GuiTransceiver parent;
    @Nonnull
    final GuiToolTip sendPowerBarTT;
    @Nonnull
    final ToggleButton bufferSizeB;
    @Nonnull
    final PowerBar internalPowerBar;

    public GeneralTab(@Nonnull GuiTransceiver guiTransceiver) {
        this.parent = guiTransceiver;
        this.container = this.parent.getContainer();
        int x = this.parent.getXSize() - 5 - 16;
        int y = 43;
        this.bufferSizeB = new ToggleButton((IGuiScreen)this.parent, 4327, x, y, (IWidgetIcon)IconEIO.ITEM_SINGLE, (IWidgetIcon)IconEIO.ITEM_STACK);
        this.bufferSizeB.setSelectedToolTip(new String[]{Lang.GUI_TRANS_BUFFER_STACKS.get()});
        this.bufferSizeB.setUnselectedToolTip(new String[]{Lang.GUI_TRANS_BUFFER_SINGLES.get()});
        this.bufferSizeB.setSelected(this.parent.getTransciever().isBufferStacks());
        this.sendPowerBarTT = new GuiToolTip(new Rectangle(23, 14, 10, 58), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                if (GeneralTab.this.parent.renderPowerBar()) {
                    GeneralTab.this.updateSendPowerBarTooltip(this.text);
                }
            }
        };
        this.parent.addToolTip(this.sendPowerBarTT);
        this.internalPowerBar = new PowerBar((IPowerBarData)this.container.getTe(), (GuiContainerBaseEIO)this.parent, 11, 14, 58);
    }

    public void onGuiInit(int x, int y, int width, int height) {
        this.container.setPlayerInventoryVisible(true);
        this.container.setBufferSlotsVisible(true);
        this.parent.addDrawingElement((IDrawingElement)this.internalPowerBar);
        this.bufferSizeB.onGuiInit();
    }

    public void deactivate() {
        this.container.setPlayerInventoryVisible(false);
        this.container.setBufferSlotsVisible(false);
        this.parent.removeDrawingElement((IDrawingElement)this.internalPowerBar);
        this.bufferSizeB.detach();
    }

    @Nonnull
    public IconEIO getIcon() {
        return IconEIO.IO_CONFIG_UP;
    }

    public void render(float par1, int par2, int par3) {
        int top = this.parent.getGuiTop();
        int left = this.parent.getGuiLeft();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.parent.bindGuiTexture();
        Point invRoot = this.container.getItemInventoryOffset();
        FontRenderer fr = this.parent.getFontRenderer();
        String sendTxt = Lang.GUI_TRANS_CHANNEL_SEND.get();
        int x = left + invRoot.x + 36 - fr.func_78256_a(sendTxt) / 2;
        int y = top + invRoot.y - fr.field_78288_b - 3;
        fr.func_175063_a(sendTxt, (float)x, (float)y, ColorUtil.getRGB((Color)Color.WHITE));
        String recText = Lang.GUI_TRANS_CHANNEL_RECEIVE.get();
        x = left + invRoot.x + 72 + this.container.getItemBufferSpacing() + 36 - fr.func_78256_a(recText) / 2;
        fr.func_175063_a(recText, (float)x, (float)y, ColorUtil.getRGB((Color)Color.WHITE));
        this.parent.renderSlotHighlights();
        this.parent.bindGuiTexture();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        x = left + 11 - 1;
        y = top + 14 - 1;
        int maxHeight = 58;
        int totalPixelHeight = this.parent.getTransciever().getEnergyStoredScaled(maxHeight * 2);
        int fillHeight = Math.min(totalPixelHeight, maxHeight);
        int fillY = y + 1 + 58 - fillHeight;
        fillHeight = Math.max(0, totalPixelHeight - maxHeight);
        fillY = y + 1 + 58 - fillHeight;
        this.parent.func_73729_b(++x + 12, fillY, 221, 196, 9, fillHeight);
    }

    private void updateSendPowerBarTooltip(List<String> text) {
        text.add(Lang.GUI_TRANS_BUFFER_SHARED.get());
        text.add(Lang.GUI_TRANS_BUFFER_MAXIO.get(new Object[]{LangPower.RFt((int)this.parent.getTransciever().getMaxEnergyRecieved(null))}));
        int maxEnergy = this.parent.getTransciever().getMaxEnergyStored() / 2;
        int energyStored = Math.max(0, this.parent.getTransciever().getEnergyStored() - maxEnergy);
        text.add(LangPower.RF((int)energyStored, (int)maxEnergy));
    }

    public void actionPerformed(@Nonnull GuiButton guiButton) {
        if (guiButton == this.bufferSizeB) {
            this.parent.getTransciever().setBufferStacks(this.bufferSizeB.isSelected());
            this.parent.doSetBufferStacks(this.bufferSizeB.isSelected());
        }
    }

    public void mouseClicked(int x, int y, int par3) {
    }

    public void updateScreen() {
    }

    public void keyTyped(char par1, int par2) {
        this.parent.doDefaultKeyTyped(par1, par2);
    }

    @Nonnull
    public ResourceLocation getTexture() {
        return EnderIO.proxy.getGuiTexture("transceiver_general");
    }
}

