/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport.telepad.packet;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.item.coordselector.TelepadTarget;
import crazypants.enderio.machines.machine.teleport.telepad.TileDialingDevice;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTargetList
extends MessageTileEntity<TileDialingDevice> {
    private boolean isAdd;
    private TelepadTarget target;

    public PacketTargetList() {
    }

    public PacketTargetList(@Nonnull TileDialingDevice tileDialingDevice, TelepadTarget target, boolean isAdd) {
        super((TileEntity)tileDialingDevice);
        this.isAdd = isAdd;
        this.target = target;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.isAdd);
        NBTTagCompound nbt = new NBTTagCompound();
        this.target.writeToNBT(nbt);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.isAdd = buf.readBoolean();
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.target = nbt != null ? TelepadTarget.readFromNBT((NBTTagCompound)nbt) : null;
    }

    public static class Handler
    implements IMessageHandler<PacketTargetList, IMessage> {
        public IMessage onMessage(PacketTargetList message, MessageContext ctx) {
            TileDialingDevice te = (TileDialingDevice)message.getTileEntity(ctx.side.isClient() ? EnderIO.proxy.getClientWorld() : message.getWorld(ctx));
            if (te != null) {
                if (message.isAdd) {
                    te.addTarget(message.target);
                } else {
                    te.removeTarget(message.target);
                }
            }
            return null;
        }
    }
}

