/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.tank;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.config.config.BaseConfig;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.machine.baselegacy.AbstractInventoryMachineBlock;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.ICustomSubItems;
import crazypants.enderio.base.render.IHaveTESR;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.property.EnumRenderMode;
import crazypants.enderio.machines.machine.tank.BlockItemTank;
import crazypants.enderio.machines.machine.tank.ContainerTank;
import crazypants.enderio.machines.machine.tank.EnumTankType;
import crazypants.enderio.machines.machine.tank.GuiTank;
import crazypants.enderio.machines.machine.tank.TankFluidRenderer;
import crazypants.enderio.machines.machine.tank.TankItemRenderMapper;
import crazypants.enderio.machines.machine.tank.TileTank;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTank
extends AbstractInventoryMachineBlock<TileTank>
implements IAdvancedTooltipProvider,
IPaintable.INonSolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint,
IHaveTESR,
ICustomSubItems {
    public static BlockTank create(@Nonnull IModObject modObject) {
        BlockTank res = new BlockTank(modObject);
        res.init();
        return res;
    }

    protected BlockTank(@Nonnull IModObject modObject) {
        super(modObject);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149713_g(0);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)EnumRenderMode.RENDER, (Comparable)EnumRenderMode.AUTO).func_177226_a(EnumTankType.KIND, (Comparable)((Object)EnumTankType.NORMAL)));
        this.setShape(this.mkShape(BlockFaceShape.SOLID, BlockFaceShape.SOLID, BlockFaceShape.UNDEFINED));
    }

    public ItemBlock createBlockItem(@Nonnull IModObject modObject) {
        return (ItemBlock)modObject.apply((Item)new BlockItemTank((Block)this));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER, EnumTankType.KIND});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(EnumTankType.KIND, (Comparable)((Object)EnumTankType.getType(meta)));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return EnumTankType.getMeta((EnumTankType)((Object)state.func_177229_b(EnumTankType.KIND)));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return state.func_177226_a((IProperty)EnumRenderMode.RENDER, (Comparable)EnumRenderMode.AUTO);
    }

    public int func_180651_a(@Nonnull IBlockState st) {
        return this.func_176201_c(st);
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileTank((EnumTankType)((Object)state.func_177229_b(EnumTankType.KIND)));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState bs, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return true;
    }

    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileTank te) {
        return new ContainerTank(player.field_71071_by, te);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileTank te) {
        return new GuiTank(player.field_71071_by, te);
    }

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    public int getLightValue(@Nonnull IBlockState bs, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileTank tank = (TileTank)((Object)BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos, TileTank.class));
        if (tank != null) {
            FluidStack stack = tank.tank.getFluid();
            return stack == null || stack.amount <= 0 ? 0 : stack.getFluid().getLuminosity(stack);
        }
        return super.getLightValue(bs, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    public float getExplosionResistance(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity par1Entity, @Nonnull Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        if (((EnumTankType)((Object)state.func_177229_b(EnumTankType.KIND))).isExplosionResistant()) {
            return ((Float)BaseConfig.explosionResistantBlockHardness.get()).floatValue();
        }
        return super.getExplosionResistance(world, pos, par1Entity, explosion);
    }

    public boolean func_149740_M(@Nonnull IBlockState bs) {
        return true;
    }

    public int func_180641_l(@Nonnull IBlockState bs, @Nonnull World w, @Nonnull BlockPos pos) {
        TileTank te = (TileTank)this.getTileEntity((IBlockAccess)w, pos);
        if (te != null) {
            return te.getComparatorOutput();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, (ItemStack)itemstack);
        if (EnumTankType.getType(itemstack).isExplosionResistant()) {
            list.add(TextFormatting.ITALIC + Lang.BLOCK_BLAST_RESISTANT.get());
        }
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack stack) {
        return stack.func_77977_a();
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return TankItemRenderMapper.instance;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return TankItemRenderMapper.instance;
    }

    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileTank tileEntity) {
        blockStateWrapper.addCacheKey((Object)tileEntity.getFacing()).addCacheKey((Object)blockStateWrapper.func_177229_b(EnumTankType.KIND));
    }

    @SideOnly(value=Side.CLIENT)
    public void bindTileEntitySpecialRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileTank.class, (TileEntitySpecialRenderer)new TankFluidRenderer());
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, final @Nonnull NonNullList<ItemStack> list) {
        NNList.of(EnumTankType.class).apply((NNList.Callback)new NNList.Callback<EnumTankType>(){

            public void apply(@Nonnull EnumTankType e) {
                list.add((Object)new ItemStack((Block)BlockTank.this, 1, EnumTankType.getMeta(e)));
            }
        });
    }

    @Nonnull
    public NNList<ItemStack> getSubItems() {
        return this.getSubItems((Block)this, EnumTankType.values().length - 1);
    }
}

