/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.stirling;

import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.machine.baselegacy.AbstractGeneratorBlock;
import crazypants.enderio.base.machine.fuel.ISolidFuelHandler;
import crazypants.enderio.base.machine.fuel.SolidFuelCenter;
import crazypants.enderio.base.machine.render.RenderMappers;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.machines.machine.generator.stirling.ContainerStirlingGenerator;
import crazypants.enderio.machines.machine.generator.stirling.GuiStirlingGenerator;
import crazypants.enderio.machines.machine.generator.stirling.TileStirlingGenerator;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStirlingGenerator<T extends TileStirlingGenerator>
extends AbstractGeneratorBlock<T>
implements IPaintable.ISolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockStirlingGenerator<TileStirlingGenerator> create(@Nonnull IModObject modObject) {
        BlockStirlingGenerator<TileStirlingGenerator> gen = new BlockStirlingGenerator<TileStirlingGenerator>(modObject);
        gen.init();
        return gen;
    }

    public static BlockStirlingGenerator<TileStirlingGenerator.Simple> create_simple(@Nonnull IModObject modObject) {
        BlockStirlingGenerator<TileStirlingGenerator.Simple> gen = new BlockStirlingGenerator<TileStirlingGenerator.Simple>(modObject){

            @SideOnly(value=Side.CLIENT)
            @Nonnull
            public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
                return RenderMappers.SIMPLE_BODY_MAPPER;
            }

            @SideOnly(value=Side.CLIENT)
            public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
                return RenderMappers.SIMPLE_BODY_MAPPER;
            }
        };
        gen.init();
        return gen;
    }

    protected BlockStirlingGenerator(@Nonnull IModObject modObject) {
        super(modObject);
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
    }

    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull T te) {
        return new ContainerStirlingGenerator<T>(player.field_71071_by, te);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull T te) {
        return new GuiStirlingGenerator<T>(player.field_71071_by, te);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        TileStirlingGenerator te = (TileStirlingGenerator)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null && te.isActive()) {
            EnumFacing front = te.facing;
            for (int i = 0; i < 2; ++i) {
                double px = (double)pos.func_177958_n() + 0.5 + (double)front.func_82601_c() * 0.6;
                double pz = (double)pos.func_177952_p() + 0.5 + (double)front.func_82599_e() * 0.6;
                double v = 0.05;
                double vx = 0.0;
                double vz = 0.0;
                if (front == EnumFacing.NORTH || front == EnumFacing.SOUTH) {
                    px += (double)world.field_73012_v.nextFloat() * 0.9 - 0.45;
                    vz += front == EnumFacing.NORTH ? -v : v;
                } else {
                    pz += (double)world.field_73012_v.nextFloat() * 0.9 - 0.45;
                    vx += front == EnumFacing.WEST ? -v : v;
                }
                if (te.isLavaFired && rand.nextInt(40) == 0) {
                    world.func_175688_a(EnumParticleTypes.LAVA, px, (double)pos.func_177956_o() + 0.1, pz, 0.0, 0.0, 0.0, new int[0]);
                }
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, px, (double)pos.func_177956_o() + 0.1, pz, vx, 0.0, vz, new int[0]);
            }
        }
    }

    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull T tileEntity) {
        blockStateWrapper.addCacheKey((Object)tileEntity.getFacing()).addCacheKey((Object)((TileStirlingGenerator)((Object)tileEntity)).isActive());
    }

    static {
        SolidFuelCenter.registerSolidFuelHandler((ISolidFuelHandler)new ISolidFuelHandler(){

            public long getBurnTime(@Nonnull ItemStack itemstack) {
                return TileStirlingGenerator.getBurnTimeGeneric(itemstack);
            }
        });
    }
}

