/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.lava;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.fluid.SmartTankFluidHandler;
import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.Filters;
import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.base.lang.LangTemperature;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityGeneratorEntity;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.network.PacketSpawnParticles;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.power.PowerDistributor;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.LavaGenConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

@Storable
public class TileLavaGenerator
extends AbstractCapabilityGeneratorEntity
implements IPaintable.IPaintableTileEntity,
ITankAccess.IExtendedTankAccess {
    @Nonnull
    public static final String OUTPUT_COB = "OUTCOB";
    @Nonnull
    public static final String OUTPUT_STO = "OUTSTO";
    @Nonnull
    public static final String OUTPUT_OBS = "OUTOBS";
    @Store
    public int burnTime = 0;
    @Store
    public int heat = 0;
    @Store
    @Nonnull
    protected final SmartTank tank = new SmartTank(FluidRegistry.LAVA, ((Integer)LavaGenConfig.tankSize.get()).intValue());
    @Store(value={NBTAction.ITEM, NBTAction.SAVE})
    public int lavaUsed = 0;
    @Store(value={NBTAction.ITEM, NBTAction.SAVE})
    public int cobblePoints = 0;
    @Store(value={NBTAction.ITEM, NBTAction.SAVE})
    public int stonePoints = 0;
    @Store(value={NBTAction.ITEM, NBTAction.SAVE})
    public int obsidianPoints = 0;
    private PowerDistributor powerDis;
    private int coolingSide = 0;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileLavaGenerator() {
        super((ICapacitorKey)CapacitorKey.LAVAGEN_POWER_BUFFER, (ICapacitorKey)CapacitorKey.LAVAGEN_POWER_GEN);
        this.getEnergy().setEnergyLoss((ICapacitorKey)CapacitorKey.LAVAGEN_POWER_LOSS);
        this.tank.setTileEntity((TileEntity)this);
        this.getInventory().add(EnderInventory.Type.OUTPUT, OUTPUT_COB, new InventorySlot(Filters.ALWAYS_FALSE, Filters.ALWAYS_TRUE));
        this.getInventory().add(EnderInventory.Type.OUTPUT, OUTPUT_STO, new InventorySlot(Filters.ALWAYS_FALSE, Filters.ALWAYS_TRUE));
        this.getInventory().add(EnderInventory.Type.OUTPUT, OUTPUT_OBS, new InventorySlot(Filters.ALWAYS_FALSE, Filters.ALWAYS_TRUE));
    }

    @Nonnull
    public String getMachineName() {
        return MachineObject.block_lava_generator.getUnlocalisedName();
    }

    public boolean isActive() {
        return this.burnTime > 0;
    }

    public void onNeighborBlockChange(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos posIn, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        super.onNeighborBlockChange(state, worldIn, posIn, blockIn, fromPos);
        if (this.powerDis != null) {
            this.powerDis.neighboursChanged();
        }
    }

    protected boolean processTasks(boolean redstoneCheck) {
        if (this.heat > 0) {
            this.heat = Math.max(0, this.heat - (Integer)LavaGenConfig.heatLossPassive.get());
            this.cobblePoints += ((Integer)LavaGenConfig.heatLossPassive.get()).intValue();
            this.doActiveCooling();
        }
        if (redstoneCheck && !this.getEnergy().isFull() && this.getEnergy().hasCapacitor() && !this.isOutputFull()) {
            if (this.burnTime > 0) {
                this.getEnergy().setEnergyStored(this.getEnergy().getEnergyStored() + this.getPowerGenPerTick());
                --this.burnTime;
                this.heat = Math.min(this.heat + (Integer)LavaGenConfig.heatGain.get(), this.getMaxHeat());
            }
            if (this.burnTime <= 0 && !this.tank.isEmpty()) {
                this.tank.drain(1, true);
                this.burnTime = this.getLavaBurntime() / 1000 / CapacitorKey.LAVAGEN_POWER_FLUID_USE.get(this.getCapacitorData());
                if (((Boolean)LavaGenConfig.outputEnabled.get()).booleanValue()) {
                    ++this.lavaUsed;
                    this.doGenOutput();
                }
            }
        }
        if (this.getHeat() > ((Float)LavaGenConfig.overheatThreshold.get()).floatValue() && this.shouldDoWorkThisTick(20)) {
            int dx = this.random.nextInt(8) - this.random.nextInt(8);
            int dy = this.random.nextInt(4) - this.random.nextInt(4);
            int dz = this.random.nextInt(8) - this.random.nextInt(8);
            BlockPos pos2 = this.field_174879_c.func_177965_g(dx).func_177981_b(dy).func_177964_d(dz);
            if (this.field_145850_b.func_175623_d(pos2)) {
                this.field_145850_b.func_175656_a(pos2, Blocks.field_150480_ab.func_176223_P());
            }
        }
        this.transmitEnergy();
        return false;
    }

    private void doGenOutput() {
        while (this.lavaUsed >= (Integer)LavaGenConfig.outputAmount.get()) {
            String slotName;
            ItemStack stack;
            if (this.cobblePoints > this.stonePoints && this.cobblePoints > this.obsidianPoints) {
                this.cobblePoints = 0;
                if (!((Boolean)LavaGenConfig.cobbleEnabled.get()).booleanValue()) continue;
                stack = new ItemStack(Blocks.field_150347_e);
                slotName = OUTPUT_COB;
            } else if (this.obsidianPoints > this.stonePoints) {
                this.obsidianPoints = 0;
                if (!((Boolean)LavaGenConfig.obsidianEnabled.get()).booleanValue()) continue;
                stack = new ItemStack(Blocks.field_150343_Z);
                slotName = OUTPUT_OBS;
            } else {
                this.stonePoints = 0;
                if (!((Boolean)LavaGenConfig.stoneEnabled.get()).booleanValue()) continue;
                stack = new ItemStack(Blocks.field_150348_b);
                slotName = OUTPUT_STO;
            }
            if (!this.mergeOutput(slotName, stack)) break;
            this.lavaUsed -= ((Integer)LavaGenConfig.outputAmount.get()).intValue();
        }
    }

    private void doActiveCooling() {
        if (this.heat > 0 && (Integer)LavaGenConfig.heatLossActive.get() > 0) {
            EnumFacing side;
            BlockPos pos2;
            ++this.coolingSide;
            if (this.coolingSide > 5) {
                this.coolingSide = 0;
            }
            if (this.field_145850_b.func_175667_e(pos2 = this.field_174879_c.func_177972_a(side = (EnumFacing)NNList.FACING.get(this.coolingSide)))) {
                Block block = this.field_145850_b.func_180495_p(pos2).func_177230_c();
                if (block instanceof IFluidBlock || block instanceof BlockLiquid) {
                    IFluidHandler targetFluidHandler = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)pos2, (EnumFacing)side.func_176734_d());
                    if (targetFluidHandler != null) {
                        FluidStack fluidStack = targetFluidHandler.drain(1000, false);
                        float heatInKelvin = this.getHeatDisplayValue();
                        if (fluidStack != null && fluidStack.amount >= 1000 && (float)fluidStack.getFluid().getTemperature(fluidStack) < heatInKelvin) {
                            this.heat = Math.max(0, this.heat - (Integer)LavaGenConfig.heatLossActive.get());
                            if (fluidStack.getFluid() == FluidRegistry.WATER) {
                                if (heatInKelvin > LangTemperature.C2K((float)100.0f) && this.random.nextFloat() < ((Float)LavaGenConfig.activeCoolingEvaporatesWater.get()).floatValue()) {
                                    this.field_145850_b.func_175698_g(pos2);
                                    this.field_145850_b.func_184148_a(null, (double)((float)pos2.func_177958_n() + 0.5f), (double)((float)pos2.func_177956_o() + 0.5f), (double)((float)pos2.func_177952_p() + 0.5f), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.8f);
                                    PacketSpawnParticles effect = new PacketSpawnParticles();
                                    for (int k = 0; k < 8; ++k) {
                                        effect.add((double)pos2.func_177958_n() + this.random.nextDouble(), (double)pos2.func_177956_o() + this.random.nextDouble(), (double)pos2.func_177952_p() + this.random.nextDouble(), 1, new EnumParticleTypes[]{EnumParticleTypes.SMOKE_LARGE});
                                    }
                                    effect.send(this.field_145850_b, pos2);
                                    this.stonePoints += ((Integer)LavaGenConfig.heatLossActive.get()).intValue();
                                } else {
                                    this.cobblePoints += ((Integer)LavaGenConfig.heatLossActive.get()).intValue();
                                }
                            } else if ((float)fluidStack.getFluid().getTemperature(fluidStack) < LangTemperature.C2K((float)0.0f)) {
                                this.obsidianPoints += ((Integer)LavaGenConfig.heatLossActive.get()).intValue();
                            } else {
                                this.cobblePoints += ((Integer)LavaGenConfig.heatLossActive.get()).intValue();
                            }
                        }
                    }
                } else if (block == Blocks.field_150432_aD || block == Blocks.field_185778_de || block == Blocks.field_150403_cj) {
                    this.heat = Math.max(0, this.heat - (Integer)LavaGenConfig.heatLossActive.get());
                    this.obsidianPoints += ((Integer)LavaGenConfig.heatLossActive.get()).intValue();
                    if (this.random.nextFloat() < ((Float)LavaGenConfig.activeCoolingLiquefiesIce.get()).floatValue()) {
                        if (this.field_145850_b.field_73011_w.func_177500_n()) {
                            this.field_145850_b.func_175698_g(pos2);
                            this.field_145850_b.func_184148_a(null, (double)((float)pos2.func_177958_n() + 0.5f), (double)((float)pos2.func_177956_o() + 0.5f), (double)((float)pos2.func_177952_p() + 0.5f), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.8f);
                            for (int k = 0; k < 8; ++k) {
                                PacketSpawnParticles.create((World)this.field_145850_b, (double)((double)pos2.func_177958_n() + this.random.nextDouble()), (double)((double)pos2.func_177956_o() + this.random.nextDouble()), (double)((double)pos2.func_177952_p() + this.random.nextDouble()), (int)1, (EnumParticleTypes[])new EnumParticleTypes[]{EnumParticleTypes.SMOKE_LARGE});
                            }
                        } else {
                            this.field_145850_b.func_175656_a(pos2, Blocks.field_150355_j.func_176223_P());
                            for (int k = 0; k < 4; ++k) {
                                PacketSpawnParticles.create((World)this.field_145850_b, (double)((double)pos2.func_177958_n() + this.random.nextDouble()), (double)(pos2.func_177956_o() + 1), (double)((double)pos2.func_177952_p() + this.random.nextDouble()), (int)1, (EnumParticleTypes[])new EnumParticleTypes[]{EnumParticleTypes.SMOKE_LARGE});
                            }
                            Blocks.field_150355_j.func_189540_a(Blocks.field_150355_j.func_176223_P(), this.field_145850_b, pos2, block, pos2);
                        }
                    }
                }
            }
        }
    }

    private int getLavaBurntime() {
        return (Boolean)LavaGenConfig.useVanillaBurnTime.get() != false ? 20000 : TileEntityFurnace.func_145952_a((ItemStack)new ItemStack(Items.field_151129_at));
    }

    public static int getNominalPowerGenPerTick(@Nonnull ICapacitorData data) {
        return CapacitorKey.LAVAGEN_POWER_GEN.get(data);
    }

    protected int getPowerGenPerTick() {
        return this.getEnergy().hasCapacitor() ? (int)Math.max(1.0f, (float)this.getEnergy().getMaxUsage() * this.getHeatFactor()) : 0;
    }

    protected float getHeatFactor() {
        return Math.max(((Float)LavaGenConfig.minEfficiency.get()).floatValue(), 1.0f - this.getHeat());
    }

    protected float getHeat() {
        return (float)this.heat / (float)this.getMaxHeat();
    }

    protected float getHeatDisplayValue() {
        float factor = this.getHeat();
        int ambient = FluidRegistry.WATER.getTemperature();
        int reallyhot = FluidRegistry.LAVA.getTemperature();
        return (float)ambient + (float)(reallyhot - ambient) * factor;
    }

    protected int getMaxHeat() {
        return this.getLavaBurntime() * (Integer)LavaGenConfig.maxHeatFactor.get();
    }

    private boolean mergeOutput(@Nonnull String slotName, @Nonnull ItemStack stack) {
        InventorySlot slot = this.getInventory().getSlot(slotName);
        ItemStack oldStack = slot.get();
        if (Prep.isInvalid((ItemStack)oldStack)) {
            slot.set(stack);
            return true;
        }
        if (ItemUtil.areStackMergable((ItemStack)oldStack, (ItemStack)stack)) {
            oldStack.func_190917_f(stack.func_77979_a(Math.min(Math.min(oldStack.func_77976_d(), slot.getMaxStackSize()) - oldStack.func_190916_E(), stack.func_190916_E())).func_190916_E());
            slot.set(oldStack);
            return stack.func_190926_b();
        }
        return false;
    }

    private boolean isOutputFull() {
        for (InventorySlot slot : this.getInventory().getView(EnderInventory.Type.OUTPUT)) {
            ItemStack stack = slot.get();
            if (Prep.isInvalid((ItemStack)stack)) {
                return false;
            }
            if (stack.func_190916_E() < stack.func_77976_d() && stack.func_190916_E() < slot.getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    private boolean transmitEnergy() {
        int canTransmit;
        if (this.powerDis == null) {
            this.powerDis = new PowerDistributor(this.func_174877_v());
        }
        if ((canTransmit = Math.min(this.getEnergy().getEnergyStored(), this.getEnergy().getMaxUsage() * 2)) <= 0) {
            return false;
        }
        int transmitted = this.powerDis.transmitEnergy(this.field_145850_b, canTransmit);
        this.getEnergy().setEnergyStored(this.getEnergy().getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler((IIoConfigurable)this, new IFluidHandler[]{this.tank});
        }
        return this.smartTankFluidHandler;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return (T)super.getCapability(capability, facingIn);
    }

    @Nullable
    public FluidTank getInputTank(FluidStack forFluidType) {
        if (this.tank.canFill(forFluidType)) {
            return this.tank;
        }
        return null;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.func_70296_d();
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileLavaGenerator.this.tank.getFluid();
            }

            public int getCapacity() {
                return TileLavaGenerator.this.tank.getCapacity();
            }
        });
    }
}

