/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.lava;

import com.enderio.core.client.gui.IDrawingElement;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.lang.LangTemperature;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityMachineEntity;
import crazypants.enderio.base.machine.gui.GenericBar;
import crazypants.enderio.base.machine.gui.GuiCapMachineBase;
import crazypants.enderio.base.machine.gui.IPowerBarData;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.machines.machine.generator.lava.ContainerLavaGenerator;
import crazypants.enderio.machines.machine.generator.lava.TileLavaGenerator;
import java.awt.Rectangle;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class GuiLavaGenerator
extends GuiCapMachineBase<TileLavaGenerator> {
    private static final int POWERX = 12;
    private static final int POWERY = 14;
    private static final int POWER_HEIGHT = 42;
    @Nonnull
    private static final Rectangle RECTANGLE_TANK = new Rectangle(70, 21, 16, 47);
    @Nonnull
    private static final Rectangle RECTANGLE_HEAT = new Rectangle(91, 21, 16, 47);

    public GuiLavaGenerator(@Nonnull InventoryPlayer playerInv, @Nonnull TileLavaGenerator te) {
        super((AbstractCapabilityMachineEntity)te, new ContainerLavaGenerator<TileLavaGenerator>(playerInv, te), new String[]{"lava_generator"});
        this.addDrawingElement((IDrawingElement)new PowerBar((IPowerBarData)te.getEnergy(), (GuiContainerBaseEIO)this, 16, 14, 42));
        this.addToolTip(new GuiToolTip(RECTANGLE_TANK, new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(crazypants.enderio.machines.lang.Lang.GUI_TANK_TANK_TANK_TANK.get());
                this.text.add(LangFluid.MB((IFluidTank)((TileLavaGenerator)((GuiLavaGenerator)GuiLavaGenerator.this).getTileEntity()).tank));
            }
        });
        this.addDrawingElement((IDrawingElement)new GenericBar((GuiContainerBaseEIO)this, RECTANGLE_HEAT, -1, new GuiToolTip(RECTANGLE_HEAT, new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(crazypants.enderio.machines.lang.Lang.GUI_LAVAGEN_HEAT.get());
                this.text.add(LangTemperature.degK((float)((TileLavaGenerator)GuiLavaGenerator.this.getTileEntity()).getHeatDisplayValue()));
                this.text.add(Lang.GUI_GENERIC_EFFICIENCY.get(new Object[]{(int)(((TileLavaGenerator)GuiLavaGenerator.this.getTileEntity()).getHeatFactor() * 100.0f)}));
                this.text.add(LangPower.RFt((int)((TileLavaGenerator)GuiLavaGenerator.this.getTileEntity()).getPowerGenPerTick()));
            }
        }){

            protected float getLevel() {
                return ((TileLavaGenerator)GuiLavaGenerator.this.getTileEntity()).getHeat();
            }

            protected int getColor() {
                return (double)this.getLevel() < 0.5 ? -1339110631 : ((double)this.getLevel() < 0.75 ? -1325411809 : -1326311400);
            }
        });
    }

    protected boolean showRecipeButton() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        NNList ghostSlots = this.getGhostSlotHandler().getGhostSlots();
        ghostSlots.clear();
        ((ContainerLavaGenerator)this.field_147002_h).createGhostSlots((List<GhostSlot>)ghostSlots);
    }

    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        if (RECTANGLE_TANK.contains(mouseX, mouseY)) {
            return ((TileLavaGenerator)this.getTileEntity()).tank.getFluid();
        }
        return super.getIngredientUnderMouse(mouseX, mouseY);
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(par1, par2, par3);
        RenderUtil.renderGuiTank((FluidTank)((TileLavaGenerator)this.getTileEntity()).tank, (double)(this.field_147003_i + GuiLavaGenerator.RECTANGLE_TANK.x), (double)(this.field_147009_r + GuiLavaGenerator.RECTANGLE_TANK.y), (double)this.field_73735_i, (double)GuiLavaGenerator.RECTANGLE_TANK.width, (double)GuiLavaGenerator.RECTANGLE_TANK.height);
    }
}

