/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.integration.jei.RecipeWrapper;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.base.recipe.IManyToOneRecipe;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.alloysmelter.AlloyRecipeManager;
import crazypants.enderio.machines.config.config.PersonalConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.alloy.ContainerAlloySmelter;
import crazypants.enderio.machines.machine.alloy.GuiAlloySmelter;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class AlloyRecipeCategory
extends BlankRecipeCategory<AlloyRecipeWrapper> {
    @Nonnull
    public static final String UID = "AlloySmelter";
    private static final int xOff = 45;
    private static final int yOff = 3;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final IDrawableAnimated flame;

    public static void register(IModRegistry registry, @Nonnull IGuiHelper guiHelper) {
        if (!((Boolean)PersonalConfig.enableAlloySmelterAlloyingJEIRecipes.get()).booleanValue() && !((Boolean)PersonalConfig.enableAlloySmelterFurnaceJEIRecipes.get()).booleanValue()) {
            return;
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloyRecipeCategory(guiHelper)});
        registry.addRecipeClickArea(GuiAlloySmelter.Normal.class, 155, 42, 16, 16, new String[]{UID, "minecraft.smelting"});
        registry.addRecipeClickArea(GuiAlloySmelter.Simple.class, 155, 42, 16, 16, new String[]{UID});
        registry.addRecipeClickArea(GuiAlloySmelter.Furnace.class, 155, 42, 16, 16, new String[]{"minecraft.smelting"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_simple_furnace.getBlockNN()), new String[]{"minecraft.smelting"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_alloy_smelter.getBlockNN()), new String[]{UID, "minecraft.smelting"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_simple_alloy_smelter.getBlockNN()), new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_enhanced_alloy_smelter.getBlockNN()), new String[]{UID, "minecraft.smelting"});
        long start = System.nanoTime();
        ArrayList<AlloyRecipeWrapper> result = new ArrayList<AlloyRecipeWrapper>();
        if (((Boolean)PersonalConfig.enableAlloySmelterAlloyingJEIRecipes.get()).booleanValue()) {
            for (IManyToOneRecipe rec : AlloyRecipeManager.getInstance().getRecipes()) {
                if (rec.isSynthetic()) continue;
                result.add(new AlloyRecipeWrapper((IRecipe)rec, guiHelper));
            }
        }
        if (((Boolean)PersonalConfig.enableAlloySmelterFurnaceJEIRecipes.get()).booleanValue()) {
            for (IManyToOneRecipe rec : AlloyRecipeManager.getInstance().getVanillaRecipe().getAllRecipes()) {
                result.add(new AlloyRecipeWrapper((IRecipe)rec, guiHelper));
            }
        }
        long end = System.nanoTime();
        registry.addRecipes(result, UID);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerAlloySmelter.Normal.class, UID, ContainerAlloySmelter.FIRST_RECIPE_SLOT, ContainerAlloySmelter.NUM_RECIPE_SLOT, ContainerAlloySmelter.FIRST_INVENTORY_SLOT, ContainerAlloySmelter.NUM_INVENTORY_SLOT);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerAlloySmelter.Simple.class, UID, ContainerAlloySmelter.FIRST_RECIPE_SLOT, ContainerAlloySmelter.NUM_RECIPE_SLOT, ContainerAlloySmelter.FIRST_INVENTORY_SLOT - 1, ContainerAlloySmelter.NUM_INVENTORY_SLOT);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerAlloySmelter.Normal.class, "minecraft.smelting", ContainerAlloySmelter.FIRST_RECIPE_SLOT, ContainerAlloySmelter.NUM_RECIPE_SLOT, ContainerAlloySmelter.FIRST_INVENTORY_SLOT, ContainerAlloySmelter.NUM_INVENTORY_SLOT);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerAlloySmelter.Furnace.class, "minecraft.smelting", ContainerAlloySmelter.FIRST_RECIPE_SLOT, ContainerAlloySmelter.NUM_RECIPE_SLOT, ContainerAlloySmelter.FIRST_INVENTORY_SLOT - 1, ContainerAlloySmelter.NUM_INVENTORY_SLOT);
        Log.info((Object[])new Object[]{String.format("AlloyRecipeCategory: Added %d alloy smelter recipes to JEI in %.3f seconds.", result.size(), (double)(end - start) / 1.0E9)});
    }

    public AlloyRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("alloy_smelter_auto");
        this.background = guiHelper.createDrawable(backgroundLocation, 45, 3, 82, 78);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 176, 0, 14, 14);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_alloy_smelter.getBlockNN().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.flame.draw(minecraft, 10, 32);
        this.flame.draw(minecraft, 58, 32);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull AlloyRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        guiItemStacks.init(0, true, 8, 13);
        guiItemStacks.init(1, true, 33, 3);
        guiItemStacks.init(2, true, 57, 13);
        guiItemStacks.init(3, false, 33, 54);
        group.init(4, true, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 63, 52, 50, 10, 0, 0);
        List inputs = ingredients.getInputs(ItemStack.class);
        for (int index = 0; index < inputs.size(); ++index) {
            List input = (List)inputs.get(index);
            if (input == null) continue;
            guiItemStacks.set(index, input);
        }
        List outputs = ingredients.getOutputs(ItemStack.class);
        guiItemStacks.set(3, (List)outputs.get(0));
        group.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class AlloyRecipeWrapper
    extends RecipeWrapper {
        private IDrawable alloyFront;

        public AlloyRecipeWrapper(IRecipe recipe, @Nonnull IGuiHelper guiHelper) {
            super(recipe);
            if (!RecipeLevel.SIMPLE.canMake(recipe.getRecipeLevel())) {
                this.alloyFront = guiHelper.createDrawable(new ResourceLocation("enderio", "textures/blocks/alloy_smelter_simple_front.png"), 0, 0, 16, 16, 16, 16);
            }
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            NNList inputStacks = this.recipe.getInputStackAlternatives();
            if (!(this.recipe instanceof IManyToOneRecipe) || !((IManyToOneRecipe)this.recipe).isDedupeInput()) {
                ingredients.setInputLists(ItemStack.class, (List)inputStacks);
            } else {
                List list0 = inputStacks.size() >= 1 ? (List)inputStacks.get(0) : new NNList((Object[])new ItemStack[]{Prep.getEmpty()});
                List list1 = inputStacks.size() >= 2 ? (List)inputStacks.get(1) : new NNList((Object[])new ItemStack[]{Prep.getEmpty()});
                List list2 = inputStacks.size() >= 3 ? (List)inputStacks.get(2) : new NNList((Object[])new ItemStack[]{Prep.getEmpty()});
                NNList out0 = new NNList();
                NNList out1 = new NNList();
                NNList out2 = new NNList();
                Iterator iterator = list0.iterator();
                while (iterator.hasNext()) {
                    ItemStack stack0 = (ItemStack)iterator.next();
                    if (stack0 == null) continue;
                    Iterator iterator2 = list1.iterator();
                    while (iterator2.hasNext()) {
                        ItemStack stack1 = (ItemStack)iterator2.next();
                        if (stack1 == null || AlloyRecipeWrapper.eq(stack0, stack1)) continue;
                        Iterator iterator3 = list2.iterator();
                        while (iterator3.hasNext()) {
                            ItemStack stack2 = (ItemStack)iterator3.next();
                            if (stack2 == null || AlloyRecipeWrapper.eq(stack0, stack2) || AlloyRecipeWrapper.eq(stack1, stack2)) continue;
                            out0.add(stack0);
                            out1.add(stack1);
                            out2.add(stack2);
                        }
                    }
                }
                if (!out0.isEmpty()) {
                    NNList inputs = new NNList();
                    inputs.add((Object)out0);
                    if (!out1.isEmpty()) {
                        inputs.add((Object)out1);
                        if (!out2.isEmpty()) {
                            inputs.add((Object)out2);
                        }
                    }
                    ingredients.setInputLists(ItemStack.class, (List)inputs);
                }
            }
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            for (RecipeOutput out : this.recipe.getOutputs()) {
                if (!Prep.isValid((ItemStack)out.getOutput())) continue;
                outputs.add(out.getOutput());
            }
            ingredients.setOutputs(ItemStack.class, outputs);
            ingredients.setInput(EnergyIngredient.class, (Object)new EnergyIngredient(this.recipe.getEnergyRequired()));
        }

        private static boolean eq(@Nonnull ItemStack a, @Nonnull ItemStack b) {
            return a.func_77973_b() == b.func_77973_b() && a.func_77952_i() == b.func_77952_i();
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            if (this.alloyFront != null) {
                this.alloyFront.draw(minecraft, 84, 32);
                IconEIO.map.render((IWidgetIcon)IconEIO.GENERIC_VERBOTEN, 90.0, 26.0, true);
            }
        }

        @Nonnull
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            if (this.alloyFront != null && mouseX >= 76 && mouseX <= 108 && mouseY >= 24 && mouseY <= 56) {
                return Lang.JEI_ALLOY_NOTSIMPLE.getLines(new Object[0]);
            }
            return super.getTooltipStrings(mouseX, mouseY);
        }
    }
}

