/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.client.render.target;

import com.elytradev.architecture.client.render.target.RenderTargetBase;
import com.elytradev.architecture.common.ArchitectureLog;
import com.elytradev.architecture.common.helpers.Vector3;
import com.elytradev.architecture.common.utils.MiscUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class RenderTargetWorld
extends RenderTargetBase {
    protected IBlockAccess world;
    protected BlockPos blockPos;
    protected IBlockState blockState;
    protected Block block;
    protected float cmr = 1.0f;
    protected float cmg = 1.0f;
    protected float cmb = 1.0f;
    protected boolean ao;
    protected boolean axisAlignedNormal;
    protected boolean renderingOccurred;
    protected float vr;
    protected float vg;
    protected float vb;
    protected float va;
    protected int vlm1;
    protected int vlm2;
    private BufferBuilder tess;

    public RenderTargetWorld(IBlockAccess world, BlockPos pos, BufferBuilder tess, TextureAtlasSprite overrideIcon) {
        super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), overrideIcon);
        this.world = world;
        this.blockPos = pos;
        this.blockState = world.func_180495_p(pos);
        this.block = this.blockState.func_177230_c();
        this.setTess(tess);
        this.ao = Minecraft.func_71379_u() && this.block.func_149750_m(this.blockState) == 0;
        this.expandTrianglesToQuads = true;
    }

    @Override
    public void setNormal(Vector3 n) {
        super.setNormal(n);
        this.axisAlignedNormal = n.dot(this.face) >= 0.99;
    }

    @Override
    protected void rawAddVertex(Vector3 p, double u, double v) {
        this.lightVertex(p);
        this.getWorldRenderer().func_181662_b(p.x, p.y, p.z);
        this.getWorldRenderer().func_181666_a(this.vr, this.vg, this.vb, this.va);
        this.getWorldRenderer().func_187315_a(u, v);
        this.getWorldRenderer().func_187314_a(this.vlm1, this.vlm2);
        this.getWorldRenderer().func_181675_d();
        this.renderingOccurred = true;
    }

    protected void lightVertex(Vector3 p) {
        if (this.ao) {
            this.aoLightVertex(p);
        } else {
            this.brLightVertex(p);
        }
    }

    protected void aoLightVertex(Vector3 v) {
        Vector3 n = this.normal;
        double brSum1 = 0.0;
        double brSum2 = 0.0;
        double lvSum = 0.0;
        double wt = 0.0;
        double vx = v.x + 0.5 * n.x;
        double vy = v.y + 0.5 * n.y;
        double vz = v.z + 0.5 * n.z;
        for (int dx = -1; dx <= 1; dx += 2) {
            for (int dy = -1; dy <= 1; dy += 2) {
                for (int dz = -1; dz <= 1; dz += 2) {
                    float lv;
                    int br;
                    double woz;
                    double woy;
                    int X = MiscUtils.ifloor(vx + 0.5 * (double)dx);
                    int Y = MiscUtils.ifloor(vy + 0.5 * (double)dy);
                    int Z = MiscUtils.ifloor(vz + 0.5 * (double)dz);
                    BlockPos pos = new BlockPos(X, Y, Z);
                    double wox = dx < 0 ? (double)(X + 1) - (vx - 0.5) : vx + 0.5 - (double)X;
                    double w = wox * (woy = dy < 0 ? (double)(Y + 1) - (vy - 0.5) : vy + 0.5 - (double)Y) * (woz = dz < 0 ? (double)(Z + 1) - (vz - 0.5) : vz + 0.5 - (double)Z);
                    if (!(w > 0.0)) continue;
                    try {
                        br = this.block.func_185484_c(this.blockState, this.world, pos);
                    }
                    catch (RuntimeException e) {
                        ArchitectureLog.info("BaseWorldRenderTarget.aoLightVertex: getMixedBrightnessForBlock(%s) with weight %s for block at %s: %s\n", pos, w, this.blockPos, e);
                        throw e;
                    }
                    if (!pos.equals((Object)this.blockPos)) {
                        IBlockState state = this.world.func_180495_p(pos);
                        lv = state.func_177230_c().func_185485_f(state);
                    } else {
                        lv = 1.0f;
                    }
                    if (br != 0) {
                        double br1 = (double)(br >> 16 & 0xFF) / 240.0;
                        double br2 = (double)(br & 0xFF) / 240.0;
                        brSum1 += w * br1;
                        brSum2 += w * br2;
                        wt += w;
                    }
                    lvSum += w * (double)lv;
                }
            }
        }
        int brv = wt > 0.0 ? MiscUtils.iround(brSum1 / wt * 240.0) << 16 | MiscUtils.iround(brSum2 / wt * 240.0) : this.block.func_185484_c(this.blockState, this.world, this.blockPos);
        float lvv = (float)lvSum;
        this.setLight(this.shade * lvv, brv);
    }

    protected void brLightVertex(Vector3 p) {
        Vector3 n = this.normal;
        BlockPos pos = this.axisAlignedNormal ? new BlockPos((int)Math.floor(p.x + 0.01 * n.x), (int)Math.floor(p.y + 0.01 * n.y), (int)Math.floor(p.z + 0.01 * n.z)) : this.blockPos;
        int br = this.block.func_185484_c(this.blockState, this.world, pos);
        this.setLight(this.shade, br);
    }

    protected void setLight(float shadow, int br) {
        this.vr = shadow * this.cmr * this.r();
        this.vg = shadow * this.cmg * this.g();
        this.vb = shadow * this.cmb * this.b();
        this.va = this.a();
        this.vlm1 = br >> 16;
        this.vlm2 = br & 0xFFFF;
    }

    public boolean end() {
        super.finish();
        return this.renderingOccurred;
    }

    public BufferBuilder getWorldRenderer() {
        return this.tess;
    }

    public void setTess(BufferBuilder tess) {
        this.tess = tess;
    }
}

