/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.lib.icon.ImageIcon;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class URLImageIcon
extends ImageIcon {
    public final URI uri;
    private final String url;

    public URLImageIcon(ResourceLocation tex, URI _uri, double u0, double v0, double u1, double v1) {
        super(tex, u0, v0, u1, v1);
        this.uri = _uri;
        this.url = this.uri.toString();
    }

    public URLImageIcon(ResourceLocation tex, URI uri) {
        this(tex, uri, 0.0, 0.0, 1.0, 1.0);
    }

    public URLImageIcon(URI uri) {
        this(new ResourceLocation(uri.toString()), uri);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTexture() {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject img = manager.func_110581_b(this.texture);
        if (img == null) {
            if (this.uri.getScheme().equals("http") || this.uri.getScheme().equals("https")) {
                img = new ThreadDownloadImageData(null, this.url, MISSING_IMAGE, null);
            } else {
                File file = null;
                if (this.uri.getScheme().equals("file")) {
                    try {
                        file = new File(this.uri.getPath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (file == null) {
                    file = new File(this.uri);
                }
                img = new ThreadDownloadImageData(file, this.url, MISSING_IMAGE, null);
            }
            manager.func_110579_a(this.texture, img);
        }
        GlStateManager.func_179144_i((int)img.func_110552_b());
    }

    @Override
    public String toString() {
        return this.url;
    }

    @Override
    public URLImageIcon withUV(double u0, double v0, double u1, double v1) {
        return new URLImageIcon(this.texture, this.uri, u0, v0, u1, v1);
    }

    @Override
    public URLImageIcon withUVfromCoords(int x, int y, int w, int h, int tw, int th) {
        return this.withUV((double)x / (double)tw, (double)y / (double)th, (double)(x + w) / (double)tw, (double)(y + h) / (double)th);
    }

    @Override
    public BufferedImage readImage() throws Exception {
        return DataReader.get(this.uri, Minecraft.func_71410_x().func_110437_J()).image();
    }
}

