/*
 * Decompiled with CFR 0.152.
 */
package zentriggers.zentriggers;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.util.IEventHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import zentriggers.zentriggers.PredicateBuilder;
import zentriggers.zentriggers.wrappers.MCLivingUpdateEvent;

@ZenClass(value="mods.zentriggers.Handler")
@ZenRegister
@Mod.EventBusSubscriber
public class Handler {
    private static Map<Class<? extends LivingEvent.LivingUpdateEvent>, Map<PredicateBuilder, IEventHandler<MCLivingUpdateEvent>>> handlers = new HashMap<Class<? extends LivingEvent.LivingUpdateEvent>, Map<PredicateBuilder, IEventHandler<MCLivingUpdateEvent>>>();

    @SubscribeEvent
    public static void onEntityUpdateRaw(LivingEvent.LivingUpdateEvent event) {
        handlers.computeIfAbsent(LivingEvent.LivingUpdateEvent.class, k -> new HashMap()).forEach((predicates, handler) -> {
            if (predicates.test(event)) {
                try {
                    handler.handle((Object)new MCLivingUpdateEvent(event));
                }
                catch (Throwable t) {
                    System.out.println("Error occurred invoking handler for onEntityUpdate");
                    t.printStackTrace();
                }
            }
        });
    }

    @ZenMethod
    public static void onEntityUpdate(PredicateBuilder builder, IEventHandler<MCLivingUpdateEvent> handler) {
        if (builder == null || handler == null) {
            System.out.println("Builder or handler null trying to register ZenTriggers event, skipping. [Builder: " + builder + ", Handler: " + handler + "]");
        }
        handlers.computeIfAbsent(LivingEvent.LivingUpdateEvent.class, k -> new HashMap()).put(builder, handler);
    }
}

