/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.zensummoning.common.tiles;

import ca.teamdman.zensummoning.MobInfo;
import ca.teamdman.zensummoning.SummoningAttempt;
import ca.teamdman.zensummoning.SummoningDirector;
import ca.teamdman.zensummoning.SummoningInfo;
import ca.teamdman.zensummoning.ZenSummoning;
import com.google.common.collect.ImmutableList;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileAltar
extends TileEntity
implements ITickable {
    public final int TIME_TO_SPAWN = 100;
    private final ItemStackHandler clientInventory = new ItemStackHandler();
    private final ItemStackHandler inventory = new ItemStackHandler(SummoningDirector.getStackLimit()){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileAltar.this.field_145850_b.func_184138_a(TileAltar.this.field_174879_c, TileAltar.this.field_145850_b.func_180495_p(TileAltar.this.field_174879_c), TileAltar.this.field_145850_b.func_180495_p(TileAltar.this.field_174879_c), 3);
            TileAltar.this.func_70296_d();
        }
    };
    public int renderTick = -1;
    private int summonCountdown = -1;
    private SummoningInfo summonInfo;

    public void func_73660_a() {
        if (!this.isSpawning()) {
            if (this.renderTick > -1) {
                --this.renderTick;
            }
            return;
        }
        --this.summonCountdown;
        ++this.renderTick;
        if (this.summonCountdown > 0) {
            return;
        }
        this.summonFinish();
    }

    public boolean isSpawning() {
        return this.summonInfo != null && this.summonCountdown >= 0;
    }

    private void summonFinish() {
        ZenSummoning.log("summonFinish");
        this.summonCountdown = -1;
        if (this.field_145850_b.field_72995_K) {
            this.summonInfo = null;
            return;
        }
        for (MobInfo mobInfo : this.summonInfo.getMobs()) {
            for (int i = 0; i < mobInfo.getCount(); ++i) {
                Entity mob = EntityList.func_188429_b((ResourceLocation)mobInfo.getMob(), (World)this.field_145850_b);
                if (mob == null) {
                    return;
                }
                mob.func_70020_e(mobInfo.getData());
                mob.func_70107_b((double)(this.func_174877_v().func_177958_n() + mobInfo.getOffset().func_177958_n() + this.field_145850_b.field_73012_v.nextInt(Math.abs(mobInfo.getSpread().func_177958_n() * 2)) - Math.abs(mobInfo.getSpread().func_177958_n())), (double)(this.func_174877_v().func_177956_o() + mobInfo.getOffset().func_177956_o() + this.field_145850_b.field_73012_v.nextInt(Math.abs(mobInfo.getSpread().func_177956_o() * 2)) - Math.abs(mobInfo.getSpread().func_177956_o())), (double)(this.func_174877_v().func_177952_p() + mobInfo.getOffset().func_177952_p() + this.field_145850_b.field_73012_v.nextInt(Math.abs(mobInfo.getSpread().func_177952_p() * 2)) - Math.abs(mobInfo.getSpread().func_177952_p())));
                this.field_145850_b.func_72838_d(mob);
            }
        }
        this.summonInfo = null;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_191249_bs, SoundCategory.BLOCKS, 0.5f, 1.0f);
    }

    public SummoningAttempt summonStart(EntityPlayer player, EnumHand hand) {
        ZenSummoning.log("summonStart");
        SummoningAttempt attempt = new SummoningAttempt(CraftTweakerMC.getIWorld((World)this.field_145850_b), CraftTweakerMC.getIBlockPos((BlockPos)this.field_174879_c));
        if (this.isSpawning()) {
            attempt.setSuccess(false);
            attempt.setMessage("chat.zensummoning.busy");
            return attempt;
        }
        ItemStack handStack = player.func_184586_b(hand);
        SummoningInfo info = SummoningDirector.getSummonInfo(handStack);
        if (info == null) {
            attempt.setSuccess(false);
            attempt.setMessage("chat.zensummoning.no_match");
            return attempt;
        }
        HashMap<Integer, Integer> reagentMap = new HashMap<Integer, Integer>();
        for (ItemStack reagentStack : info.getReagents()) {
            int remaining = reagentStack.func_190916_E();
            for (int slot2 = 0; slot2 < this.inventory.getSlots() && remaining > 0; ++slot2) {
                ItemStack slotStack = this.inventory.getStackInSlot(slot2);
                int count2 = slotStack.func_190916_E() - reagentMap.getOrDefault(slot2, 0);
                if (!reagentStack.func_77969_a(slotStack) || count2 <= 0) continue;
                reagentMap.merge(slot2, Math.min(remaining, count2), (a, b) -> a + b);
                remaining -= count2;
            }
            if (remaining <= 0) continue;
            attempt.setSuccess(false);
            attempt.setMessage("chat.zensummoning.unsatisfied");
            return attempt;
        }
        info.getMutator().accept(attempt);
        if (!attempt.isSuccess()) {
            return attempt;
        }
        this.summonInfo = info;
        this.summonCountdown = 100;
        this.renderTick = 0;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_193784_dd, SoundCategory.BLOCKS, 0.5f, 1.0f);
        reagentMap.forEach((slot, count) -> this.inventory.extractItem(slot.intValue(), count.intValue(), false));
        handStack.func_190918_g(info.getCatalyst().func_190916_E());
        player.func_184611_a(hand, handStack);
        return attempt;
    }

    public ItemStack pushStack(ItemStack stack) {
        ItemStack rtn = stack;
        for (int slot = 0; slot < this.inventory.getSlots() && !rtn.func_190926_b(); ++slot) {
            rtn = this.inventory.insertItem(slot, rtn, false);
        }
        return rtn;
    }

    public ItemStack popStack() {
        for (int slot = this.inventory.getSlots() - 1; slot >= 0; --slot) {
            ItemStack rtn = this.inventory.getStackInSlot(slot);
            if (rtn.func_190926_b()) continue;
            return this.inventory.extractItem(slot, rtn.func_190916_E(), false);
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public ImmutableList<ItemStack> getClientStacks() {
        return this.getStacksFromInventory(this.clientInventory);
    }

    private ImmutableList<ItemStack> getStacksFromInventory(ItemStackHandler handler) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            builder.add((Object)stack);
        }
        return builder.build();
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.renderTick = compound.func_74762_e("renderTick");
        this.summonCountdown = compound.func_74762_e("summonCountdown");
        if (compound.func_74764_b("summonInfo")) {
            this.summonInfo = SummoningInfo.fromNBT(compound.func_74775_l("summonInfo"));
        } else if (!this.isSpawning()) {
            this.clientInventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74768_a("renderTick", this.renderTick);
        compound.func_74768_a("summonCountdown", this.summonCountdown);
        if (this.isSpawning()) {
            compound.func_74782_a("summonInfo", (NBTBase)this.summonInfo.serializeNBT());
        }
        return super.func_189515_b(compound);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound comp = new NBTTagCompound();
        this.func_189515_b(comp);
        return new SPacketUpdateTileEntity(this.field_174879_c, 255, comp);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nullable Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }
}

