/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.zensummoning;

import ca.teamdman.zensummoning.MobInfo;
import ca.teamdman.zensummoning.SummoningAttempt;
import ca.teamdman.zensummoning.common.Mutator;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.zensummoning.SummoningInfo")
@ZenRegister
public class SummoningInfo {
    private ItemStack catalyst = ItemStack.field_190927_a;
    private List<MobInfo> mobs = new ArrayList<MobInfo>();
    private Mutator<SummoningAttempt> mutator = __ -> {};
    private List<ItemStack> reagents = new ArrayList<ItemStack>();

    private SummoningInfo() {
    }

    public static SummoningInfo fromNBT(NBTTagCompound compound) {
        SummoningInfo info = new SummoningInfo();
        NBTTagList mobs = compound.func_150295_c("mobs", 10);
        for (int i = 0; i < mobs.func_74745_c(); ++i) {
            NBTTagCompound mob = mobs.func_150305_b(i);
            info.addMob(new MobInfo(mob.func_74775_l("data"), new ResourceLocation(mob.func_74779_i("mob")), new BlockPos(mob.func_74762_e("x"), mob.func_74762_e("y"), mob.func_74762_e("z")), new BlockPos(mob.func_74762_e("dx"), mob.func_74762_e("dy"), mob.func_74762_e("dz"))));
        }
        return info;
    }

    @ZenMethod
    public SummoningInfo addMob(MobInfo info) {
        this.mobs.add(info);
        return this;
    }

    @ZenMethod
    public static SummoningInfo create() {
        return new SummoningInfo();
    }

    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    @ZenMethod
    public SummoningInfo setCatalyst(IItemStack stack) {
        this.catalyst = CraftTweakerMC.getItemStack((IItemStack)stack);
        return this;
    }

    public List<MobInfo> getMobs() {
        return Collections.unmodifiableList(this.mobs);
    }

    public List<ItemStack> getReagents() {
        return Collections.unmodifiableList(this.reagents);
    }

    @ZenMethod
    public SummoningInfo setReagents(IItemStack[] reagents) {
        this.reagents.clear();
        Collections.addAll(this.reagents, CraftTweakerMC.getItemStacks((IItemStack[])reagents));
        return this;
    }

    public Mutator<SummoningAttempt> getMutator() {
        return this.mutator;
    }

    @ZenMethod
    public SummoningInfo setMutator(Mutator<SummoningAttempt> mutator) {
        this.mutator = mutator;
        return this;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList mobs = new NBTTagList();
        for (MobInfo info : this.mobs) {
            NBTTagCompound mob = new NBTTagCompound();
            mob.func_74778_a("mob", info.getMob().toString());
            mob.func_74782_a("data", (NBTBase)info.getData());
            mob.func_74768_a("x", info.getOffset().func_177958_n());
            mob.func_74768_a("y", info.getOffset().func_177956_o());
            mob.func_74768_a("z", info.getOffset().func_177952_p());
            mob.func_74768_a("dx", info.getSpread().func_177958_n());
            mob.func_74768_a("dy", info.getSpread().func_177956_o());
            mob.func_74768_a("dz", info.getSpread().func_177952_p());
            mobs.func_74742_a((NBTBase)mob);
        }
        compound.func_74782_a("mobs", (NBTBase)mobs);
        return compound;
    }
}

