/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.rules.SummonEventGetter;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.IModRuleCompatibilityLayer;
import mcjty.tools.rules.RuleBase;
import mcjty.tools.typed.Attribute;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.GenericAttributeMapFactory;
import mcjty.tools.typed.Key;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class SummonAidRule
extends RuleBase<SummonEventGetter> {
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    public static final IEventQuery<ZombieEvent.SummonAidEvent> EVENT_QUERY = new IEventQuery<ZombieEvent.SummonAidEvent>(){

        public World getWorld(ZombieEvent.SummonAidEvent o) {
            return o.getWorld();
        }

        public BlockPos getPos(ZombieEvent.SummonAidEvent o) {
            return new BlockPos(o.getX(), o.getY(), o.getZ());
        }

        public BlockPos getValidBlockPos(ZombieEvent.SummonAidEvent o) {
            return new BlockPos(o.getX(), o.getY() - 1, o.getZ());
        }

        public int getY(ZombieEvent.SummonAidEvent o) {
            return o.getY();
        }

        public Entity getEntity(ZombieEvent.SummonAidEvent o) {
            return o.getEntity();
        }

        public DamageSource getSource(ZombieEvent.SummonAidEvent o) {
            return null;
        }

        public Entity getAttacker(ZombieEvent.SummonAidEvent o) {
            return null;
        }

        public EntityPlayer getPlayer(ZombieEvent.SummonAidEvent o) {
            return null;
        }
    };
    private Event.Result result;
    private final GenericRuleEvaluator ruleEvaluator;
    private static Random rnd;

    private SummonAidRule(AttributeMap map) {
        super(InControl.logger);
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        this.addActions(map, new ModRuleCompatibilityLayer());
    }

    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        String br;
        super.addActions(map, layer);
        this.result = map.has(RuleKeys.ACTION_RESULT) ? ("default".equals(br = (String)map.get(RuleKeys.ACTION_RESULT)) || br.startsWith("def") ? Event.Result.DEFAULT : ("allow".equals(br) || "true".equals(br) ? Event.Result.ALLOW : Event.Result.DENY)) : Event.Result.DEFAULT;
        if (map.has(RuleKeys.ACTION_ANGRY)) {
            this.addAngryAction(map);
        }
        if (map.has(RuleKeys.ACTION_HELDITEM)) {
            this.addHeldItem(map);
        }
        if (map.has(RuleKeys.ACTION_ARMORBOOTS)) {
            this.addArmorItem(map, (Key<String>)RuleKeys.ACTION_ARMORBOOTS, EntityEquipmentSlot.FEET);
        }
        if (map.has(RuleKeys.ACTION_ARMORLEGS)) {
            this.addArmorItem(map, (Key<String>)RuleKeys.ACTION_ARMORLEGS, EntityEquipmentSlot.LEGS);
        }
        if (map.has(RuleKeys.ACTION_ARMORHELMET)) {
            this.addArmorItem(map, (Key<String>)RuleKeys.ACTION_ARMORHELMET, EntityEquipmentSlot.HEAD);
        }
        if (map.has(RuleKeys.ACTION_ARMORCHEST)) {
            this.addArmorItem(map, (Key<String>)RuleKeys.ACTION_ARMORCHEST, EntityEquipmentSlot.CHEST);
        }
        if (map.has(RuleKeys.ACTION_POTION)) {
            this.addPotionsAction(map);
        }
    }

    private void addPotionsAction(AttributeMap map) {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (String p : map.getList(RuleKeys.ACTION_POTION)) {
            String[] splitted = StringUtils.split((String)p, (char)',');
            if (splitted == null || splitted.length != 3) {
                InControl.logger.log(Level.ERROR, "Bad potion specifier '" + p + "'! Use <potion>,<duration>,<amplifier>");
                continue;
            }
            Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(splitted[0]));
            if (potion == null) {
                InControl.logger.log(Level.ERROR, "Can't find potion '" + p + "'!");
                continue;
            }
            int duration = 0;
            int amplifier = 0;
            try {
                duration = Integer.parseInt(splitted[1]);
                amplifier = Integer.parseInt(splitted[2]);
            }
            catch (NumberFormatException e) {
                InControl.logger.log(Level.ERROR, "Bad duration or amplifier integer for '" + p + "'!");
                continue;
            }
            effects.add(new PotionEffect(potion, duration, amplifier));
        }
        if (!effects.isEmpty()) {
            this.actions.add(event -> {
                EntityZombie living = event.getZombieHelper();
                for (PotionEffect effect : effects) {
                    PotionEffect neweffect = new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c());
                    living.func_70690_d(neweffect);
                }
            });
        }
    }

    private void addArmorItem(AttributeMap map, Key<String> itemKey, EntityEquipmentSlot slot) {
        List items = this.getItemsWeighted(map.getList(itemKey));
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            Pair pair = (Pair)items.get(0);
            this.actions.add(event -> {
                EntityZombie helper = event.getZombieHelper();
                helper.func_184201_a(slot, ((ItemStack)pair.getRight()).func_77946_l());
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                ItemStack item = this.getRandomItem(items, total);
                EntityZombie helper = event.getZombieHelper();
                helper.func_184201_a(slot, item.func_77946_l());
            });
        }
    }

    private void addHeldItem(AttributeMap map) {
        List items = this.getItemsWeighted(map.getList(RuleKeys.ACTION_HELDITEM));
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            Pair pair = (Pair)items.get(0);
            this.actions.add(event -> {
                EntityZombie helper = event.getZombieHelper();
                helper.func_184611_a(EnumHand.MAIN_HAND, ((ItemStack)pair.getRight()).func_77946_l());
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                ItemStack item = this.getRandomItem(items, total);
                EntityZombie helper = event.getZombieHelper();
                helper.func_184611_a(EnumHand.MAIN_HAND, item.func_77946_l());
            });
        }
    }

    private void addAngryAction(AttributeMap map) {
        if (((Boolean)map.get(RuleKeys.ACTION_ANGRY)).booleanValue()) {
            this.actions.add(event -> {
                EntityZombie helper = event.getZombieHelper();
                EntityPlayer player = event.getWorld().func_72890_a((Entity)helper, 50.0);
                if (player != null) {
                    helper.func_70624_b((EntityLivingBase)player);
                }
            });
        }
    }

    private void addHealthAction(AttributeMap map) {
        float m = map.has(RuleKeys.ACTION_HEALTHMULTIPLY) ? ((Float)map.get(RuleKeys.ACTION_HEALTHMULTIPLY)).floatValue() : 1.0f;
        float a = map.has(RuleKeys.ACTION_HEALTHADD) ? ((Float)map.get(RuleKeys.ACTION_HEALTHADD)).floatValue() : 0.0f;
        this.actions.add(event -> {
            EntityZombie helper = event.getZombieHelper();
            IAttributeInstance entityAttribute = helper.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (entityAttribute != null) {
                double newMax = entityAttribute.func_111125_b() * (double)m + (double)a;
                entityAttribute.func_111128_a(newMax);
                helper.func_70606_j((float)newMax);
            }
        });
    }

    private void addSpeedAction(AttributeMap map) {
        float m = map.has(RuleKeys.ACTION_SPEEDMULTIPLY) ? ((Float)map.get(RuleKeys.ACTION_SPEEDMULTIPLY)).floatValue() : 1.0f;
        float a = map.has(RuleKeys.ACTION_SPEEDADD) ? ((Float)map.get(RuleKeys.ACTION_SPEEDADD)).floatValue() : 0.0f;
        this.actions.add(event -> {
            EntityZombie helper = event.getZombieHelper();
            IAttributeInstance entityAttribute = helper.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (entityAttribute != null) {
                double newMax = entityAttribute.func_111125_b() * (double)m + (double)a;
                entityAttribute.func_111128_a(newMax);
            }
        });
    }

    private void addSizeActions(AttributeMap map) {
        InControl.logger.log(Level.WARN, "Mob resizing not implemented yet!");
        float m = map.has(RuleKeys.ACTION_SIZEMULTIPLY) ? ((Float)map.get(RuleKeys.ACTION_SIZEMULTIPLY)).floatValue() : 1.0f;
        float a = map.has(RuleKeys.ACTION_SIZEADD) ? ((Float)map.get(RuleKeys.ACTION_SIZEADD)).floatValue() : 0.0f;
        this.actions.add(event -> {
            EntityZombie helper = event.getZombieHelper();
        });
    }

    private void addDamageAction(AttributeMap map) {
        float m = map.has(RuleKeys.ACTION_DAMAGEMULTIPLY) ? ((Float)map.get(RuleKeys.ACTION_DAMAGEMULTIPLY)).floatValue() : 1.0f;
        float a = map.has(RuleKeys.ACTION_DAMAGEADD) ? ((Float)map.get(RuleKeys.ACTION_DAMAGEADD)).floatValue() : 0.0f;
        this.actions.add(event -> {
            EntityZombie helper = event.getZombieHelper();
            IAttributeInstance entityAttribute = helper.func_110148_a(SharedMonsterAttributes.field_111264_e);
            if (entityAttribute != null) {
                double newMax = entityAttribute.func_111125_b() * (double)m + (double)a;
                entityAttribute.func_111128_a(newMax);
            }
        });
    }

    public boolean match(ZombieEvent.SummonAidEvent event) {
        return this.ruleEvaluator.match((Event)event, EVENT_QUERY);
    }

    public void action(final ZombieEvent.SummonAidEvent event) {
        SummonEventGetter getter = new SummonEventGetter(){

            public EntityLivingBase getEntityLiving() {
                return event.getEntity() instanceof EntityLivingBase ? (EntityLivingBase)event.getEntity() : null;
            }

            public EntityPlayer getPlayer() {
                return null;
            }

            public World getWorld() {
                return event.getWorld();
            }

            public BlockPos getPosition() {
                return new BlockPos(event.getX(), event.getY(), event.getZ());
            }

            @Override
            public EntityZombie getZombieHelper() {
                EntityZombie helper = event.getCustomSummonedAid();
                if (helper == null) {
                    helper = new EntityZombie(event.getWorld());
                }
                return helper;
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    public Event.Result getResult() {
        return this.result;
    }

    public static SummonAidRule parse(JsonElement element) {
        if (element == null) {
            return null;
        }
        AttributeMap map = FACTORY.parse(element);
        return new SummonAidRule(map);
    }

    static {
        FACTORY.attribute(Attribute.create((Key)RuleKeys.MINTIME)).attribute(Attribute.create((Key)RuleKeys.MAXTIME)).attribute(Attribute.create(RuleKeys.MINCOUNT)).attribute(Attribute.create(RuleKeys.MAXCOUNT)).attribute(Attribute.create((Key)RuleKeys.MINLIGHT)).attribute(Attribute.create((Key)RuleKeys.MAXLIGHT)).attribute(Attribute.create((Key)RuleKeys.MINHEIGHT)).attribute(Attribute.create((Key)RuleKeys.MAXHEIGHT)).attribute(Attribute.create((Key)RuleKeys.MINDIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.MINSPAWNDIST)).attribute(Attribute.create((Key)RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create((Key)RuleKeys.RANDOM)).attribute(Attribute.create(RuleKeys.CANSPAWNHERE)).attribute(Attribute.create(RuleKeys.NOTCOLLIDING)).attribute(Attribute.create((Key)RuleKeys.INBUILDING)).attribute(Attribute.create((Key)RuleKeys.INCITY)).attribute(Attribute.create((Key)RuleKeys.INSTREET)).attribute(Attribute.create((Key)RuleKeys.INSPHERE)).attribute(Attribute.create(RuleKeys.PASSIVE)).attribute(Attribute.create(RuleKeys.HOSTILE)).attribute(Attribute.create((Key)RuleKeys.SEESKY)).attribute(Attribute.create((Key)RuleKeys.WEATHER)).attribute(Attribute.create((Key)RuleKeys.TEMPCATEGORY)).attribute(Attribute.create((Key)RuleKeys.DIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.STRUCTURE)).attribute(Attribute.create((Key)RuleKeys.WINTER)).attribute(Attribute.create((Key)RuleKeys.SUMMER)).attribute(Attribute.create((Key)RuleKeys.SPRING)).attribute(Attribute.create((Key)RuleKeys.AUTUMN)).attribute(Attribute.createMulti(RuleKeys.MOB)).attribute(Attribute.createMulti(RuleKeys.MOD)).attribute(Attribute.createMulti((Key)RuleKeys.BLOCK)).attribute(Attribute.create((Key)RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti((Key)RuleKeys.BIOME)).attribute(Attribute.createMulti((Key)RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti((Key)RuleKeys.DIMENSION)).attribute(Attribute.create((Key)RuleKeys.STATE)).attribute(Attribute.create((Key)RuleKeys.ACTION_RESULT)).attribute(Attribute.create((Key)RuleKeys.ACTION_MESSAGE)).attribute(Attribute.create((Key)RuleKeys.ACTION_HEALTHMULTIPLY)).attribute(Attribute.create((Key)RuleKeys.ACTION_HEALTHADD)).attribute(Attribute.create((Key)RuleKeys.ACTION_SPEEDMULTIPLY)).attribute(Attribute.create((Key)RuleKeys.ACTION_SPEEDADD)).attribute(Attribute.create((Key)RuleKeys.ACTION_DAMAGEMULTIPLY)).attribute(Attribute.create((Key)RuleKeys.ACTION_DAMAGEADD)).attribute(Attribute.create((Key)RuleKeys.ACTION_SIZEMULTIPLY)).attribute(Attribute.create((Key)RuleKeys.ACTION_SIZEADD)).attribute(Attribute.create((Key)RuleKeys.ACTION_ANGRY)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_HELDITEM)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_ARMORBOOTS)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_ARMORLEGS)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_ARMORCHEST)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_ARMORHELMET)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_POTION));
        rnd = new Random();
    }
}

