/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import java.util.function.Consumer;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.IModRuleCompatibilityLayer;
import mcjty.tools.rules.RuleBase;
import mcjty.tools.typed.Attribute;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.GenericAttributeMapFactory;
import mcjty.tools.typed.Key;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SpawnRule
extends RuleBase<RuleBase.EventGetter> {
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    public static final IEventQuery<LivingSpawnEvent.CheckSpawn> EVENT_QUERY = new IEventQuery<LivingSpawnEvent.CheckSpawn>(){

        public World getWorld(LivingSpawnEvent.CheckSpawn o) {
            return o.getWorld();
        }

        public BlockPos getPos(LivingSpawnEvent.CheckSpawn o) {
            return new BlockPos((double)o.getX(), (double)o.getY(), (double)o.getZ());
        }

        public BlockPos getValidBlockPos(LivingSpawnEvent.CheckSpawn o) {
            return new BlockPos((double)o.getX(), (double)(o.getY() - 1.0f), (double)o.getZ());
        }

        public int getY(LivingSpawnEvent.CheckSpawn o) {
            return (int)o.getY();
        }

        public Entity getEntity(LivingSpawnEvent.CheckSpawn o) {
            return o.getEntity();
        }

        public DamageSource getSource(LivingSpawnEvent.CheckSpawn o) {
            return null;
        }

        public Entity getAttacker(LivingSpawnEvent.CheckSpawn o) {
            return null;
        }

        public EntityPlayer getPlayer(LivingSpawnEvent.CheckSpawn o) {
            return null;
        }
    };
    public static final IEventQuery<EntityJoinWorldEvent> EVENT_QUERY_JOIN = new IEventQuery<EntityJoinWorldEvent>(){

        public World getWorld(EntityJoinWorldEvent o) {
            return o.getWorld();
        }

        public BlockPos getPos(EntityJoinWorldEvent o) {
            return o.getEntity().func_180425_c();
        }

        public BlockPos getValidBlockPos(EntityJoinWorldEvent o) {
            return o.getEntity().func_180425_c().func_177977_b();
        }

        public int getY(EntityJoinWorldEvent o) {
            return o.getEntity().func_180425_c().func_177956_o();
        }

        public Entity getEntity(EntityJoinWorldEvent o) {
            return o.getEntity();
        }

        public DamageSource getSource(EntityJoinWorldEvent o) {
            return null;
        }

        public Entity getAttacker(EntityJoinWorldEvent o) {
            return null;
        }

        public EntityPlayer getPlayer(EntityJoinWorldEvent o) {
            return null;
        }
    };
    private Event.Result result;
    private final boolean onJoin;
    private final GenericRuleEvaluator ruleEvaluator;

    private SpawnRule(AttributeMap map, boolean onJoin) {
        super(InControl.logger);
        this.onJoin = onJoin;
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        this.addActions(map, new ModRuleCompatibilityLayer());
    }

    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        String br;
        super.addActions(map, layer);
        this.result = map.has(RuleKeys.ACTION_RESULT) ? ("default".equals(br = (String)map.get(RuleKeys.ACTION_RESULT)) || br.startsWith("def") ? Event.Result.DEFAULT : ("allow".equals(br) || "true".equals(br) ? Event.Result.ALLOW : Event.Result.DENY)) : Event.Result.DEFAULT;
    }

    public boolean match(LivingSpawnEvent.CheckSpawn event) {
        return this.ruleEvaluator.match((Event)event, EVENT_QUERY);
    }

    public boolean match(EntityJoinWorldEvent event) {
        return this.ruleEvaluator.match((Event)event, EVENT_QUERY_JOIN);
    }

    public void action(final LivingSpawnEvent.CheckSpawn event) {
        RuleBase.EventGetter getter = new RuleBase.EventGetter(){

            public EntityLivingBase getEntityLiving() {
                return event.getEntityLiving();
            }

            public EntityPlayer getPlayer() {
                return null;
            }

            public World getWorld() {
                return event.getWorld();
            }

            public BlockPos getPosition() {
                return event.getEntityLiving().func_180425_c();
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    public void action(final EntityJoinWorldEvent event) {
        RuleBase.EventGetter getter = new RuleBase.EventGetter(){

            public EntityLivingBase getEntityLiving() {
                return event.getEntity() instanceof EntityLivingBase ? (EntityLivingBase)event.getEntity() : null;
            }

            public EntityPlayer getPlayer() {
                return null;
            }

            public World getWorld() {
                return event.getWorld();
            }

            public BlockPos getPosition() {
                return event.getEntity() != null ? event.getEntity().func_180425_c() : null;
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    public Event.Result getResult() {
        return this.result;
    }

    public boolean isOnJoin() {
        return this.onJoin;
    }

    public static SpawnRule parse(JsonElement element) {
        if (element == null) {
            return null;
        }
        AttributeMap map = FACTORY.parse(element);
        boolean onJoin = element.getAsJsonObject().has("onjoin") && element.getAsJsonObject().get("onjoin").getAsBoolean();
        return new SpawnRule(map, onJoin);
    }

    static {
        FACTORY.attribute(Attribute.create((Key)RuleKeys.MINTIME)).attribute(Attribute.create((Key)RuleKeys.MAXTIME)).attribute(Attribute.create(RuleKeys.MINCOUNT)).attribute(Attribute.create(RuleKeys.MAXCOUNT)).attribute(Attribute.create((Key)RuleKeys.MINLIGHT)).attribute(Attribute.create((Key)RuleKeys.MAXLIGHT)).attribute(Attribute.create((Key)RuleKeys.MINHEIGHT)).attribute(Attribute.create((Key)RuleKeys.MAXHEIGHT)).attribute(Attribute.create((Key)RuleKeys.MINDIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.MINSPAWNDIST)).attribute(Attribute.create((Key)RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create((Key)RuleKeys.RANDOM)).attribute(Attribute.create(RuleKeys.CANSPAWNHERE)).attribute(Attribute.create(RuleKeys.NOTCOLLIDING)).attribute(Attribute.create(RuleKeys.SPAWNER)).attribute(Attribute.create((Key)RuleKeys.INBUILDING)).attribute(Attribute.create((Key)RuleKeys.INCITY)).attribute(Attribute.create((Key)RuleKeys.INSTREET)).attribute(Attribute.create((Key)RuleKeys.INSPHERE)).attribute(Attribute.create(RuleKeys.PASSIVE)).attribute(Attribute.create(RuleKeys.HOSTILE)).attribute(Attribute.create((Key)RuleKeys.SEESKY)).attribute(Attribute.create((Key)RuleKeys.WEATHER)).attribute(Attribute.create((Key)RuleKeys.TEMPCATEGORY)).attribute(Attribute.create((Key)RuleKeys.DIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.STRUCTURE)).attribute(Attribute.create((Key)RuleKeys.WINTER)).attribute(Attribute.create((Key)RuleKeys.SUMMER)).attribute(Attribute.create((Key)RuleKeys.SPRING)).attribute(Attribute.create((Key)RuleKeys.AUTUMN)).attribute(Attribute.createMulti(RuleKeys.MOB)).attribute(Attribute.createMulti(RuleKeys.MOD)).attribute(Attribute.createMulti((Key)RuleKeys.BLOCK)).attribute(Attribute.create((Key)RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti((Key)RuleKeys.BIOME)).attribute(Attribute.createMulti((Key)RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti((Key)RuleKeys.DIMENSION)).attribute(Attribute.create((Key)RuleKeys.STATE)).attribute(Attribute.create((Key)RuleKeys.ACTION_RESULT)).attribute(Attribute.create((Key)RuleKeys.ACTION_MESSAGE)).attribute(Attribute.create((Key)RuleKeys.ACTION_HEALTHMULTIPLY)).attribute(Attribute.create((Key)RuleKeys.ACTION_HEALTHADD)).attribute(Attribute.create((Key)RuleKeys.ACTION_SPEEDMULTIPLY)).attribute(Attribute.create((Key)RuleKeys.ACTION_SPEEDADD)).attribute(Attribute.create((Key)RuleKeys.ACTION_DAMAGEMULTIPLY)).attribute(Attribute.create((Key)RuleKeys.ACTION_DAMAGEADD)).attribute(Attribute.create((Key)RuleKeys.ACTION_SIZEMULTIPLY)).attribute(Attribute.create((Key)RuleKeys.ACTION_SIZEADD)).attribute(Attribute.create((Key)RuleKeys.ACTION_ANGRY)).attribute(Attribute.create((Key)RuleKeys.ACTION_MOBNBT)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_HELDITEM)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_ARMORBOOTS)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_ARMORLEGS)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_ARMORCHEST)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_ARMORHELMET)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_POTION));
    }
}

