/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import mcjty.incontrol.InControl;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.RuleBase;
import mcjty.tools.typed.Attribute;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.GenericAttributeMapFactory;
import mcjty.tools.typed.Key;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.fixes.EntityId;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class PotentialSpawnRule
extends RuleBase<RuleBase.EventGetter> {
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    private static final GenericAttributeMapFactory MOB_FACTORY = new GenericAttributeMapFactory();
    public static final IEventQuery<WorldEvent.PotentialSpawns> EVENT_QUERY = new IEventQuery<WorldEvent.PotentialSpawns>(){

        public World getWorld(WorldEvent.PotentialSpawns o) {
            return o.getWorld();
        }

        public BlockPos getPos(WorldEvent.PotentialSpawns o) {
            return o.getPos();
        }

        public BlockPos getValidBlockPos(WorldEvent.PotentialSpawns o) {
            return o.getPos().func_177977_b();
        }

        public int getY(WorldEvent.PotentialSpawns o) {
            return o.getPos().func_177956_o();
        }

        public Entity getEntity(WorldEvent.PotentialSpawns o) {
            return null;
        }

        public DamageSource getSource(WorldEvent.PotentialSpawns o) {
            return null;
        }

        public Entity getAttacker(WorldEvent.PotentialSpawns o) {
            return null;
        }

        public EntityPlayer getPlayer(WorldEvent.PotentialSpawns o) {
            return null;
        }
    };
    private final GenericRuleEvaluator ruleEvaluator;
    private List<Biome.SpawnListEntry> spawnEntries = new ArrayList<Biome.SpawnListEntry>();
    private List<Class> toRemoveMobs = new ArrayList<Class>();
    public static final EntityId FIXER;

    private PotentialSpawnRule(AttributeMap map) {
        super(InControl.logger);
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        if (!map.has(RuleKeys.ACTION_MOBS) && !map.has(RuleKeys.ACTION_REMOVE)) {
            InControl.logger.log(Level.ERROR, "No 'mobs' or 'remove' specified!");
            return;
        }
        this.makeSpawnEntries(map);
        if (map.has(RuleKeys.ACTION_REMOVE)) {
            this.addToRemoveAction(map);
        }
    }

    public static String fixEntityId(String id) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("id", id);
        nbt = FIXER.func_188217_a(nbt);
        return nbt.func_74779_i("id");
    }

    private void addToRemoveAction(AttributeMap map) {
        List toremove = map.getList(RuleKeys.ACTION_REMOVE);
        for (String s : toremove) {
            Class clazz;
            String id = PotentialSpawnRule.fixEntityId(s);
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
            Class clazz2 = clazz = entry == null ? null : entry.getEntityClass();
            if (clazz == null) {
                InControl.logger.log(Level.ERROR, "Cannot find mob '" + s + "'!");
                return;
            }
            this.toRemoveMobs.add(clazz);
        }
    }

    private void makeSpawnEntries(AttributeMap map) {
        for (AttributeMap mobMap : map.getList(RuleKeys.ACTION_MOBS)) {
            Integer groupCountMax;
            Integer groupCountMin;
            Class clazz;
            String id = PotentialSpawnRule.fixEntityId((String)mobMap.get(RuleKeys.MOB_NAME));
            EntityEntry ee = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
            Class clazz2 = clazz = ee == null ? null : ee.getEntityClass();
            if (clazz == null) {
                InControl.logger.log(Level.ERROR, "Cannot find mob '" + (String)mobMap.get(RuleKeys.MOB_NAME) + "'!");
                return;
            }
            Integer weight = (Integer)mobMap.get(RuleKeys.MOB_WEIGHT);
            if (weight == null) {
                weight = 1;
            }
            if ((groupCountMin = (Integer)mobMap.get(RuleKeys.MOB_GROUPCOUNTMIN)) == null) {
                groupCountMin = 1;
            }
            if ((groupCountMax = (Integer)mobMap.get(RuleKeys.MOB_GROUPCOUNTMAX)) == null) {
                groupCountMax = Math.max(groupCountMin, 1);
            }
            Biome.SpawnListEntry entry = new Biome.SpawnListEntry(clazz, weight.intValue(), groupCountMin.intValue(), groupCountMax.intValue());
            this.spawnEntries.add(entry);
        }
    }

    public List<Biome.SpawnListEntry> getSpawnEntries() {
        return this.spawnEntries;
    }

    public boolean match(WorldEvent.PotentialSpawns event) {
        return this.ruleEvaluator.match((Event)event, EVENT_QUERY);
    }

    public List<Class> getToRemoveMobs() {
        return this.toRemoveMobs;
    }

    public static PotentialSpawnRule parse(JsonElement element) {
        if (element == null) {
            return null;
        }
        JsonObject jsonObject = element.getAsJsonObject();
        if (!jsonObject.has("mobs") && !jsonObject.has("remove")) {
            return null;
        }
        AttributeMap map = FACTORY.parse(element);
        if (jsonObject.has("mobs")) {
            JsonArray mobs = jsonObject.get("mobs").getAsJsonArray();
            for (JsonElement mob : mobs) {
                AttributeMap mobMap = MOB_FACTORY.parse(mob);
                map.addList(RuleKeys.ACTION_MOBS, (Object)mobMap);
            }
        }
        return new PotentialSpawnRule(map);
    }

    static {
        FACTORY.attribute(Attribute.create(RuleKeys.MINCOUNT)).attribute(Attribute.create(RuleKeys.MAXCOUNT)).attribute(Attribute.create((Key)RuleKeys.MINTIME)).attribute(Attribute.create((Key)RuleKeys.MAXTIME)).attribute(Attribute.create((Key)RuleKeys.MINLIGHT)).attribute(Attribute.create((Key)RuleKeys.MAXLIGHT)).attribute(Attribute.create((Key)RuleKeys.MINHEIGHT)).attribute(Attribute.create((Key)RuleKeys.MAXHEIGHT)).attribute(Attribute.create((Key)RuleKeys.MINDIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.MINSPAWNDIST)).attribute(Attribute.create((Key)RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create((Key)RuleKeys.RANDOM)).attribute(Attribute.create((Key)RuleKeys.SEESKY)).attribute(Attribute.create((Key)RuleKeys.WEATHER)).attribute(Attribute.create((Key)RuleKeys.TEMPCATEGORY)).attribute(Attribute.create((Key)RuleKeys.DIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.STRUCTURE)).attribute(Attribute.create((Key)RuleKeys.WINTER)).attribute(Attribute.create((Key)RuleKeys.SUMMER)).attribute(Attribute.create((Key)RuleKeys.SPRING)).attribute(Attribute.create((Key)RuleKeys.AUTUMN)).attribute(Attribute.create((Key)RuleKeys.STATE)).attribute(Attribute.createMulti((Key)RuleKeys.BLOCK)).attribute(Attribute.create((Key)RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti((Key)RuleKeys.BIOME)).attribute(Attribute.createMulti((Key)RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti((Key)RuleKeys.DIMENSION)).attribute(Attribute.createMulti(RuleKeys.ACTION_REMOVE));
        MOB_FACTORY.attribute(Attribute.create(RuleKeys.MOB_NAME)).attribute(Attribute.create(RuleKeys.MOB_WEIGHT)).attribute(Attribute.create(RuleKeys.MOB_GROUPCOUNTMIN)).attribute(Attribute.create(RuleKeys.MOB_GROUPCOUNTMAX));
        FIXER = new EntityId();
    }
}

