/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.IModRuleCompatibilityLayer;
import mcjty.tools.rules.RuleBase;
import mcjty.tools.typed.Attribute;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.GenericAttributeMapFactory;
import mcjty.tools.typed.Key;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ExperienceRule
extends RuleBase<RuleBase.EventGetter> {
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    public static final IEventQuery<LivingExperienceDropEvent> EVENT_QUERY = new IEventQuery<LivingExperienceDropEvent>(){

        public World getWorld(LivingExperienceDropEvent o) {
            return o.getEntity().func_130014_f_();
        }

        public BlockPos getPos(LivingExperienceDropEvent o) {
            return o.getEntity().func_180425_c();
        }

        public BlockPos getValidBlockPos(LivingExperienceDropEvent o) {
            return o.getEntity().func_180425_c().func_177977_b();
        }

        public int getY(LivingExperienceDropEvent o) {
            return o.getEntity().func_180425_c().func_177956_o();
        }

        public Entity getEntity(LivingExperienceDropEvent o) {
            return o.getEntity();
        }

        public DamageSource getSource(LivingExperienceDropEvent o) {
            return null;
        }

        public Entity getAttacker(LivingExperienceDropEvent o) {
            return o.getAttackingPlayer();
        }

        public EntityPlayer getPlayer(LivingExperienceDropEvent o) {
            return o.getAttackingPlayer();
        }
    };
    private final GenericRuleEvaluator ruleEvaluator;
    private Event.Result result;
    private Integer xp = null;
    private float multxp = 1.0f;
    private float addxp = 0.0f;

    private ExperienceRule(AttributeMap map) {
        super(InControl.logger);
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        this.addActions(map, new ModRuleCompatibilityLayer());
    }

    public int modifyXp(int xpIn) {
        if (this.xp != null) {
            xpIn = this.xp;
        }
        return (int)((float)xpIn * this.multxp + this.addxp);
    }

    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        String br;
        super.addActions(map, layer);
        this.result = map.has(RuleKeys.ACTION_RESULT) ? ("default".equals(br = (String)map.get(RuleKeys.ACTION_RESULT)) || br.startsWith("def") ? Event.Result.DEFAULT : ("allow".equals(br) || "true".equals(br) ? Event.Result.ALLOW : Event.Result.DENY)) : Event.Result.DEFAULT;
        if (map.has(RuleKeys.ACTION_SETXP)) {
            this.xp = (Integer)map.get(RuleKeys.ACTION_SETXP);
        }
        if (map.has(RuleKeys.ACTION_ADDXP)) {
            this.addxp = ((Float)map.get(RuleKeys.ACTION_ADDXP)).floatValue();
        }
        if (map.has(RuleKeys.ACTION_MULTXP)) {
            this.multxp = ((Float)map.get(RuleKeys.ACTION_MULTXP)).floatValue();
        }
    }

    public boolean match(LivingExperienceDropEvent event) {
        return this.ruleEvaluator.match((Event)event, EVENT_QUERY);
    }

    public Event.Result getResult() {
        return this.result;
    }

    public static ExperienceRule parse(JsonElement element) {
        if (element == null) {
            return null;
        }
        AttributeMap map = FACTORY.parse(element);
        return new ExperienceRule(map);
    }

    static {
        FACTORY.attribute(Attribute.create((Key)RuleKeys.MINTIME)).attribute(Attribute.create((Key)RuleKeys.MAXTIME)).attribute(Attribute.create((Key)RuleKeys.MINLIGHT)).attribute(Attribute.create((Key)RuleKeys.MAXLIGHT)).attribute(Attribute.create((Key)RuleKeys.MINHEIGHT)).attribute(Attribute.create((Key)RuleKeys.MAXHEIGHT)).attribute(Attribute.create((Key)RuleKeys.MINDIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.MINSPAWNDIST)).attribute(Attribute.create((Key)RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create((Key)RuleKeys.RANDOM)).attribute(Attribute.create((Key)RuleKeys.INBUILDING)).attribute(Attribute.create((Key)RuleKeys.INCITY)).attribute(Attribute.create((Key)RuleKeys.INSTREET)).attribute(Attribute.create((Key)RuleKeys.INSPHERE)).attribute(Attribute.create(RuleKeys.PASSIVE)).attribute(Attribute.create(RuleKeys.HOSTILE)).attribute(Attribute.create((Key)RuleKeys.SEESKY)).attribute(Attribute.create((Key)RuleKeys.WEATHER)).attribute(Attribute.create((Key)RuleKeys.TEMPCATEGORY)).attribute(Attribute.create((Key)RuleKeys.DIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.STRUCTURE)).attribute(Attribute.create(RuleKeys.PLAYER)).attribute(Attribute.create(RuleKeys.REALPLAYER)).attribute(Attribute.create(RuleKeys.FAKEPLAYER)).attribute(Attribute.create((Key)RuleKeys.WINTER)).attribute(Attribute.create((Key)RuleKeys.SUMMER)).attribute(Attribute.create((Key)RuleKeys.SPRING)).attribute(Attribute.create((Key)RuleKeys.AUTUMN)).attribute(Attribute.create((Key)RuleKeys.STATE)).attribute(Attribute.create((Key)RuleKeys.PSTATE)).attribute(Attribute.createMulti(RuleKeys.MOB)).attribute(Attribute.createMulti(RuleKeys.MOD)).attribute(Attribute.createMulti((Key)RuleKeys.BLOCK)).attribute(Attribute.create((Key)RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti((Key)RuleKeys.BIOME)).attribute(Attribute.createMulti((Key)RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti((Key)RuleKeys.DIMENSION)).attribute(Attribute.createMulti((Key)RuleKeys.HELDITEM)).attribute(Attribute.createMulti((Key)RuleKeys.OFFHANDITEM)).attribute(Attribute.createMulti((Key)RuleKeys.BOTHHANDSITEM)).attribute(Attribute.create((Key)RuleKeys.ACTION_RESULT)).attribute(Attribute.create(RuleKeys.ACTION_SETXP)).attribute(Attribute.create(RuleKeys.ACTION_ADDXP)).attribute(Attribute.create(RuleKeys.ACTION_MULTXP));
    }
}

