/*
 * Decompiled with CFR 0.152.
 */
package shadows.hitwithaxe;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.hitwithaxe.EnumBarkType;
import shadows.hitwithaxe.ItemBark;
import shadows.hitwithaxe.TransformRecipe;
import shadows.hitwithaxe.block.BlockDebarkedLog;
import shadows.hitwithaxe.compat.CompatBetweenlands;
import shadows.placebo.registry.RegistryInformation;
import shadows.placebo.registry.RegistryInformationV2;
import shadows.placebo.util.EnumBlockFactory;

@Mod(modid="hitwithaxe", name="Hit With Axe", version="1.4.0", dependencies="required-after:placebo@[1.4.1,);required-after:crafttweaker;after:thebetweenlands;after:plants2;after:thaumcraft;after:randomthings;after:traverse;after:integrateddynamics", acceptedMinecraftVersions="[1.12.2]")
public class HitWithAxe {
    public static final String MODID = "hitwithaxe";
    public static final String MODNAME = "Hit With Axe";
    public static final String VERSION = "1.4.0";
    public static final Logger LOG = LogManager.getLogger((String)"hitwithaxe");
    public static final List<TransformRecipe> RECIPES = new ArrayList<TransformRecipe>();
    public static final RegistryInformationV2 INFO = new RegistryInformationV2("hitwithaxe", CreativeTabs.field_78035_l);
    public static final Function<EnumBarkType, BlockDebarkedLog> DEFAULT_FUNC = e -> new BlockDebarkedLog((EnumBarkType)((Object)e));
    public static final String PLANTS = "plants2";
    public static final String BETWEENLANDS = "thebetweenlands";
    public static final String RUSTIC = "rustic";
    public static final String NATURA = "natura";
    public static final String NA = "naturesaura";
    public static final ItemBark BARK = new ItemBark("bark", EnumBarkType.values(), (RegistryInformation)INFO);
    public static final EnumBlockFactory<EnumBarkType, BlockDebarkedLog> DEBARKED_LOGS = new EnumBlockFactory(e -> Loader.isModLoaded((String)e.getReqMod()) ? e.createBlock() : null, (Enum[])EnumBarkType.values());
    public static int hungerCost = 1;
    public static int cooldown = 10;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Configuration cfg = new Configuration(e.getSuggestedConfigurationFile());
        hungerCost = cfg.getInt("Food Cost", "general", hungerCost, 0, 20, "How much hunger is used per swing.  This will consume saturation when possible.  1 = half shank.");
        cooldown = cfg.getInt("Swing Cooldown", "general", cooldown, 0, Integer.MAX_VALUE, "The cooldown after using an axe, in ticks");
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> e) {
        INFO.getBlockList().register(e.getRegistry());
        if (Loader.isModLoaded((String)EnumBarkType.CRYSTAL.getReqMod())) {
            ((BlockDebarkedLog)DEBARKED_LOGS.getBlock((Enum)EnumBarkType.CRYSTAL)).func_149672_a(SoundType.field_185853_f);
            ((BlockDebarkedLog)DEBARKED_LOGS.getBlock((Enum)EnumBarkType.DARK_CRYSTAL)).func_149672_a(SoundType.field_185853_f);
        }
        if (Loader.isModLoaded((String)BETWEENLANDS)) {
            CompatBetweenlands.replaceLog((IForgeRegistry<Block>)e.getRegistry());
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> e) {
        INFO.getItemList().register(e.getRegistry());
        OreDictionary.registerOre((String)"barkWood", (ItemStack)new ItemStack((Item)BARK, 1, Short.MAX_VALUE));
        for (EnumBarkType ebt : EnumBarkType.values()) {
            if (!Loader.isModLoaded((String)ebt.getReqMod())) continue;
            OreDictionary.registerOre((String)"logWood", (Block)DEBARKED_LOGS.getBlock((Enum)ebt));
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickBlock e) {
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = e.getItemStack();
        EntityPlayer player = e.getEntityPlayer();
        if (stack.func_77973_b().getToolClasses(stack).contains("axe") && HitWithAxe.hasFood(player) && player.func_184811_cZ().func_185143_a(stack.func_77973_b(), 0.0f) <= 0.0f) {
            for (TransformRecipe recipe : RECIPES) {
                if (!recipe.matches(state) || stack.func_77973_b().getHarvestLevel(stack, "axe", player, state) < recipe.getHarvestLevel()) continue;
                recipe.action(world, pos, state, player, e.getHand());
                break;
            }
        }
    }

    public static boolean hasFood(EntityPlayer player) {
        FoodStats stats = player.func_71024_bL();
        float combined = (float)stats.func_75116_a() + stats.func_75115_e();
        return combined >= (float)hungerCost;
    }

    public static void consumeFood(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        FoodStats stats = player.func_71024_bL();
        int food = stats.func_75116_a();
        float saturation = stats.func_75115_e();
        if (saturation >= (float)hungerCost) {
            stats.func_75122_a(-hungerCost, 1.0f);
            stats.func_75114_a(food);
        } else {
            stats.func_75114_a(food - hungerCost);
        }
    }
}

