/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.capability.item;

import com.teamacronymcoders.base.capability.QueueFoundation;
import com.teamacronymcoders.base.util.ItemStackUtils;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public class ItemStackQueue
extends QueueFoundation<ItemStack>
implements IItemHandler {
    public ItemStackQueue() {
        super(5);
    }

    @Override
    protected ItemStack addToBack(ItemStack value) {
        ItemStack remaining = value;
        if (this.getEndOfQueue().isPresent()) {
            remaining = ItemStackUtils.mergeStacks((ItemStack)this.getEndOfQueue().get(), value);
        }
        if (this.anyRemainingValue(remaining) && this.getLength() < this.getQueueSize()) {
            this.push(remaining);
            remaining = ItemStack.field_190927_a;
        }
        return remaining;
    }

    @Override
    protected boolean anyRemainingValue(ItemStack value) {
        return !value.func_190926_b();
    }

    @Override
    public NBTTagCompound serializeValue(ItemStack value) {
        return value.serializeNBT();
    }

    @Override
    public ItemStack deserializeValue(NBTTagCompound nbtTagCompound) {
        return new ItemStack(nbtTagCompound);
    }

    public int getSlots() {
        return 2;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        switch (slot) {
            case 0: {
                return this.peek().orElse(ItemStack.field_190927_a);
            }
            case 1: {
                return this.getEndOfQueue().orElse(ItemStack.field_190927_a);
            }
        }
        throw new RuntimeException("Slot " + slot + " not in valid range - [0,1]");
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot == 1) {
            if (simulate) {
                return this.getLength() < this.getQueueSize() ? ItemStack.field_190927_a : stack;
            }
            return this.offer(stack).func_77946_l();
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0) {
            if (simulate) {
                return this.peek().orElse(ItemStack.field_190927_a);
            }
            return this.pull().orElse(ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return this.getItemStack(slot).func_77976_d();
    }

    @Nonnull
    private ItemStack getItemStack(int slot) {
        if (slot < 0 || slot > 1) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0,1]");
        }
        return slot == 0 ? this.peek().orElse(ItemStack.field_190927_a) : this.getEndOfQueue().orElse(ItemStack.field_190927_a);
    }
}

