/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="enderio")
public class UpgradeRegistry {
    private static final Comparator<IDarkSteelUpgrade> darkSteelUpgradeComperator = new Comparator<IDarkSteelUpgrade>(){

        @Override
        public int compare(IDarkSteelUpgrade o1, IDarkSteelUpgrade o2) {
            return o1.getUnlocalizedName().compareTo(o2.getUnlocalizedName());
        }
    };
    private static IForgeRegistry<IDarkSteelUpgrade> REGISTRY = null;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerRegistry(@Nonnull RegistryEvent.NewRegistry event) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("enderio", "upgrades")).setType(IDarkSteelUpgrade.class).setIDRange(0, 0x7FFFFFFE).create();
    }

    @Nonnull
    public static NNList<IDarkSteelUpgrade> getUpgrades() {
        NNList list = new NNList(REGISTRY.getValuesCollection());
        list.sort(darkSteelUpgradeComperator);
        return list;
    }

    @Nullable
    public static IDarkSteelUpgrade getUpgrade(ResourceLocation id) {
        return (IDarkSteelUpgrade)REGISTRY.getValue(id);
    }
}

