/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.process;

import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.util.RequesterReference;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.FluidHelper;
import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class RequestFluid
extends Request<FluidStack> {
    public RequestFluid(RequesterReference<FluidStack> attachment) {
        super(attachment);
    }

    public RequestFluid(RequesterReference<FluidStack> attachment, FluidStack stack) {
        super(attachment, stack.copy());
    }

    private RequestFluid(RequesterReference<FluidStack> attachment, long id) {
        super(attachment, id);
    }

    public static NBTTagCompound writeNBT(Request<FluidStack> request) {
        NBTTagList stacks = new NBTTagList();
        for (Object stack : request.stacks) {
            stacks.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        NBTTagList blacklist = new NBTTagList();
        for (RequesterReference requesterReference : request.blacklist) {
            blacklist.func_74742_a((NBTBase)RequesterReference.writeNBT(requesterReference));
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("attachment", (NBTBase)RequesterReference.writeNBT(request.attachment));
        nbt.func_74782_a("stacks", (NBTBase)stacks);
        nbt.func_74782_a("blacklist", (NBTBase)blacklist);
        nbt.func_74772_a("id", request.id);
        return nbt;
    }

    public static RequestFluid readNBT(NBTTagCompound nbt) {
        RequestFluid request = new RequestFluid(RequesterReference.readNBT(nbt.func_74775_l("attachment")), (long)nbt.func_74762_e("id"));
        NBTTagList stacks = nbt.func_150295_c("stacks", 10);
        for (int i = 0; i < stacks.func_74745_c(); ++i) {
            request.stacks.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stacks.func_150305_b(i)));
        }
        NBTTagList blacklist = nbt.func_150295_c("blacklist", 10);
        for (int i = 0; i < blacklist.func_74745_c(); ++i) {
            request.blacklist.add(RequesterReference.readNBT(blacklist.func_150305_b(i)));
        }
        return request;
    }

    public static void writePacket(PacketBase packet, Request<FluidStack> request) {
        RequesterReference.writePacket(packet, request.attachment);
        packet.addLong(request.id);
        packet.addInt(request.stacks.size());
        for (FluidStack stack : request.stacks) {
            packet.addFluidStack(stack);
        }
    }

    public static RequestFluid readPacket(PacketBase packet) {
        RequestFluid request = new RequestFluid(RequesterReference.readPacket(packet), packet.getLong());
        int size = packet.getInt();
        for (int i = 0; i < size; ++i) {
            request.stacks.add(packet.getFluidStack());
        }
        return request;
    }

    @Override
    public void addStack(FluidStack stack) {
        if (stack == null) {
            return;
        }
        for (FluidStack s : this.stacks) {
            if (!FluidHelper.isFluidEqual((FluidStack)stack, (FluidStack)s)) continue;
            s.amount += stack.amount;
            return;
        }
        this.stacks.add(stack.copy());
    }

    @Override
    public void decreaseStack(FluidStack stack) {
        if (stack == null) {
            return;
        }
        Iterator iterator = this.stacks.iterator();
        while (iterator.hasNext()) {
            FluidStack s = (FluidStack)iterator.next();
            if (!FluidHelper.isFluidEqual((FluidStack)stack, (FluidStack)s)) continue;
            s.amount -= stack.amount;
            if (s.amount <= 0) {
                iterator.remove();
            }
            return;
        }
    }

    @Override
    public int getCount(FluidStack stack) {
        for (FluidStack item : this.stacks) {
            if (!FluidHelper.isFluidEqual((FluidStack)item, (FluidStack)stack)) continue;
            return item.amount;
        }
        return 0;
    }
}

