/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.client.gui.tab;

import astavie.thermallogistics.client.TLTextures;
import astavie.thermallogistics.client.gui.element.ElementSlotItem;
import astavie.thermallogistics.client.gui.element.ElementTextFieldAmount;
import astavie.thermallogistics.util.Shared;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButtonBase;
import cofh.core.gui.element.ElementButtonManaged;
import cofh.core.gui.element.ElementSimple;
import cofh.core.gui.element.ElementTextField;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.inventory.InventoryCraftingFalse;
import cofh.core.util.helpers.StringHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;

public class TabCrafting
extends TabBase {
    public final ElementSlotItem[] grid;
    public final ElementBase output;
    public final ElementTextField amount;
    public final ElementButtonBase button;
    private final Supplier<Boolean> enabled;

    public TabCrafting(GuiContainerCore gui, Shared.Item[] shared, Runnable click, Runnable request, Supplier<Boolean> enabled) {
        this(gui, 1, shared, click, request, enabled);
        this.maxWidth = 118;
        this.maxHeight = 100;
        this.headerColor = -13158601;
    }

    public TabCrafting(GuiContainerCore gui, int side, Shared.Item[] shared, final Runnable click, final Runnable request, Supplier<Boolean> enabled) {
        super(gui, side);
        this.enabled = enabled;
        int x = this.sideOffset() + 1;
        int y = 21;
        this.grid = new ElementSlotItem[9];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Shared.Item stack;
                if (shared[j + i * 3] == null) {
                    shared[j + i * 3] = stack = new Shared.Item(ItemStack.field_190927_a);
                }
                stack = shared[j + i * 3];
                ElementSlotItem elementSlotItem = new ElementSlotItem(gui, x + j * 18, y + i * 18, stack, stack, false);
                this.grid[j + i * 3] = elementSlotItem;
                this.addElement(elementSlotItem);
            }
        }
        this.addElement(new ElementSimple(gui, x + 54 + 6, y + 18 + 1).setTexture("cofh:textures/gui/elements/progress_arrow_right.png", 64, 16).setSize(24, 16));
        this.output = new ElementSlotItem(gui, x + 90, y + 18, () -> {
            InventoryCraftingFalse inventory = new InventoryCraftingFalse(3, 3);
            for (int i = 0; i < 9; ++i) {
                inventory.func_70299_a(i, (ItemStack)shared[i].get());
            }
            return CraftingManager.func_82787_a((InventoryCrafting)inventory, (World)Minecraft.func_71410_x().field_71441_e);
        }, null, true){

            @Override
            public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
                if (mouseButton != 2) {
                    click.run();
                }
                return true;
            }
        };
        this.addElement(this.output);
        this.button = new ElementButtonManaged(gui, x + 108 - 50, y + 54 + 2, 50, 16, StringHelper.localize((String)"gui.logistics.terminal.request")){

            public void onClick() {
                request.run();
            }
        };
        this.addElement((ElementBase)this.button);
        this.amount = new ElementTextFieldAmount(gui, x + 1, y + 54 + 5, 52, 10);
        this.addElement((ElementBase)this.amount);
    }

    public int posX() {
        return super.posX();
    }

    protected void drawForeground() {
        GlStateManager.func_179140_f();
        this.drawTabIcon(TLTextures.ICON_CRAFTING);
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().func_78276_b(this.getTitle(), this.sideOffset() + 18, 7, this.headerColor);
    }

    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(this.getTitle());
        } else {
            int mouseX = this.gui.getMouseX() - this.posX();
            int mouseY = this.gui.getMouseY() - this.posY;
            for (ElementSlotItem element : this.grid) {
                if (!element.intersectsWith(mouseX, mouseY)) continue;
                element.addTooltip(list);
            }
            if (this.output.intersectsWith(mouseX, mouseY)) {
                this.output.addTooltip(list);
            }
        }
    }

    public void update() {
        super.update();
        this.button.setEnabled(this.enabled.get().booleanValue());
    }

    private String getTitle() {
        return StringHelper.localize((String)"info.logistics.tab.crafting");
    }
}

