/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.attachment;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.client.TLTextures;
import astavie.thermallogistics.process.ProcessFluid;
import astavie.thermallogistics.process.Request;
import codechicken.lib.fluid.FluidUtils;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.thermaldynamics.duct.attachments.retriever.RetrieverFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.render.RenderDuct;
import cofh.thermaldynamics.util.ListWrapper;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;

public class RequesterFluid
extends RetrieverFluid
implements IRequester<FluidStack> {
    public static final ResourceLocation ID = new ResourceLocation("thermallogistics", "requester_fluid");
    private final ProcessFluid process = new ProcessFluid(this);

    public RequesterFluid(TileGrid tile, byte side) {
        super(tile, side);
    }

    public RequesterFluid(TileGrid tile, byte side, int type) {
        super(tile, side, type);
        this.filter.handleFlagByte(24);
    }

    public String getInfo() {
        return "tab.thermallogistics.requesterFluid";
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ItemStack getPickBlock() {
        return new ItemStack((Item)ThermalLogistics.Items.requester, 1, this.type);
    }

    public String getName() {
        return this.getPickBlock().func_77977_a() + ".name";
    }

    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccRenderState) {
        if (layer != BlockRenderLayer.SOLID) {
            return false;
        }
        Translation trans = Vector3.fromTileCenter((TileEntity)this.baseTile).translation();
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(ccRenderState, new IVertexOperation[]{trans, new IconTransformation(TLTextures.REQUESTER[this.stuffed ? 1 : 0][this.type])});
        return true;
    }

    @Override
    public void claim(ICrafter<FluidStack> crafter, FluidStack stack) {
        Iterator iterator = this.process.requests.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            if (!request.attachment.references(crafter)) continue;
            request.decreaseStack(stack);
            if (request.stacks.isEmpty()) {
                iterator.remove();
            }
            return;
        }
    }

    public void tick(int pass) {
        GridFluid grid = (GridFluid)this.fluidDuct.getGrid();
        if (pass != 1 || grid == null || !this.isPowered || !this.isValidInput) {
            return;
        }
        this.process.tick();
    }

    public void onNeighborChange() {
        boolean wasPowered = this.isPowered;
        super.onNeighborChange();
        if (wasPowered && !this.isPowered) {
            this.process.requests.clear();
        }
    }

    public void checkSignal() {
        boolean wasPowered = this.isPowered;
        super.checkSignal();
        if (wasPowered && !this.isPowered) {
            this.process.requests.clear();
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74782_a("process", (NBTBase)this.process.writeNbt());
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.process.readNbt(tag.func_150295_c("process", 10));
    }

    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        super.writePortableData(player, tag);
        tag.func_74778_a("DisplayType", new ItemStack((Item)ThermalLogistics.Items.requester).func_77977_a() + ".name");
    }

    @Override
    public List<FluidStack> getInputFrom(IRequester<FluidStack> requester) {
        return this.process.getStacks(requester);
    }

    @Override
    public List<FluidStack> getOutputTo(IRequester<FluidStack> requester) {
        return Collections.emptyList();
    }

    @Override
    public boolean isEnabled() {
        return this.isPowered;
    }

    @Override
    public int amountRequired(FluidStack stack) {
        DuctUnitFluid.Cache cache = ((DuctUnitFluid.Cache[])this.fluidDuct.tileCache)[this.side];
        if (cache == null) {
            return 0;
        }
        int required = cache.getHandler(this.side ^ 1).fill(FluidUtils.copy((FluidStack)stack, (int)Integer.MAX_VALUE), false);
        for (Request request : this.process.requests) {
            required -= request.getCount(stack);
        }
        return required;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public int getMaxSend() {
        return ServoItem.maxSize[this.type];
    }

    @Override
    public float getThrottle() {
        return throttle[this.type];
    }

    @Override
    public DuctUnit getDuct() {
        return this.fluidDuct;
    }

    @Override
    public TileEntity getTile() {
        return this.baseTile;
    }

    @Override
    public byte getSide() {
        return this.side;
    }

    @Override
    public byte getSpeed() {
        return 0;
    }

    @Override
    public ListWrapper<Route<DuctUnitItem, GridItem>> getRoutes() {
        return null;
    }

    @Override
    public boolean hasMultiStack() {
        return false;
    }

    @Override
    public TileEntity getCachedTile() {
        return this.myTile;
    }

    @Override
    public ItemStack getIcon() {
        return this.getPickBlock();
    }

    @Override
    public void onFinishCrafting(IRequester<FluidStack> requester, FluidStack stack) {
    }

    @Override
    public void onFinishCrafting(int index, int recipes) {
    }

    @Override
    public void markDirty() {
        this.baseTile.markChunkDirty();
    }

    @Override
    public int tickDelay() {
        return ServoItem.tickDelays[this.type];
    }
}

