/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import io.netty.buffer.ByteBuf;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketRemoveEntityEffect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.ARBShaderObjects;
import vazkii.botania.api.boss.IBotaniaBoss;
import vazkii.botania.api.internal.ShaderCallback;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.lexicon.multiblock.component.MultiblockComponent;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PylonVariant;
import vazkii.botania.client.core.handler.BossBarHandler;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.advancements.DopplegangerNoArmorTrigger;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityMagicLandmine;
import vazkii.botania.common.entity.EntityMagicMissile;
import vazkii.botania.common.entity.EntityPixie;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.LibEntityNames;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class EntityDoppleganger
extends EntityLiving
implements IBotaniaBoss,
IEntityAdditionalSpawnData {
    public static final float ARENA_RANGE = 12.0f;
    private static final int SPAWN_TICKS = 160;
    private static final float MAX_HP = 320.0f;
    private static final int MOB_SPAWN_START_TICKS = 20;
    private static final int MOB_SPAWN_END_TICKS = 80;
    private static final int MOB_SPAWN_BASE_TICKS = 800;
    private static final int MOB_SPAWN_TICKS = 900;
    private static final int MOB_SPAWN_WAVES = 10;
    private static final int MOB_SPAWN_WAVE_TIME = 80;
    private static final String TAG_INVUL_TIME = "invulTime";
    private static final String TAG_AGGRO = "aggro";
    private static final String TAG_SOURCE_X = "sourceX";
    private static final String TAG_SOURCE_Y = "sourceY";
    private static final String TAG_SOURCE_Z = "sourcesZ";
    private static final String TAG_MOB_SPAWN_TICKS = "mobSpawnTicks";
    private static final String TAG_HARD_MODE = "hardMode";
    private static final String TAG_PLAYER_COUNT = "playerCount";
    private static final DataParameter<Integer> INVUL_TIME = EntityDataManager.func_187226_a(EntityDoppleganger.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final BlockPos[] PYLON_LOCATIONS = new BlockPos[]{new BlockPos(4, 1, 4), new BlockPos(4, 1, -4), new BlockPos(-4, 1, 4), new BlockPos(-4, 1, -4)};
    private static final List<ResourceLocation> CHEATY_BLOCKS = Arrays.asList(new ResourceLocation("openblocks", "beartrap"), new ResourceLocation("thaumictinkerer", "magnet"));
    private boolean spawnLandmines = false;
    private boolean spawnPixies = false;
    private boolean anyWithArmor = false;
    private boolean aggro = false;
    private int tpDelay = 0;
    private int mobSpawnTicks = 0;
    private int playerCount = 0;
    private boolean hardMode = false;
    private BlockPos source = BlockPos.field_177992_a;
    private final List<UUID> playersWhoAttacked = new ArrayList<UUID>();
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer((ITextComponent)new TextComponentTranslation("entity." + LibEntityNames.DOPPLEGANGER_REGISTRY + ".name", new Object[0]), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).func_186743_c(true);
    private UUID bossInfoUUID = this.bossInfo.func_186737_d();
    public EntityPlayer trueKiller = null;
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*\\])|(?:ComputerCraft)$");
    @SideOnly(value=Side.CLIENT)
    private static Rectangle barRect;
    @SideOnly(value=Side.CLIENT)
    private static Rectangle hpBarRect;
    @SideOnly(value=Side.CLIENT)
    private ShaderCallback shaderCallback;

    public EntityDoppleganger(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70178_ae = true;
        this.field_70728_aV = 825;
        if (world.field_72995_K) {
            Botania.proxy.addBoss(this);
        }
    }

    public static MultiblockSet makeMultiblockSet() {
        Multiblock mb = new Multiblock();
        for (BlockPos p : PYLON_LOCATIONS) {
            mb.addComponent(p.func_177984_a(), ModBlocks.pylon.func_176223_P().func_177226_a(BotaniaStateProps.PYLON_VARIANT, (Comparable)((Object)PylonVariant.GAIA)));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                mb.addComponent(new BeaconComponent(new BlockPos(i - 1, 0, j - 1)));
            }
        }
        mb.addComponent(new BeaconBeamComponent(new BlockPos(0, 1, 0)));
        mb.setRenderOffset(new BlockPos(0, -1, 0));
        return mb.makeSet();
    }

    public static boolean spawn(EntityPlayer player, ItemStack stack, World world, BlockPos pos, boolean hard) {
        if (world.func_175625_s(pos) instanceof TileEntityBeacon && EntityDoppleganger.isTruePlayer((Entity)player)) {
            int playerCount;
            if (world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                if (!world.field_72995_K) {
                    player.func_145747_a(new TextComponentTranslation("botaniamisc.peacefulNoob", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
                return false;
            }
            for (BlockPos coords : PYLON_LOCATIONS) {
                BlockPos pos_ = pos.func_177971_a((Vec3i)coords);
                IBlockState state = world.func_180495_p(pos_);
                Block blockat = state.func_177230_c();
                if (blockat == ModBlocks.pylon && state.func_177229_b(BotaniaStateProps.PYLON_VARIANT) == PylonVariant.GAIA) continue;
                if (!world.field_72995_K) {
                    player.func_145747_a(new TextComponentTranslation("botaniamisc.needsCatalysts", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
                return false;
            }
            if (!EntityDoppleganger.hasProperArena(world, pos)) {
                if (!world.field_72995_K) {
                    PacketHandler.sendTo((EntityPlayerMP)player, new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.ARENA_INDICATOR, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), new int[0]));
                    player.func_145747_a(new TextComponentTranslation("botaniamisc.badArena", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
                return false;
            }
            int guardians = EntityDoppleganger.getGaiaGuardiansAround(world, pos);
            if (guardians > 0) {
                return false;
            }
            if (world.field_72995_K) {
                return true;
            }
            stack.func_190918_g(1);
            EntityDoppleganger e = new EntityDoppleganger(world);
            e.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 3, (double)pos.func_177952_p() + 0.5);
            e.setInvulTime(160);
            e.func_70606_j(1.0f);
            e.source = pos;
            e.mobSpawnTicks = 900;
            e.hardMode = hard;
            e.playerCount = playerCount = (int)e.getPlayersAround().stream().filter(EntityDoppleganger::isTruePlayer).count();
            e.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(320.0f * (float)playerCount));
            if (hard) {
                e.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188791_g).func_111128_a(15.0);
            }
            e.func_184185_a(SoundEvents.field_187525_aO, 10.0f, 0.1f);
            e.func_180482_a(world.func_175649_E(new BlockPos((Entity)e)), null);
            world.func_72838_d((Entity)e);
            return true;
        }
        return false;
    }

    private static boolean hasProperArena(World world, BlockPos startPos) {
        ArrayList<BlockPos> trippedPositions = new ArrayList<BlockPos>();
        boolean tripped = false;
        int heightCheck = 3;
        int heightMin = 2;
        int range = (int)Math.ceil(12.0);
        for (int i = -range; i < range + 1; ++i) {
            block1: for (int j = -range; j < range + 1; ++j) {
                if (Math.abs(i) == 4 && Math.abs(j) == 4 || MathHelper.pointDistancePlane(i, j, 0.0, 0.0) > 12.0f) continue;
                int air = 0;
                BlockPos pos = null;
                int trippedColumn = 0;
                for (int k = heightCheck + heightMin; k >= -heightCheck; --k) {
                    boolean isAir;
                    pos = startPos.func_177982_a(i, k, j);
                    boolean bl = isAir = world.func_180495_p(pos).func_185890_d((IBlockAccess)world, pos) == null;
                    if (isAir) {
                        ++air;
                        continue;
                    }
                    if (air >= 2) continue block1;
                    if (trippedColumn < 2) {
                        trippedPositions.add(pos);
                        ++trippedColumn;
                    }
                    air = 0;
                }
                if (trippedColumn == 0) {
                    trippedPositions.add(pos);
                }
                tripped = true;
            }
        }
        if (tripped) {
            Botania.proxy.setWispFXDepthTest(false);
            for (BlockPos pos : trippedPositions) {
                Botania.proxy.wispFX((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1.0f, 0.2f, 0.2f, 0.5f, 0.0f, 8.0f);
            }
            Botania.proxy.setWispFXDepthTest(true);
            return false;
        }
        return true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 18.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INVUL_TIME, (Object)0);
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVUL_TIME);
    }

    public BlockPos getSource() {
        return this.source;
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVUL_TIME, (Object)time);
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a(TAG_INVUL_TIME, this.getInvulTime());
        par1nbtTagCompound.func_74757_a(TAG_AGGRO, this.aggro);
        par1nbtTagCompound.func_74768_a(TAG_MOB_SPAWN_TICKS, this.mobSpawnTicks);
        par1nbtTagCompound.func_74768_a(TAG_SOURCE_X, this.source.func_177958_n());
        par1nbtTagCompound.func_74768_a(TAG_SOURCE_Y, this.source.func_177956_o());
        par1nbtTagCompound.func_74768_a(TAG_SOURCE_Z, this.source.func_177952_p());
        par1nbtTagCompound.func_74757_a(TAG_HARD_MODE, this.hardMode);
        par1nbtTagCompound.func_74768_a(TAG_PLAYER_COUNT, this.playerCount);
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.setInvulTime(par1nbtTagCompound.func_74762_e(TAG_INVUL_TIME));
        this.aggro = par1nbtTagCompound.func_74767_n(TAG_AGGRO);
        this.mobSpawnTicks = par1nbtTagCompound.func_74762_e(TAG_MOB_SPAWN_TICKS);
        int x = par1nbtTagCompound.func_74762_e(TAG_SOURCE_X);
        int y = par1nbtTagCompound.func_74762_e(TAG_SOURCE_Y);
        int z = par1nbtTagCompound.func_74762_e(TAG_SOURCE_Z);
        this.source = new BlockPos(x, y, z);
        this.hardMode = par1nbtTagCompound.func_74767_n(TAG_HARD_MODE);
        this.playerCount = par1nbtTagCompound.func_74764_b(TAG_PLAYER_COUNT) ? par1nbtTagCompound.func_74762_e(TAG_PLAYER_COUNT) : 1;
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(@Nonnull String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_70691_i(float amount) {
        if (this.getInvulTime() == 0) {
            super.func_70691_i(amount);
        }
    }

    public void func_174812_G() {
        this.func_70606_j(0.0f);
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float par2) {
        Entity e = source.func_76346_g();
        if (e instanceof EntityPlayer && EntityDoppleganger.isTruePlayer(e) && this.getInvulTime() == 0) {
            EntityPlayer player = (EntityPlayer)e;
            if (!this.playersWhoAttacked.contains(player.func_110124_au())) {
                this.playersWhoAttacked.add(player.func_110124_au());
            }
            int cap = 25;
            return super.func_70097_a(source, Math.min((float)cap, par2));
        }
        return false;
    }

    public static boolean isTruePlayer(Entity e) {
        if (!(e instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)e;
        String name = player.func_70005_c_();
        return !(player instanceof FakePlayer) && !FAKE_PLAYER_PATTERN.matcher(name).matches();
    }

    protected void func_70665_d(@Nonnull DamageSource par1DamageSource, float par2) {
        super.func_70665_d(par1DamageSource, par2);
        Entity attacker = par1DamageSource.func_76364_f();
        if (attacker != null) {
            Vector3 thisVector = Vector3.fromEntityCenter((Entity)this);
            Vector3 playerVector = Vector3.fromEntityCenter(attacker);
            Vector3 motionVector = thisVector.subtract(playerVector).normalize().multiply(0.75);
            if (this.func_110143_aJ() > 0.0f) {
                this.field_70159_w = -motionVector.x;
                this.field_70181_x = 0.5;
                this.field_70179_y = -motionVector.z;
                this.tpDelay = 4;
                this.spawnPixies = this.aggro;
            }
            this.aggro = true;
        }
    }

    public void func_70645_a(@Nonnull DamageSource source) {
        super.func_70645_a(source);
        EntityLivingBase entitylivingbase = this.func_94060_bK();
        if (entitylivingbase instanceof EntityPlayerMP && !this.anyWithArmor) {
            DopplegangerNoArmorTrigger.INSTANCE.trigger((EntityPlayerMP)entitylivingbase, this, source);
        }
        this.func_184185_a(SoundEvents.field_187539_bB, 20.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(320.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public ResourceLocation func_184647_J() {
        return new ResourceLocation("botania", this.hardMode ? "gaia_guardian_2" : "gaia_guardian");
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        if (wasRecentlyHit && source.func_76346_g() instanceof EntityPlayer) {
            this.trueKiller = (EntityPlayer)source.func_76346_g();
        }
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        for (EntityEquipmentSlot e : EntityEquipmentSlot.values()) {
            this.func_184201_a(e, ItemStack.field_190927_a);
        }
        for (UUID u : this.playersWhoAttacked) {
            EntityPlayer player = this.field_70170_p.func_152378_a(u);
            if (player == null) continue;
            EntityPlayer saveLastAttacker = this.field_70717_bb;
            double savePosX = this.field_70165_t;
            double savePosY = this.field_70163_u;
            double savePosZ = this.field_70161_v;
            this.field_70717_bb = player;
            this.field_70165_t = player.field_70165_t;
            this.field_70163_u = player.field_70163_u;
            this.field_70161_v = player.field_70161_v;
            super.func_184610_a(wasRecentlyHit, lootingModifier, DamageSource.func_76365_a((EntityPlayer)player));
            this.field_70165_t = savePosX;
            this.field_70163_u = savePosY;
            this.field_70161_v = savePosZ;
            this.field_70717_bb = saveLastAttacker;
        }
        this.trueKiller = null;
    }

    public void func_70106_y() {
        if (this.field_70170_p.field_72995_K) {
            Botania.proxy.removeBoss(this);
        }
        super.func_70106_y();
    }

    private List<EntityPlayer> getPlayersAround() {
        float range = 15.0f;
        return this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.source.func_177958_n() + 0.5 - (double)range, (double)this.source.func_177956_o() + 0.5 - (double)range, (double)this.source.func_177952_p() + 0.5 - (double)range, (double)this.source.func_177958_n() + 0.5 + (double)range, (double)this.source.func_177956_o() + 0.5 + (double)range, (double)this.source.func_177952_p() + 0.5 + (double)range));
    }

    private static int getGaiaGuardiansAround(World world, BlockPos source) {
        float range = 15.0f;
        List l = world.func_72872_a(EntityDoppleganger.class, new AxisAlignedBB((double)source.func_177958_n() + 0.5 - (double)range, (double)source.func_177956_o() + 0.5 - (double)range, (double)source.func_177952_p() + 0.5 - (double)range, (double)source.func_177958_n() + 0.5 + (double)range, (double)source.func_177956_o() + 0.5 + (double)range, (double)source.func_177952_p() + 0.5 + (double)range));
        return l.size();
    }

    private void particles() {
        for (int i = 0; i < 360; i += 8) {
            float r = 0.6f;
            float g = 0.0f;
            float b = 0.2f;
            float m = 0.15f;
            float mv = 0.35f;
            float rad = (float)i * (float)Math.PI / 180.0f;
            double x = (double)this.source.func_177958_n() + 0.5 - Math.cos(rad) * 12.0;
            double y = (double)this.source.func_177956_o() + 0.5;
            double z = (double)this.source.func_177952_p() + 0.5 - Math.sin(rad) * 12.0;
            Botania.proxy.wispFX(x, y, z, r, g, b, 0.5f, (float)(Math.random() - 0.5) * m, (float)(Math.random() - 0.5) * mv, (float)(Math.random() - 0.5) * m);
        }
        if (this.getInvulTime() > 10) {
            Vector3 pos = Vector3.fromEntityCenter((Entity)this).subtract(new Vector3(0.0, 0.2, 0.0));
            for (BlockPos arr : PYLON_LOCATIONS) {
                Vector3 pylonPos = new Vector3(this.source.func_177958_n() + arr.func_177958_n(), this.source.func_177956_o() + arr.func_177956_o(), this.source.func_177952_p() + arr.func_177952_p());
                double worldTime = this.field_70173_aa;
                float rad = 0.75f + (float)Math.random() * 0.05f;
                double xp = pylonPos.x + 0.5 + Math.cos(worldTime /= 5.0) * (double)rad;
                double zp = pylonPos.z + 0.5 + Math.sin(worldTime) * (double)rad;
                Vector3 partPos = new Vector3(xp, pylonPos.y, zp);
                Vector3 mot = pos.subtract(partPos).multiply(0.04);
                float r = 0.7f + (float)Math.random() * 0.3f;
                float g = (float)Math.random() * 0.3f;
                float b = 0.7f + (float)Math.random() * 0.3f;
                Botania.proxy.wispFX(partPos.x, partPos.y, partPos.z, r, g, b, 0.25f + (float)Math.random() * 0.1f, -0.075f - (float)Math.random() * 0.015f);
                Botania.proxy.wispFX(partPos.x, partPos.y, partPos.z, r, g, b, 0.4f, (float)mot.x, (float)mot.y, (float)mot.z);
            }
        }
    }

    private void smashCheatyBlocks() {
        int radius = 1;
        int posXInt = net.minecraft.util.math.MathHelper.func_76128_c((double)this.field_70165_t);
        int posYInt = net.minecraft.util.math.MathHelper.func_76128_c((double)this.field_70163_u);
        int posZInt = net.minecraft.util.math.MathHelper.func_76128_c((double)this.field_70161_v);
        for (int i = -radius; i < radius + 1; ++i) {
            for (int j = -radius; j < radius + 1; ++j) {
                for (int k = -radius; k < radius + 1; ++k) {
                    int xp = posXInt + i;
                    int yp = posYInt + j;
                    int zp = posZInt + k;
                    BlockPos posp = new BlockPos(xp, yp, zp);
                    if (!EntityDoppleganger.isCheatyBlock(this.field_70170_p, posp)) continue;
                    this.field_70170_p.func_175655_b(posp, true);
                }
            }
        }
    }

    private void clearPotions(EntityPlayer player) {
        int posXInt = net.minecraft.util.math.MathHelper.func_76128_c((double)this.field_70165_t);
        int posZInt = net.minecraft.util.math.MathHelper.func_76128_c((double)this.field_70161_v);
        List<Potion> potionsToRemove = player.func_70651_bq().stream().filter(effect -> effect.func_76459_b() < 160 && effect.func_82720_e() && !effect.func_188419_a().func_76398_f()).map(PotionEffect::func_188419_a).distinct().collect(Collectors.toList());
        potionsToRemove.forEach(potion -> {
            player.func_184589_d(potion);
            ((WorldServer)this.field_70170_p).func_184164_w().func_187301_b(posXInt >> 4, posZInt >> 4).func_187267_a((Packet)new SPacketRemoveEntityEffect(player.func_145782_y(), potion));
        });
    }

    private void keepInsideArena(EntityPlayer player) {
        if (MathHelper.pointDistanceSpace(player.field_70165_t, player.field_70163_u, player.field_70161_v, (double)this.source.func_177958_n() + 0.5, (double)this.source.func_177956_o() + 0.5, (double)this.source.func_177952_p() + 0.5) >= 12.0f) {
            Vector3 sourceVector = new Vector3((double)this.source.func_177958_n() + 0.5, (double)this.source.func_177956_o() + 0.5, (double)this.source.func_177952_p() + 0.5);
            Vector3 playerVector = Vector3.fromEntityCenter((Entity)player);
            Vector3 motion = sourceVector.subtract(playerVector).normalize();
            player.field_70159_w = motion.x;
            player.field_70181_x = 0.2;
            player.field_70179_y = motion.z;
            player.field_70133_I = true;
        }
    }

    private void spawnMobs(List<EntityPlayer> players) {
        for (int pl = 0; pl < this.playerCount; ++pl) {
            for (int i = 0; i < 3 + this.field_70170_p.field_73012_v.nextInt(2); ++i) {
                EntityZombie entity = null;
                switch (this.field_70170_p.field_73012_v.nextInt(2)) {
                    case 0: {
                        entity = new EntityZombie(this.field_70170_p);
                        if (this.field_70170_p.field_73012_v.nextInt(this.hardMode ? 3 : 12) != 0) break;
                        entity = new EntityWitch(this.field_70170_p);
                        break;
                    }
                    case 1: {
                        entity = new EntitySkeleton(this.field_70170_p);
                        if (this.field_70170_p.field_73012_v.nextInt(8) != 0) break;
                        entity = new EntityWitherSkeleton(this.field_70170_p);
                        break;
                    }
                    case 3: {
                        if (players.isEmpty()) break;
                        for (int j = 0; j < 1 + this.field_70170_p.field_73012_v.nextInt(this.hardMode ? 8 : 5); ++j) {
                            EntityPixie pixie = new EntityPixie(this.field_70170_p);
                            pixie.setProps((EntityLivingBase)players.get(this.field_70146_Z.nextInt(players.size())), (EntityLivingBase)this, 1, 8.0f);
                            pixie.func_70107_b(this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + 2.0, this.field_70161_v + (double)(this.field_70130_N / 2.0f));
                            pixie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)pixie)), null);
                            this.field_70170_p.func_72838_d((Entity)pixie);
                        }
                        break;
                    }
                }
                if (entity == null) continue;
                if (!entity.func_70045_F()) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 600, 0));
                }
                float range = 6.0f;
                entity.func_70107_b(this.field_70165_t + 0.5 + Math.random() * (double)range - (double)(range / 2.0f), this.field_70163_u - 1.0, this.field_70161_v + 0.5 + Math.random() * (double)range - (double)(range / 2.0f));
                entity.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), null);
                if (entity instanceof EntityWitherSkeleton && this.hardMode) {
                    entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.elementiumSword));
                }
                this.field_70170_p.func_72838_d((Entity)entity);
            }
        }
    }

    public void func_70636_d() {
        boolean spawnMissiles;
        super.func_70636_d();
        int invul = this.getInvulTime();
        if (this.field_70170_p.field_72995_K) {
            this.particles();
            EntityPlayer player = Botania.proxy.getClientPlayer();
            if (this.getPlayersAround().contains(player)) {
                player.field_71075_bZ.field_75100_b = player.field_71075_bZ.field_75100_b && player.field_71075_bZ.field_75098_d;
            }
            return;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (!this.func_184188_bt().isEmpty()) {
            this.func_184210_p();
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        this.smashCheatyBlocks();
        List<EntityPlayer> players = this.getPlayersAround();
        if (players.isEmpty() && !this.field_70170_p.field_73010_i.isEmpty()) {
            this.func_70106_y();
        } else {
            for (EntityPlayer player : players) {
                for (EntityEquipmentSlot e : EntityEquipmentSlot.values()) {
                    if (e.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || player.func_184582_a(e).func_190926_b()) continue;
                    this.anyWithArmor = true;
                    break;
                }
                this.clearPotions(player);
                this.keepInsideArena(player);
                player.field_71075_bZ.field_75100_b = player.field_71075_bZ.field_75100_b && player.field_71075_bZ.field_75098_d;
            }
        }
        if (this.field_70128_L) {
            return;
        }
        boolean bl = spawnMissiles = this.hardMode && this.field_70173_aa % 15 < 4;
        if (invul > 0 && this.mobSpawnTicks == 900) {
            if (invul < 160 && invul > 80 && this.field_70170_p.field_73012_v.nextInt(160 - invul + 1) == 0) {
                for (int i = 0; i < 2; ++i) {
                    this.func_70656_aK();
                }
            }
            this.func_70606_j(this.func_110143_aJ() + (this.func_110138_aP() - 1.0f) / 160.0f);
            this.setInvulTime(invul - 1);
            this.field_70181_x = 0.0;
        } else if (this.aggro) {
            boolean dying;
            boolean bl2 = dying = (double)(this.func_110143_aJ() / this.func_110138_aP()) < 0.2;
            if (dying && this.mobSpawnTicks > 0) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                int reverseTicks = 900 - this.mobSpawnTicks;
                if (reverseTicks < 20) {
                    this.field_70181_x = 0.2;
                    this.setInvulTime(invul + 1);
                }
                if (reverseTicks > 40 && this.mobSpawnTicks > 80 && this.mobSpawnTicks % 80 == 0) {
                    this.spawnMobs(players);
                    if (this.hardMode && this.field_70173_aa % 3 < 2) {
                        for (int i = 0; i < this.playerCount; ++i) {
                            this.spawnMissile();
                        }
                        spawnMissiles = false;
                    }
                }
                --this.mobSpawnTicks;
                this.tpDelay = 10;
            } else if (this.tpDelay > 0) {
                if (invul > 0) {
                    this.setInvulTime(invul - 1);
                }
                --this.tpDelay;
                if (this.tpDelay == 0 && this.func_110143_aJ() > 0.0f) {
                    int i;
                    int tries;
                    for (tries = 0; !this.teleportRandomly() && tries < 50; ++tries) {
                    }
                    if (tries >= 50) {
                        this.teleportTo((double)this.source.func_177958_n() + 0.5, (double)this.source.func_177956_o() + 1.6, (double)this.source.func_177952_p() + 0.5);
                    }
                    if (this.spawnLandmines) {
                        int count = dying && this.hardMode ? 7 : 6;
                        for (i = 0; i < count; ++i) {
                            int x = this.source.func_177958_n() - 10 + this.field_70146_Z.nextInt(20);
                            int z = this.source.func_177952_p() - 10 + this.field_70146_Z.nextInt(20);
                            int y = this.field_70170_p.func_175672_r(new BlockPos(x, -1, z)).func_177956_o();
                            EntityMagicLandmine landmine = new EntityMagicLandmine(this.field_70170_p);
                            landmine.func_70107_b((double)x + 0.5, y, (double)z + 0.5);
                            landmine.summoner = this;
                            this.field_70170_p.func_72838_d((Entity)landmine);
                        }
                    }
                    if (!players.isEmpty()) {
                        for (int pl = 0; pl < this.playerCount; ++pl) {
                            for (i = 0; i < (this.spawnPixies ? this.field_70170_p.field_73012_v.nextInt(this.hardMode ? 6 : 3) : 1); ++i) {
                                EntityPixie pixie = new EntityPixie(this.field_70170_p);
                                pixie.setProps((EntityLivingBase)players.get(this.field_70146_Z.nextInt(players.size())), (EntityLivingBase)this, 1, 8.0f);
                                pixie.func_70107_b(this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + 2.0, this.field_70161_v + (double)(this.field_70130_N / 2.0f));
                                pixie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)pixie)), null);
                                this.field_70170_p.func_72838_d((Entity)pixie);
                            }
                        }
                    }
                    this.tpDelay = this.hardMode ? (dying ? 35 : 45) : (dying ? 40 : 60);
                    this.spawnLandmines = true;
                    this.spawnPixies = false;
                }
            }
            if (spawnMissiles) {
                this.spawnMissile();
            }
        } else if (!players.isEmpty()) {
            this.func_70665_d(DamageSource.func_76365_a((EntityPlayer)players.get(0)), 0.0f);
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected void func_85033_bc() {
        if (this.getInvulTime() == 0) {
            super.func_85033_bc();
        }
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && this.getInvulTime() == 0;
    }

    private void spawnMissile() {
        EntityMagicMissile missile = new EntityMagicMissile((EntityLivingBase)this, true);
        missile.func_70107_b(this.field_70165_t + (Math.random() - 0.05), this.field_70163_u + 2.4 + (Math.random() - 0.05), this.field_70161_v + (Math.random() - 0.05));
        if (missile.findTarget()) {
            this.func_184185_a(ModSounds.missile, 0.6f, 0.8f + (float)Math.random() * 0.2f);
            this.field_70170_p.func_72838_d((Entity)missile);
        }
    }

    private static boolean isCheatyBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return CHEATY_BLOCKS.contains(Block.field_149771_c.func_177774_c((Object)block));
    }

    private boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    private boolean teleportTo(double x, double y, double z) {
        boolean flag = this.func_184595_k(x, y, z);
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    public boolean func_184595_k(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (world.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
                if (MathHelper.pointDistanceSpace(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.source.func_177958_n(), this.source.func_177956_o(), this.source.func_177952_p()) > 12.0f) {
                    flag = false;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        int i = 128;
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.field_70131_O;
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        Vec3d origPos = new Vec3d(d0, d1 + (double)(this.field_70131_O / 2.0f), d2);
        Vec3d newPos = new Vec3d(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v);
        if (origPos.func_72436_e(newPos) > 1.0) {
            for (EntityPlayer player : this.getPlayersAround()) {
                RayTraceResult rtr = player.func_174813_aQ().func_186662_g(0.25).func_72327_a(origPos, newPos);
                if (rtr == null) continue;
                player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 6.0f);
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBossBarTexture() {
        return BossBarHandler.defaultBossBar;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Rectangle getBossBarTextureRect() {
        if (barRect == null) {
            barRect = new Rectangle(0, 0, 185, 15);
        }
        return barRect;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Rectangle getBossBarHPTextureRect() {
        if (hpBarRect == null) {
            hpBarRect = new Rectangle(0, EntityDoppleganger.barRect.y + EntityDoppleganger.barRect.height, 181, 7);
        }
        return hpBarRect;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int bossBarRenderCallback(ScaledResolution res, int x, int y) {
        GlStateManager.func_179094_E();
        int px = x + 160;
        int py = y + 12;
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = new ItemStack(Items.field_151144_bL, 1, 3);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        mc.func_175599_af().func_175042_a(stack, px, py);
        RenderHelper.func_74518_a();
        boolean unicode = mc.field_71466_p.func_82883_a();
        mc.field_71466_p.func_78264_a(true);
        mc.field_71466_p.func_175063_a("" + this.playerCount, (float)(px + 15), (float)(py + 4), 0xFFFFFF);
        mc.field_71466_p.func_78264_a(unicode);
        GlStateManager.func_179121_F();
        return 5;
    }

    @Override
    public UUID getBossInfoUuid() {
        return this.bossInfoUUID;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getBossBarShaderProgram(boolean background) {
        return background ? 0 : ShaderHelper.dopplegangerBar;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ShaderCallback getBossBarShaderCallback(boolean background, int shader) {
        if (this.shaderCallback == null) {
            this.shaderCallback = shader1 -> {
                int grainIntensityUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader1, (CharSequence)"grainIntensity");
                int hpFractUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader1, (CharSequence)"hpFract");
                float time = this.getInvulTime();
                float grainIntensity = time > 20.0f ? 1.0f : Math.max(this.hardMode ? 0.5f : 0.0f, time / 20.0f);
                ARBShaderObjects.glUniform1fARB((int)grainIntensityUniform, (float)grainIntensity);
                ARBShaderObjects.glUniform1fARB((int)hpFractUniform, (float)(this.func_110143_aJ() / this.func_110138_aP()));
            };
        }
        return background ? null : this.shaderCallback;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.playerCount);
        buffer.writeBoolean(this.hardMode);
        buffer.writeLong(this.source.func_177986_g());
        buffer.writeLong(this.bossInfoUUID.getMostSignificantBits());
        buffer.writeLong(this.bossInfoUUID.getLeastSignificantBits());
    }

    @SideOnly(value=Side.CLIENT)
    public void readSpawnData(ByteBuf additionalData) {
        this.playerCount = additionalData.readInt();
        this.hardMode = additionalData.readBoolean();
        this.source = BlockPos.func_177969_a((long)additionalData.readLong());
        long msb = additionalData.readLong();
        long lsb = additionalData.readLong();
        this.bossInfoUUID = new UUID(msb, lsb);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new DopplegangerMusic(this));
    }

    private static class BeaconBeamComponent
    extends MultiblockComponent {
        public BeaconBeamComponent(BlockPos relPos) {
            super(relPos, Blocks.field_150461_bJ.func_176223_P());
        }

        @Override
        public boolean matches(World world, BlockPos pos) {
            return world.func_175625_s(pos) instanceof TileEntityBeacon;
        }
    }

    private static class BeaconComponent
    extends MultiblockComponent {
        public BeaconComponent(BlockPos relPos) {
            super(relPos, Blocks.field_150339_S.func_176223_P());
        }

        @Override
        public boolean matches(World world, BlockPos pos) {
            return world.func_180495_p(pos).func_177230_c().isBeaconBase((IBlockAccess)world, pos, pos.func_177971_a((Vec3i)new BlockPos(-this.relPos.func_177958_n(), -this.relPos.func_177956_o(), -this.relPos.func_177952_p())));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class DopplegangerMusic
    extends MovingSound {
        private final EntityDoppleganger guardian;

        public DopplegangerMusic(EntityDoppleganger guardian) {
            super(guardian.hardMode ? ModSounds.gaiaMusic2 : ModSounds.gaiaMusic1, SoundCategory.RECORDS);
            this.guardian = guardian;
            this.field_147660_d = guardian.getSource().func_177958_n();
            this.field_147661_e = guardian.getSource().func_177956_o();
            this.field_147658_f = guardian.getSource().func_177952_p();
            this.field_147659_g = true;
        }

        public void func_73660_a() {
            if (!this.guardian.func_70089_S()) {
                this.field_147668_j = true;
            }
        }
    }
}

