/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.endergy.conduit;

import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.conduits.conduit.AbstractItemConduit;
import crazypants.enderio.conduits.conduit.power.IPowerConduit;
import crazypants.enderio.conduits.conduit.power.IPowerConduitData;
import crazypants.enderio.conduits.conduit.power.PowerConduit;
import crazypants.enderio.endergy.conduit.EndergyPowerConduitData;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEndergyConduit
extends AbstractItemConduit {
    public static ItemEndergyConduit create(@Nonnull IModObject modObject) {
        return new ItemEndergyConduit(modObject);
    }

    protected ItemEndergyConduit(@Nonnull IModObject modObject) {
        super(modObject, EndergyPowerConduitData.createSubTypes(modObject));
    }

    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return IPowerConduit.class;
    }

    public IServerConduit createConduit(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        return new PowerConduit(IPowerConduitData.Registry.fromID((int)EndergyPowerConduitData.damage2id(stack.func_77952_i())));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        int cap = PowerConduit.getMaxEnergyIO((IPowerConduitData)IPowerConduitData.Registry.fromID((int)EndergyPowerConduitData.damage2id(itemStack.func_77952_i())));
        String prefix = EnderIO.lang.localize("power.max_output") + " ";
        list.add(prefix + LangPower.RFt((int)cap));
    }

    public boolean shouldHideFacades(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        return true;
    }
}

