/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public class VanillaFurnaceRecipeHandler
implements IRecipeHandler {
    private static final VanillaFurnaceRecipeHandler INSTANCE = new VanillaFurnaceRecipeHandler();
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_INPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_OUTPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    private List<IRecipeDefinition> recipes = null;

    private VanillaFurnaceRecipeHandler() {
    }

    public static VanillaFurnaceRecipeHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return COMPONENTS_INPUT;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return COMPONENTS_OUTPUT;
    }

    public boolean isValidSizeInput(IngredientComponent component, int size) {
        return component == IngredientComponent.ITEMSTACK && size == 1;
    }

    public List<IRecipeDefinition> getRecipes() {
        if (this.recipes != null) {
            return this.recipes;
        }
        this.recipes = Lists.newArrayList((Iterable)Collections2.transform(FurnaceRecipes.func_77602_a().func_77599_b().entrySet(), (Function)new Function<Map.Entry<ItemStack, ItemStack>, IRecipeDefinition>(){

            @Nullable
            public IRecipeDefinition apply(Map.Entry<ItemStack, ItemStack> input) {
                return RecipeDefinition.ofIngredient(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, input.getKey(), 7)}), MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, input.getValue()));
            }
        }));
        return this.recipes;
    }

    @Override
    @Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        List<ItemStack> recipeIngredients = input.getInstances(IngredientComponent.ITEMSTACK);
        if (input.getComponents().size() != 1 || recipeIngredients.size() != 1) {
            return null;
        }
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(recipeIngredients.get(0));
        return MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, result);
    }
}

