/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.itemhandler;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemHandlerItemStackIterator;

public abstract class SlotlessItemHandlerWrapper
implements ISlotlessItemHandler {
    protected final IItemHandler itemHandler;

    public SlotlessItemHandlerWrapper(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    protected abstract int getNonFullSlotWithItemStack(@Nonnull ItemStack var1, int var2);

    protected abstract int getNonEmptySlotWithItemStack(@Nonnull ItemStack var1, int var2);

    protected abstract Iterator<Integer> getSlotsWithItemStack(@Nonnull ItemStack var1, int var2);

    protected abstract int getEmptySlot();

    protected abstract int getNonEmptySlot();

    @Override
    public Iterator<ItemStack> getItems() {
        return new ItemHandlerItemStackIterator(this.itemHandler);
    }

    @Override
    public Iterator<ItemStack> findItems(@Nonnull ItemStack stack, int matchFlags) {
        return Iterators.transform(this.getSlotsWithItemStack(stack, matchFlags), (Function)new Function<Integer, ItemStack>(){

            @Nullable
            public ItemStack apply(@Nullable Integer input) {
                return SlotlessItemHandlerWrapper.this.itemHandler.getStackInSlot(input.intValue());
            }
        });
    }

    @Override
    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
        int slot = this.getNonFullSlotWithItemStack(stack, 7);
        if (slot < 0) {
            slot = this.getEmptySlot();
        }
        if (slot < 0) {
            return stack;
        }
        return this.itemHandler.insertItem(slot, stack, simulate);
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int amount, boolean simulate) {
        int slot = this.getNonEmptySlot();
        if (slot < 0) {
            return ItemStack.field_190927_a;
        }
        return this.itemHandler.extractItem(slot, amount, simulate);
    }

    @Override
    @Nonnull
    public ItemStack extractItem(@Nonnull ItemStack matchStack, int matchFlags, boolean simulate) {
        int slot = this.getNonEmptySlotWithItemStack(matchStack, matchFlags);
        if (slot < 0) {
            return ItemStack.field_190927_a;
        }
        return this.itemHandler.extractItem(slot, matchStack.func_190916_E(), simulate);
    }

    @Override
    public int getLimit() {
        int total = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            total += this.itemHandler.getSlotLimit(i);
        }
        return total;
    }
}

