/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.MessageTagManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.TriFunction;

public class Emotes
extends MessageTagManager.DefaultMessageTag {
    public static final String NAME = "emotes";
    public static final TriFunction<Client, String, String, Emotes> FUNCTION = (client, name, value) -> new Emotes((String)name, (String)value);
    private final List<Emote> emotes;

    private Emotes(@Nonnull String name, @Nullable String value) {
        super(name, value);
        if (value == null) {
            this.emotes = Collections.emptyList();
        } else {
            String[] emotesSplit;
            ArrayList<Emote> emotes = new ArrayList<Emote>();
            for (String emoteInfo : emotesSplit = value.split("/")) {
                String[] indicesSplit;
                int emoteId;
                String[] emoteAndIndices = emoteInfo.split(":");
                if (emoteAndIndices.length < 2) continue;
                try {
                    emoteId = Integer.parseInt(emoteAndIndices[0]);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                for (String indices : indicesSplit = emoteAndIndices[1].split(",")) {
                    int lastIndex;
                    int firstIndex;
                    String[] split = indices.split("-");
                    if (split.length < 2) continue;
                    try {
                        firstIndex = Integer.parseInt(split[0]);
                        lastIndex = Integer.parseInt(split[1]);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    emotes.add(new Emote(emoteId, firstIndex, lastIndex));
                }
            }
            this.emotes = Collections.unmodifiableList(emotes);
        }
    }

    @Nonnull
    public List<Emote> getEmotes() {
        return this.emotes;
    }

    @Override
    @Nonnull
    protected ToStringer toStringer() {
        return super.toStringer().add(NAME, this.emotes);
    }

    public class Emote {
        private final int id;
        private final int firstIndex;
        private final int lastIndex;

        private Emote(int id, int firstIndex, int lastIndex) {
            this.id = id;
            this.firstIndex = firstIndex;
            this.lastIndex = lastIndex;
        }

        public int getId() {
            return this.id;
        }

        public int getFirstIndex() {
            return this.firstIndex;
        }

        public int getLastIndex() {
            return this.lastIndex;
        }

        @Nonnull
        public String toString() {
            return new ToStringer(this).add("id", this.id).add("firstIndex", this.firstIndex).add("lastIndex", this.lastIndex).toString();
        }
    }
}

