/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;

public enum CaseMapping {
    ASCII('Z'),
    RFC1459('^'),
    STRICT_RFC1459(']');

    private static final Map<String, CaseMapping> nameMap;
    private final char upperbound;

    @Nonnull
    public static Optional<CaseMapping> getByName(@Nullable String name) {
        return name == null ? Optional.empty() : Optional.ofNullable(nameMap.get(name.toUpperCase()));
    }

    private CaseMapping(char upperbound) {
        this.upperbound = upperbound;
    }

    public boolean areEqualIgnoringCase(@Nonnull String one, @Nonnull String two) {
        return this.toLowerCase(one).equals(this.toLowerCase(two));
    }

    @Nonnull
    public String toLowerCase(@Nonnull String input) {
        Sanity.nullCheck(input, "Input cannot be null");
        char[] arr = input.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char c = arr[i];
            if (c < 'A' || c > this.upperbound) continue;
            int n = i;
            arr[n] = (char)(arr[n] + 32);
        }
        return new String(arr);
    }

    static {
        nameMap = new HashMap<String, CaseMapping>();
        for (CaseMapping caseMapping : CaseMapping.values()) {
            nameMap.put(caseMapping.name().replace('_', '-'), caseMapping);
        }
    }
}

