/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client;

import java.util.List;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase.ServerMessageEventBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class NickRejectedEvent
extends ServerMessageEventBase {
    private final String attemptedNick;
    private String newNick;

    public NickRejectedEvent(@Nonnull Client client, @Nonnull List<ServerMessage> originalMessages, @Nonnull String attemptedNick, @Nonnull String newNick) {
        super(client, originalMessages);
        this.attemptedNick = Sanity.nullCheck(attemptedNick, "Attempted nick cannot be null");
        this.newNick = Sanity.nullCheck(newNick, "New nick cannot be null");
    }

    @Nonnull
    public String getAttemptedNick() {
        return this.attemptedNick;
    }

    @Nonnull
    public String getNewNick() {
        return this.newNick;
    }

    public void setNewNick(@Nonnull String newNick) {
        Sanity.safeMessageCheck(newNick, "Nick");
        Sanity.truthiness(!newNick.equals(this.attemptedNick), "Cannot set new nick to the currently failing nick");
        Sanity.truthiness(!newNick.contains(" "), "Nick cannot contain spaces");
        this.newNick = newNick;
    }

    @Override
    @Nonnull
    protected ToStringer toStringer() {
        return super.toStringer().add("attemptedNick", this.attemptedNick).add("newNick", this.newNick);
    }
}

