/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.net.engio.mbassy.bus.MBassador;
import net.creeperhost.minetogether.net.engio.mbassy.bus.config.BusConfiguration;
import net.creeperhost.minetogether.net.engio.mbassy.bus.config.Feature;
import net.creeperhost.minetogether.net.engio.mbassy.bus.error.IPublicationErrorHandler;
import net.creeperhost.minetogether.net.engio.mbassy.bus.error.PublicationError;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientConnectionEndedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.helper.ClientEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehEventException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehNagException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehServerMessageException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.EventManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.CommandFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.EchoMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.FilterProcessor;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.FilteringSubscriptionFactory;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.NumericFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.ToSelfOnly;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class DefaultEventManager
implements EventManager {
    private final MBassador<Object> bus;
    private final Client client;
    private final Map<Class<? extends Annotation>, FilterProcessor<?, ? extends Annotation>> filters = new ConcurrentHashMap();
    private final Set<Object> listeners = new HashSet<Object>();

    public DefaultEventManager(@Nonnull Client client) {
        BusConfiguration configuration = new BusConfiguration().addFeature(Feature.SyncPubSub.Default().setSubscriptionFactory(new FilteringSubscriptionFactory(this.filters))).addFeature(Feature.AsynchronousHandlerInvocation.Default()).addFeature(Feature.AsynchronousMessageDispatch.Default()).addPublicationErrorHandler(new Exceptional(client));
        this.bus = new MBassador(configuration);
        this.client = client;
        this.registerAnnotationFilter(CommandFilter.class, new CommandFilter.Processor());
        this.registerAnnotationFilter(EchoMessage.class, new EchoMessage.Processor());
        this.registerAnnotationFilter(NumericFilter.class, new NumericFilter.Processor());
        this.registerAnnotationFilter(ToSelfOnly.class, new ToSelfOnly.Processor());
        this.registerEventListener(this);
    }

    @Override
    public void callEvent(@Nonnull Object event) {
        Sanity.nullCheck(event, "Event cannot be null");
        if (event instanceof ClientEvent) {
            Sanity.truthiness(((ClientEvent)event).getClient() == this.client, "Event cannot be from another client!");
        }
        this.bus.publish(event);
    }

    @Override
    @Nonnull
    public synchronized Set<Object> getRegisteredEventListeners() {
        return new HashSet<Object>(this.listeners);
    }

    @Override
    @Nonnull
    public Map<Class<? extends Annotation>, FilterProcessor<?, ? extends Annotation>> getAnnotationFilters() {
        return Collections.unmodifiableMap(new HashMap(this.filters));
    }

    @Override
    public <A extends Annotation> void registerAnnotationFilter(Class<A> annotationClass, FilterProcessor<?, A> filterProcessor) {
        this.filters.put(annotationClass, filterProcessor);
    }

    @Override
    public synchronized void registerEventListener(@Nonnull Object listener) {
        Sanity.nullCheck(listener, "Listener cannot be null");
        this.listeners.add(listener);
        this.bus.subscribe(listener);
    }

    @Override
    public synchronized void unregisterEventListener(@Nonnull Object listener) {
        Sanity.nullCheck(listener, "Listener cannot be null");
        this.listeners.remove(listener);
        this.bus.unsubscribe(listener);
    }

    @Handler(priority=-2147483648)
    public void onShutdown(ClientConnectionEndedEvent event) {
        if (!event.canAttemptReconnect()) {
            this.bus.shutdown();
        }
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).add("client", this.client).toString();
    }

    public static class Exceptional
    implements IPublicationErrorHandler {
        private final Client client;

        public Exceptional(@Nonnull Client client) {
            this.client = client;
        }

        @Override
        public void handleError(@Nonnull PublicationError publicationError) {
            Throwable thrown = publicationError.getCause();
            Exception exceptional = thrown instanceof InvocationTargetException && thrown.getCause() instanceof KittehServerMessageException ? (KittehServerMessageException)thrown.getCause() : (thrown instanceof InvocationTargetException && thrown.getCause() instanceof KittehNagException ? (KittehNagException)thrown.getCause() : new KittehEventException(thrown));
            this.client.getExceptionListener().queue(exceptional);
        }

        @Nonnull
        public String toString() {
            return new ToStringer(this).toString();
        }
    }
}

