/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.equipment;

import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.core.IHasClickToggle;
import com.lothrazar.cyclicmagic.registry.MaterialRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilPlayer;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGlowingHelmet
extends ItemArmor
implements IHasRecipe,
IHasClickToggle {
    public static final String NBT_GLOW = "cyclicmagic_glow";
    private static final String NBT_STATUS = "onoff";

    public ItemGlowingHelmet(EntityEquipmentSlot armorType) {
        super(MaterialRegistry.glowingArmorMaterial, 0, armorType);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        boolean isTurnedOn = this.isOn(itemStack);
        ItemGlowingHelmet.setGlowing(player, isTurnedOn);
        if (isTurnedOn) {
            this.setNightVision(player);
        }
    }

    private void setNightVision(EntityPlayer player) {
        player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 400, 0));
    }

    public static void setGlowing(EntityPlayer player, boolean hidden) {
        player.func_184195_f(hidden);
        player.getEntityData().func_74757_a(NBT_GLOW, hidden);
        player.func_184596_c(MobEffects.field_76439_r);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack held, World player, List<String> list, ITooltipFlag par4) {
        list.add(UtilChat.lang(this.func_77658_a() + ".tooltip"));
        String onoff = this.isOn(held) ? "on" : "off";
        list.add(UtilChat.lang("item.cantoggle.tooltip.info") + " " + UtilChat.lang("item.cantoggle.tooltip." + onoff));
        super.func_77624_a(held, player, list, par4);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "ioi", "o o", "   ", Character.valueOf('i'), "dyeOrange", Character.valueOf('o'), "glowstone");
    }

    @Override
    public void toggle(EntityPlayer player, ItemStack held) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
        int vnew = this.isOn(held) ? 0 : 1;
        tags.func_74768_a(NBT_STATUS, vnew);
    }

    @Override
    public boolean isOn(ItemStack held) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
        if (!tags.func_74764_b(NBT_STATUS)) {
            return true;
        }
        return tags.func_74762_e(NBT_STATUS) == 1;
    }

    private void checkIfHelmOff(EntityPlayer player) {
        Item itemInSlot = UtilPlayer.getItemArmorSlot(player, EntityEquipmentSlot.HEAD);
        if (player.getEntityData().func_74767_n(NBT_GLOW) && itemInSlot == this) {
            ItemGlowingHelmet.setGlowing(player, false);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.func_82737_E() % 20L == 0L && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            this.checkIfHelmOff(player);
        }
    }
}

