/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.core;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.lothrazar.cyclicmagic.item.core.BaseItem;
import com.lothrazar.cyclicmagic.item.core.IHasClickToggle;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles", striprefs=true)
public abstract class BaseCharm
extends BaseItem
implements IHasClickToggle,
IBauble {
    private static final String NBT_STATUS = "onoff";

    public BaseCharm(int durability) {
        this.func_77625_d(1);
        this.func_77656_e(durability);
    }

    @Override
    public void toggle(EntityPlayer player, ItemStack held) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
        int vnew = this.isOn(held) ? 0 : 1;
        tags.func_74768_a(NBT_STATUS, vnew);
    }

    @Override
    public boolean isOn(ItemStack held) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
        if (!tags.func_74764_b(NBT_STATUS)) {
            return true;
        }
        return tags.func_74762_e(NBT_STATUS) == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.canTick(stack);
    }

    public boolean canTick(ItemStack stack) {
        return this.isOn(stack) && stack.func_77952_i() < stack.func_77958_k();
    }

    public void damageCharm(EntityPlayer living, ItemStack stack) {
        UtilItemStack.damageItem(living, stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityPlayer) {
            this.onTick(stack, (EntityPlayer)entityIn);
        }
    }

    public IRecipe addRecipe(ItemStack craftItem) {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "r x", "id ", "iir", Character.valueOf('x'), craftItem, Character.valueOf('d'), "gemDiamond", Character.valueOf('r'), "cropNetherWart", Character.valueOf('i'), "ingotIron");
    }

    public abstract void onTick(ItemStack var1, EntityPlayer var2);

    @Optional.Method(modid="baubles")
    public boolean canEquip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public boolean canUnequip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack arg0) {
        try {
            if (BaubleType.values().length >= 4) {
                return BaubleType.TRINKET;
            }
            return BaubleType.RING;
        }
        catch (Exception e) {
            return BaubleType.RING;
        }
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    @Optional.Method(modid="baubles")
    public void onUnequipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase plr) {
        if (!this.canTick(stack)) {
            return;
        }
        if (plr instanceof EntityPlayer && !stack.func_190926_b() && stack.func_190916_E() > 0) {
            this.onTick(stack, (EntityPlayer)plr);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack held, World player, List<String> list, ITooltipFlag par4) {
        super.func_77624_a(held, player, list, par4);
        String onoff = this.isOn(held) ? "on" : "off";
        list.add(UtilChat.lang("item.cantoggle.tooltip.info") + UtilChat.lang("item.cantoggle.tooltip." + onoff));
    }
}

