/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.core.BaseTool;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemProspector
extends BaseTool
implements IHasRecipe,
IContent {
    private static final int DURABILITY = 2000;
    private static final int COOLDOWN = 12;
    private static int range = 16;
    private boolean isBlacklist;
    private String[] blocklist;
    private boolean enabled;

    public ItemProspector() {
        super(2000);
    }

    @Override
    public void register() {
        ItemRegistry.register(this, "tool_prospector");
        LootTableRegistry.registerLoot(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldObj, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (side == null || pos == null) {
            return super.func_180614_a(player, worldObj, pos, hand, side, hitX, hitY, hitZ);
        }
        HashMap<String, Integer> mapList = new HashMap<String, Integer>();
        EnumFacing direction = side.func_176734_d();
        for (int i = 0; i < range; ++i) {
            ItemStack s;
            Block blockAt;
            BlockPos current = pos.func_177967_a(direction, i);
            IBlockState at = worldObj.func_180495_p(current);
            if (at == null || (blockAt = at.func_177230_c()) == null || at == Blocks.field_150350_a || !this.isBlockShowable(s = new ItemStack(Item.func_150898_a((Block)blockAt), 1, blockAt.func_176201_c(at)))) continue;
            String name = s.func_82833_r();
            int previous = mapList.containsKey(name) ? (Integer)mapList.get(name) : 0;
            mapList.put(name, previous + 1);
        }
        if (worldObj.field_72995_K) {
            if (mapList.size() == 0) {
                UtilChat.addChatMessage(player, UtilChat.lang("tool_prospector.none") + range);
            }
            for (Map.Entry entry : mapList.entrySet()) {
                UtilChat.addChatMessage(player, UtilChat.lang("tool_prospector.found") + (String)entry.getKey() + " " + entry.getValue());
            }
        }
        UtilEntity.setCooldownItem(player, this, 12);
        super.onUse(stack, player, worldObj, hand);
        return super.func_180614_a(player, worldObj, pos, hand, side, hitX, hitY, hitZ);
    }

    public boolean isBlockShowable(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        String itemName = UtilItemStack.getStringForItemStack(stack);
        String itemSimpleName = UtilItemStack.getStringForItem(stack.func_77973_b());
        boolean isInList = false;
        for (String s : this.blocklist) {
            if (s == null || !s.equals(itemName) && !s.equals(itemSimpleName)) continue;
            isInList = true;
            break;
        }
        boolean yesShowIt = this.isBlacklist ? !isInList : isInList;
        return yesShowIt;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "  g", " i ", "b  ", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), new ItemStack(Items.field_151072_bj), Character.valueOf('g'), "blockGlassLightBlue");
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("Prospector", "cyclicmagic.content", true, "Set false to delete - requires restart");
        String category = "modpacks";
        range = config.getInt("ProspectorRange", category, 32, 2, 256, "Block Range it will search onclick");
        this.isBlacklist = config.getBoolean("ProspectorIsBlacklist", category, true, "True means this (ProspectorBlockList) is a blacklist, ignore whats listed. False means its a whitelist: only print whats listed.");
        String[] deflist = new String[]{"minecraft:air", "minecraft:grass", "minecraft:dirt/0", "minecraft:dirt/1", "minecraft:stone", "minecraft:gravel", "minecraft:sand", "minecraft:bedrock"};
        this.blocklist = config.getStringList("ProspectorBlockList", category, deflist, "List of blocks that the Prospector knows about.");
    }
}

