/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.enchant;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.enchant.BaseEnchant;
import com.lothrazar.cyclicmagic.guide.GuideRegistry;
import com.lothrazar.cyclicmagic.net.PacketPlayerFalldamage;
import com.lothrazar.cyclicmagic.registry.EnchantRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnchantLaunch
extends BaseEnchant {
    private static final float LAUNCH_POWER = 1.05f;
    private static final int ROTATIONPITCH = 70;
    private static final int COOLDOWN = 60;
    private static final String NBT_USES = "launchuses";
    private boolean enabled;

    public EnchantLaunch() {
        super("launch", Enchantment.Rarity.COMMON, EnumEnchantmentType.ARMOR, new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET});
        GuideRegistry.register(this, new ArrayList<String>(Arrays.asList("60")));
    }

    @Override
    public void register() {
        EnchantRegistry.register(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("EnchantLaunch", "cyclicmagic.content", true, "Set false to delete - requires restart");
    }

    public int func_77325_b() {
        return 5;
    }

    public boolean func_92089_a(ItemStack stack) {
        boolean yes = stack.func_77973_b() == Items.field_151122_aG || stack.func_77973_b() instanceof ItemElytra || stack.func_77973_b() instanceof ItemArmor && ((ItemArmor)stack.func_77973_b()).field_77881_a == EntityEquipmentSlot.FEET;
        return yes;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.func_92089_a(stack);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)event.getEntity();
            ItemStack armorStack = this.getFirstArmorStackWithEnchant((EntityLivingBase)p);
            if (armorStack.func_190926_b()) {
                return;
            }
            if ((!p.field_70160_al || p.field_70122_E) && UtilNBT.getItemStackNBTVal(armorStack, NBT_USES) > 0) {
                UtilNBT.setItemStackNBTVal(armorStack, NBT_USES, 0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        EntityPlayer player = ModCyclic.proxy.getClientPlayer();
        if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityBoat) {
            return;
        }
        ItemStack feet = this.getFirstArmorStackWithEnchant((EntityLivingBase)player);
        if (feet == null || feet.func_190926_b() || player.func_70093_af()) {
            return;
        }
        if (!EnchantmentHelper.func_82781_a((ItemStack)feet).containsKey(this)) {
            return;
        }
        if (player.func_184811_cZ().func_185141_a(feet.func_77973_b())) {
            return;
        }
        if (FMLClientHandler.instance().getClient().field_71474_y.field_74314_A.func_151470_d() && player.field_70163_u < player.field_70137_T && player.field_70160_al && !player.func_70090_H()) {
            int level = (Integer)EnchantmentHelper.func_82781_a((ItemStack)feet).get(this);
            int uses = UtilNBT.getItemStackNBTVal(feet, NBT_USES);
            player.field_70143_R = 0.0f;
            float angle = player.field_70159_w == 0.0 && player.field_70179_y == 0.0 ? 90.0f : 70.0f;
            UtilEntity.launch((Entity)player, angle, 1.05f);
            UtilParticle.spawnParticle(player.func_130014_f_(), EnumParticleTypes.CRIT_MAGIC, player.func_180425_c());
            UtilSound.playSound(player, player.func_180425_c(), SoundRegistry.enchant_launch, SoundCategory.PLAYERS, 0.04f);
            UtilItemStack.damageItem(player, feet);
            if (++uses >= level) {
                if (!feet.func_190926_b()) {
                    UtilEntity.setCooldownItem(player, feet.func_77973_b(), 60);
                }
                uses = 0;
            }
            UtilNBT.setItemStackNBTVal(feet, NBT_USES, uses);
            player.field_70143_R = 0.0f;
            ModCyclic.network.sendToServer((IMessage)new PacketPlayerFalldamage());
        }
    }
}

