/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.enchant;

import com.lothrazar.cyclicmagic.enchant.BaseEnchant;
import com.lothrazar.cyclicmagic.guide.GuideRegistry;
import com.lothrazar.cyclicmagic.registry.EnchantRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantAutoSmelt
extends BaseEnchant {
    private boolean enabled;

    public EnchantAutoSmelt() {
        super("autosmelt", Enchantment.Rarity.RARE, EnumEnchantmentType.DIGGER, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        GuideRegistry.register(this, new ArrayList<String>());
    }

    @Override
    public void register() {
        EnchantRegistry.register(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("EnchantAutoSmelt", "cyclicmagic.content", true, "Set false to delete - requires restart");
    }

    public int func_77325_b() {
        return 1;
    }

    public boolean func_77326_a(Enchantment ench) {
        return ench != Enchantments.field_185306_r && ench != Enchantments.field_185308_t && super.func_77326_a(ench);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null) {
            return;
        }
        int level = this.getCurrentLevelTool((EntityLivingBase)event.getHarvester());
        if (level <= 0) {
            return;
        }
        if (event.isSilkTouching()) {
            return;
        }
        List drops = event.getDrops();
        ArrayList<ItemStack> dropsCopy = new ArrayList<ItemStack>();
        for (ItemStack drop : drops) {
            dropsCopy.add(drop.func_77946_l());
        }
        drops.clear();
        for (ItemStack drop : dropsCopy) {
            ItemStack fromSmelted = FurnaceRecipes.func_77602_a().func_151395_a(drop).func_77946_l();
            if (!fromSmelted.func_190926_b()) {
                if (fromSmelted.func_190916_E() == 0) {
                    fromSmelted.func_190920_e(1);
                }
                drops.add(fromSmelted);
                continue;
            }
            drops.add(drop);
        }
    }
}

