/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.hydrator;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeHydrate
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static final int FLUID_DEFAULT = 25;
    public static ArrayList<RecipeHydrate> recipes = new ArrayList();
    private NonNullList<ItemStack> recipeInput = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private ItemStack resultItem = ItemStack.field_190927_a;
    private int fluidCost = 25;
    private int size = 0;

    public RecipeHydrate(ItemStack in, ItemStack out) {
        this(new ItemStack[]{in}, out, 25);
    }

    public RecipeHydrate(ItemStack[] in, ItemStack out) {
        this(in, out, 25);
    }

    public RecipeHydrate(ItemStack[] in, ItemStack out, int w) {
        if (in.length > 4 || in.length == 0) {
            throw new IllegalArgumentException("Input array must be length 4 or less");
        }
        for (ItemStack itemStack : in) {
            if (itemStack == null || itemStack.func_190926_b()) continue;
            this.recipeInput.set(this.size, (Object)itemStack);
            ++this.size;
        }
        this.fluidCost = w;
        this.resultItem = out;
        this.setRegistryName(new ResourceLocation("cyclicmagic", "hydrator_" + UUID.randomUUID().toString() + out.func_77977_a()));
    }

    public int getSize() {
        return this.size;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        this.sanityCheckInput();
        int countFull = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            ++countFull;
        }
        if (countFull != this.size) {
            return false;
        }
        boolean match0 = RecipeHydrate.recipeSlotMatches(inv.func_70301_a(0), (ItemStack)this.recipeInput.get(0));
        boolean match1 = RecipeHydrate.recipeSlotMatches(inv.func_70301_a(1), (ItemStack)this.recipeInput.get(1));
        boolean match2 = RecipeHydrate.recipeSlotMatches(inv.func_70301_a(2), (ItemStack)this.recipeInput.get(2));
        boolean match3 = RecipeHydrate.recipeSlotMatches(inv.func_70301_a(3), (ItemStack)this.recipeInput.get(3));
        boolean all = match0 && match1 && match2 && match3;
        return all;
    }

    private void sanityCheckInput() {
        for (int i = 0; i < this.recipeInput.size(); ++i) {
            ItemStack s = (ItemStack)this.recipeInput.get(i);
            if (s.func_190926_b() || s.func_77960_j() != Short.MAX_VALUE) continue;
            ItemStack snew = new ItemStack(s.func_77973_b(), 1, 0);
            snew.func_77982_d(s.func_77978_p());
            this.recipeInput.set(i, (Object)snew);
        }
    }

    public static boolean recipeSlotMatches(ItemStack sInvo, ItemStack sRecipe) {
        if (sInvo.func_190926_b() != sRecipe.func_190926_b()) {
            return false;
        }
        return sInvo.func_190916_E() >= sRecipe.func_190916_E() && (sInvo.func_77969_a(sRecipe) || OreDictionary.itemMatches((ItemStack)sInvo, (ItemStack)sRecipe, (boolean)false));
    }

    public boolean tryPayCost(IInventory invoSource, FluidTank tank, boolean keepOneMinimum) {
        int i;
        if (tank.getFluidAmount() < this.getFluidCost()) {
            return false;
        }
        int minimum = keepOneMinimum ? 2 : 1;
        for (i = 0; i < this.recipeInput.size(); ++i) {
            if (((ItemStack)this.recipeInput.get(i)).func_190926_b() || invoSource.func_70301_a(i).func_190916_E() >= ((ItemStack)this.recipeInput.get(i)).func_190916_E() + (minimum - 1)) continue;
            return false;
        }
        for (i = 0; i < this.recipeInput.size(); ++i) {
            if (((ItemStack)this.recipeInput.get(i)).func_190926_b()) continue;
            invoSource.func_70298_a(i, ((ItemStack)this.recipeInput.get(i)).func_190916_E());
        }
        tank.drain(this.getFluidCost(), true);
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.resultItem.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width <= 2 && height <= 2;
    }

    public ItemStack func_77571_b() {
        return this.resultItem.func_77946_l();
    }

    public List<ItemStack> getRecipeInput() {
        return this.recipeInput;
    }

    public int getFluidCost() {
        return this.fluidCost;
    }

    public void setFluidCost(int fluidCost) {
        this.fluidCost = fluidCost;
    }

    public static void initAllRecipes() {
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150458_ak)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack((Block)Blocks.field_150329_H, 1, 1), new ItemStack(Blocks.field_150346_d), new ItemStack((Block)Blocks.field_150329_H, 1, 1), new ItemStack(Blocks.field_150346_d)}, new ItemStack((Block)Blocks.field_150349_c, 2)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack((Block)Blocks.field_150349_c), new ItemStack(Blocks.field_185774_da)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Items.field_151118_aC), new ItemStack(Items.field_151119_aD)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_150348_b, 1, 0), new ItemStack(Blocks.field_150347_e, 1, 0)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_150347_e, 1, 0), new ItemStack(Blocks.field_150341_Y, 1, 0)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_150463_bK, 1, 0), new ItemStack(Blocks.field_150463_bK, 1, 1)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_150417_aV, 1, 0), new ItemStack(Blocks.field_150417_aV, 1, 1)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_150405_ch), new ItemStack(Blocks.field_150435_aG)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Items.field_151145_ak)}, new ItemStack(Blocks.field_150351_n)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack(Blocks.field_150346_d, 1, 1), new ItemStack(Blocks.field_150419_aX), new ItemStack(Blocks.field_150420_aW), new ItemStack(Blocks.field_185774_da)}, new ItemStack((Block)Blocks.field_150391_bh)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack(Blocks.field_150433_aE), new ItemStack(Blocks.field_150433_aE), new ItemStack(Blocks.field_150433_aE), new ItemStack(Blocks.field_150433_aE)}, new ItemStack(Blocks.field_150432_aD)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack(Blocks.field_150432_aD), new ItemStack(Blocks.field_150432_aD), new ItemStack(Blocks.field_150432_aD), new ItemStack(Blocks.field_150432_aD)}, new ItemStack(Blocks.field_150403_cj)));
        for (EnumDyeColor col : EnumDyeColor.values()) {
            RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192444_dS, 1, col.func_176765_a()), new ItemStack(Blocks.field_192443_dR, 1, col.func_176765_a())));
        }
        for (EnumDyeColor col : EnumDyeColor.values()) {
            if (col.func_176765_a() == EnumDyeColor.WHITE.func_176765_a()) continue;
            RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_150325_L, 1, col.func_176765_a()), new ItemStack(Blocks.field_150325_L, 1, EnumDyeColor.WHITE.func_176765_a())));
        }
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192442_dQ), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.BLACK.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192438_dM), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.BLUE.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192439_dN), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.BROWN.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192436_dK), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.CYAN.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192440_dO), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.GREEN.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192430_dE), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.LIGHT_BLUE.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192432_dG), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.LIME.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192429_dD), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.MAGENTA.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192428_dC), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.ORANGE.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192433_dH), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.PINK.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192437_dL), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.PURPLE.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192441_dP), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.RED.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192435_dJ), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.SILVER.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192427_dB), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.WHITE.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack(Blocks.field_192431_dF), new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.YELLOW.func_176765_a())));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack(Blocks.field_150325_L, 1, EnumDyeColor.YELLOW.func_176765_a()), new ItemStack(Items.field_151123_aH), new ItemStack(Items.field_179562_cC), new ItemStack(Blocks.field_150425_aM)}, new ItemStack(Blocks.field_150360_v)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack(Blocks.field_150321_G), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151103_aS)}, new ItemStack(Blocks.field_150321_G, 4)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_191525_da), new ItemStack(Items.field_151130_bT), new ItemStack(Items.field_151119_aD)}, new ItemStack(Items.field_179562_cC)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack(Items.field_179562_cC), new ItemStack(Items.field_151114_aO), new ItemStack(Items.field_179562_cC), new ItemStack(Items.field_179562_cC)}, new ItemStack(Items.field_179563_cD)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack(Blocks.field_150424_aL), new ItemStack(Items.field_151042_j, 3), new ItemStack(Items.field_151130_bT), new ItemStack(Items.field_151065_br)}, new ItemStack(Items.field_151129_at)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack((Block)Blocks.field_150434_aF), new ItemStack(Blocks.field_150395_bd), new ItemStack((Block)Blocks.field_150329_H, 1, 1), new ItemStack(Items.field_151014_N)}, new ItemStack(Blocks.field_150392_bi, 2)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack((Block)Blocks.field_150338_P), new ItemStack((Block)Blocks.field_150338_P), new ItemStack((Block)Blocks.field_150338_P), new ItemStack((Block)Blocks.field_150338_P)}, new ItemStack(Blocks.field_150420_aW)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack((Block)Blocks.field_150337_Q), new ItemStack((Block)Blocks.field_150337_Q), new ItemStack((Block)Blocks.field_150337_Q), new ItemStack((Block)Blocks.field_150337_Q)}, new ItemStack(Blocks.field_150419_aX)));
        RecipeHydrate.addRecipe(new RecipeHydrate(new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m), new ItemStack((Block)Blocks.field_150354_m), new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.RED.func_176767_b())}, new ItemStack((Block)Blocks.field_150354_m, 1, BlockSand.EnumType.RED_SAND.ordinal())));
    }

    public static void addRecipe(RecipeHydrate rec) {
        recipes.add(rec);
    }
}

